/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import org.jacorb.trading.constraint.BooleanValue;
import org.jacorb.trading.constraint.CharValue;
import org.jacorb.trading.constraint.DoubleValue;
import org.jacorb.trading.constraint.FloatValue;
import org.jacorb.trading.constraint.LongValue;
import org.jacorb.trading.constraint.ShortValue;
import org.jacorb.trading.constraint.StringValue;
import org.jacorb.trading.constraint.ULongValue;
import org.jacorb.trading.constraint.UShortValue;
import org.jacorb.trading.constraint.Value;

public class ValueFactory {
    private ValueFactory() {
    }

    public static Value create(int typeId, Object value) {
        Value result = null;
        switch (typeId) {
            case 0: {
                Boolean b = (Boolean)value;
                result = ValueFactory.createBoolean(b);
                break;
            }
            case 1: {
                Integer i = (Integer)value;
                result = ValueFactory.createShort(i);
                break;
            }
            case 2: {
                Integer i = (Integer)value;
                result = ValueFactory.createUShort(i);
                break;
            }
            case 3: {
                Integer i = (Integer)value;
                result = ValueFactory.createLong(i);
                break;
            }
            case 4: {
                Long l = (Long)value;
                result = ValueFactory.createULong(l);
                break;
            }
            case 5: {
                Float f = (Float)value;
                result = ValueFactory.createFloat(f.floatValue());
                break;
            }
            case 6: {
                Double d = (Double)value;
                result = ValueFactory.createDouble(d);
                break;
            }
            case 7: {
                Character c = (Character)value;
                result = ValueFactory.createChar(c.charValue());
                break;
            }
            case 8: {
                String s = (String)value;
                result = ValueFactory.createString(s);
            }
        }
        return result;
    }

    public static Value createBoolean(boolean value) {
        return new BooleanValue(value);
    }

    public static Value createShort(int value) {
        return new ShortValue(value);
    }

    public static Value createUShort(int value) {
        return new UShortValue(value);
    }

    public static Value createLong(int value) {
        return new LongValue(value);
    }

    public static Value createULong(long value) {
        return new ULongValue(value);
    }

    public static Value createFloat(float value) {
        return new FloatValue(value);
    }

    public static Value createDouble(double value) {
        return new DoubleValue(value);
    }

    public static Value createChar(char value) {
        return new CharValue(value);
    }

    public static Value createString(String value) {
        return new StringValue(value);
    }
}

