/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueFactory;

public class UShortValue
implements Value {
    private Integer m_value;

    public UShortValue() {
        this(0);
    }

    public UShortValue(int value) {
        this.m_value = new Integer(value);
    }

    public UShortValue(Object value) {
        this.m_value = (Integer)value;
    }

    public void setValue(Object value) {
        this.m_value = (Integer)value;
    }

    public int getTypeId() {
        return 2;
    }

    public Object getValue() {
        return this.m_value;
    }

    public boolean equals(Value nv) {
        boolean result = false;
        if (nv.getTypeId() != 2) {
            throw new IllegalArgumentException();
        }
        result = this.m_value.equals(nv.getValue());
        return result;
    }

    public boolean lessThan(Value nv) {
        boolean result = false;
        if (nv.getTypeId() != 2) {
            throw new IllegalArgumentException();
        }
        Integer i = (Integer)nv.getValue();
        result = this.m_value < i;
        return result;
    }

    public boolean lessThanEqual(Value nv) {
        return this.lessThan(nv) || this.equals(nv);
    }

    public boolean greaterThan(Value nv) {
        return !this.lessThan(nv) && !this.equals(nv);
    }

    public boolean greaterThanEqual(Value nv) {
        return !this.lessThan(nv);
    }

    public Value plus(Value nv) {
        UShortValue result = null;
        if (nv.getTypeId() != 2) {
            throw new IllegalArgumentException();
        }
        Integer i = (Integer)nv.getValue();
        result = new UShortValue(this.m_value + i);
        return result;
    }

    public Value minus(Value nv) {
        Value result = null;
        if (nv.getTypeId() == 2) {
            Integer i = (Integer)nv.getValue();
            int val = this.m_value - i;
            result = val < 0 ? ValueFactory.createLong(val) : new UShortValue(val);
        } else {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public Value multiply(Value nv) {
        Value result = null;
        if (nv.getTypeId() != 2) {
            throw new IllegalArgumentException();
        }
        Integer i = (Integer)nv.getValue();
        result = ValueFactory.createULong(this.m_value * i);
        return result;
    }

    public Value divide(Value nv) {
        UShortValue result = null;
        if (nv.getTypeId() != 2) {
            throw new IllegalArgumentException();
        }
        Integer i = (Integer)nv.getValue();
        result = new UShortValue(this.m_value / i);
        return result;
    }

    public Value negate() {
        return ValueFactory.createLong(-1 * this.m_value);
    }

    public Value convert(int typeId) {
        Value result = null;
        switch (typeId) {
            case 2: {
                result = new UShortValue(this.m_value);
                break;
            }
            case 3: {
                result = ValueFactory.createLong(this.m_value);
                break;
            }
            case 4: {
                result = ValueFactory.createULong(this.m_value.longValue());
                break;
            }
            case 5: {
                result = ValueFactory.createFloat(this.m_value.floatValue());
                break;
            }
            case 6: {
                result = ValueFactory.createDouble(this.m_value.doubleValue());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result;
    }

    public String toString() {
        return this.m_value.toString();
    }
}

