/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueFactory;

public class ULongValue
implements Value {
    private Long m_value;

    public ULongValue() {
        this(0L);
    }

    public ULongValue(long value) {
        this.m_value = new Long(value);
    }

    public ULongValue(Object value) {
        this.m_value = (Long)value;
    }

    public void setValue(Object value) {
        this.m_value = (Long)value;
    }

    public int getTypeId() {
        return 4;
    }

    public Object getValue() {
        return this.m_value;
    }

    public boolean equals(Value nv) {
        boolean result = false;
        if (nv.getTypeId() != 4) {
            throw new IllegalArgumentException();
        }
        result = this.m_value.equals(nv.getValue());
        return result;
    }

    public boolean lessThan(Value nv) {
        boolean result = false;
        if (nv.getTypeId() != 4) {
            throw new IllegalArgumentException();
        }
        Long l = (Long)nv.getValue();
        result = this.m_value < l;
        return result;
    }

    public boolean lessThanEqual(Value nv) {
        return this.lessThan(nv) || this.equals(nv);
    }

    public boolean greaterThan(Value nv) {
        return !this.lessThan(nv) && !this.equals(nv);
    }

    public boolean greaterThanEqual(Value nv) {
        return !this.lessThan(nv);
    }

    public Value plus(Value nv) {
        ULongValue result = null;
        if (nv.getTypeId() != 4) {
            throw new IllegalArgumentException();
        }
        Long l = (Long)nv.getValue();
        result = new ULongValue(this.m_value + l);
        return result;
    }

    public Value minus(Value nv) {
        Value result = null;
        if (nv.getTypeId() == 4) {
            Long l = (Long)nv.getValue();
            long val = this.m_value - l;
            result = val < 0L ? ValueFactory.createLong((int)val) : new ULongValue(val);
        } else {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public Value multiply(Value nv) {
        Value result = null;
        if (nv.getTypeId() != 4) {
            throw new IllegalArgumentException();
        }
        Long l = (Long)nv.getValue();
        result = ValueFactory.createULong(this.m_value * l);
        return result;
    }

    public Value divide(Value nv) {
        ULongValue result = null;
        if (nv.getTypeId() != 4) {
            throw new IllegalArgumentException();
        }
        Long l = (Long)nv.getValue();
        result = new ULongValue(this.m_value / l);
        return result;
    }

    public Value negate() {
        return ValueFactory.createLong(-1 * this.m_value.intValue());
    }

    public Value convert(int typeId) {
        Value result = null;
        switch (typeId) {
            case 3: {
                result = ValueFactory.createLong(this.m_value.intValue());
                break;
            }
            case 4: {
                result = new ULongValue(this.m_value);
                break;
            }
            case 5: {
                result = ValueFactory.createFloat(this.m_value.floatValue());
                break;
            }
            case 6: {
                result = ValueFactory.createDouble(this.m_value.doubleValue());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result;
    }

    public String toString() {
        return this.m_value.toString();
    }
}

