/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import java.io.StringReader;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import org.jacorb.trading.constraint.Expression;
import org.jacorb.trading.constraint.Lex;
import org.jacorb.trading.constraint.ParseException;
import org.jacorb.trading.constraint.PropertySchema;
import org.jacorb.trading.constraint.PropertySource;
import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueType;

public class Preference {
    private PropertySchema m_schema;
    private Expression m_expr;
    private ValueType m_exprType;
    private int m_prefType = 29;

    private Preference() {
    }

    public Preference(PropertySchema schema) {
        this.m_schema = schema;
    }

    public void parse(String pref) throws ParseException {
        StringReader reader = new StringReader(pref);
        Lex lex = new Lex(reader);
        this.m_prefType = lex.getToken();
        switch (this.m_prefType) {
            case 25: 
            case 26: {
                this.m_expr = new Expression(this.m_schema);
                lex.nextToken();
                this.m_exprType = this.m_expr.parse(lex);
                if (this.m_exprType.isNumber() && !this.m_exprType.isSequence()) break;
                throw new ParseException("min/max preference expression must be numeric");
            }
            case 27: {
                this.m_expr = new Expression(this.m_schema);
                lex.nextToken();
                this.m_exprType = this.m_expr.parse(lex);
                if (ValueType.isCompatible(this.m_exprType.getId(), 0) && !this.m_exprType.isSequence()) break;
                throw new ParseException("with preference expression must be boolean");
            }
            case 28: 
            case 29: {
                break;
            }
            case 1: {
                this.m_prefType = 29;
                break;
            }
            default: {
                throw new ParseException("invalid preference expression");
            }
        }
    }

    public Vector order(Vector sources) {
        Vector result = null;
        switch (this.m_prefType) {
            case 25: {
                result = this.orderMin(sources);
                break;
            }
            case 26: {
                result = this.orderMax(sources);
                break;
            }
            case 27: {
                result = this.orderWith(sources);
                break;
            }
            case 28: {
                result = this.orderRandom(sources);
                break;
            }
            case 29: {
                result = this.orderFirst(sources);
            }
        }
        return result;
    }

    protected Vector orderMin(Vector sources) {
        Vector<PropertySource> result = new Vector<PropertySource>();
        Vector temp = (Vector)sources.clone();
        Vector<SourceValue> values = new Vector<SourceValue>();
        Enumeration e = sources.elements();
        while (e.hasMoreElements()) {
            PropertySource src = (PropertySource)e.nextElement();
            Value v = this.m_expr.evaluate(src);
            if (v == null) continue;
            Enumeration n = values.elements();
            int pos = 0;
            while (n.hasMoreElements()) {
                SourceValue sv = (SourceValue)n.nextElement();
                if (v.lessThan(sv.value)) break;
                ++pos;
            }
            values.insertElementAt(new SourceValue(src, v), pos);
            temp.removeElement(src);
        }
        e = values.elements();
        while (e.hasMoreElements()) {
            SourceValue sv = (SourceValue)e.nextElement();
            result.addElement(sv.source);
        }
        e = temp.elements();
        while (e.hasMoreElements()) {
            result.addElement((PropertySource)e.nextElement());
        }
        return result;
    }

    protected Vector orderMax(Vector sources) {
        Vector<PropertySource> result = new Vector<PropertySource>();
        Vector temp = (Vector)sources.clone();
        Vector<SourceValue> values = new Vector<SourceValue>();
        Enumeration e = sources.elements();
        while (e.hasMoreElements()) {
            PropertySource src = (PropertySource)e.nextElement();
            Value v = this.m_expr.evaluate(src);
            if (v == null) continue;
            Enumeration n = values.elements();
            int pos = 0;
            while (n.hasMoreElements()) {
                SourceValue sv = (SourceValue)n.nextElement();
                if (v.greaterThan(sv.value)) break;
                ++pos;
            }
            values.insertElementAt(new SourceValue(src, v), pos);
            temp.removeElement(src);
        }
        e = values.elements();
        while (e.hasMoreElements()) {
            SourceValue sv = (SourceValue)e.nextElement();
            result.addElement(sv.source);
        }
        e = temp.elements();
        while (e.hasMoreElements()) {
            result.addElement((PropertySource)e.nextElement());
        }
        return result;
    }

    protected Vector orderWith(Vector sources) {
        Vector<PropertySource> result = new Vector<PropertySource>();
        Vector temp = (Vector)sources.clone();
        Enumeration e = sources.elements();
        while (e.hasMoreElements()) {
            Boolean b;
            PropertySource src = (PropertySource)e.nextElement();
            Value v = this.m_expr.evaluate(src);
            if (v == null || !(b = (Boolean)v.getValue()).booleanValue()) continue;
            result.addElement(src);
            temp.removeElement(src);
        }
        e = temp.elements();
        while (e.hasMoreElements()) {
            result.addElement((PropertySource)e.nextElement());
        }
        return result;
    }

    protected Vector orderRandom(Vector sources) {
        Vector<PropertySource> result = new Vector<PropertySource>();
        int entries = sources.size();
        PropertySource[] arr = new PropertySource[entries];
        sources.copyInto(arr);
        Random rand = new Random();
        int count = 0;
        while (count < entries) {
            int idx = Math.abs(rand.nextInt()) % entries;
            if (arr[idx] == null) continue;
            result.addElement(arr[idx]);
            arr[idx] = null;
            ++count;
        }
        return result;
    }

    protected Vector orderFirst(Vector sources) {
        return sources;
    }

    protected class SourceValue {
        public PropertySource source;
        public Value value;

        public SourceValue(PropertySource src, Value nv) {
            this.source = src;
            this.value = nv;
        }
    }
}

