/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import java.io.PrintStream;
import org.jacorb.trading.constraint.ExprNode;
import org.jacorb.trading.constraint.MissingPropertyException;
import org.jacorb.trading.constraint.PropertyNode;
import org.jacorb.trading.constraint.PropertySource;
import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueFactory;
import org.jacorb.trading.constraint.ValueType;

public class InNode
extends ExprNode {
    private ExprNode m_left;
    private ExprNode m_right;

    private InNode() {
    }

    public InNode(ExprNode left, ExprNode right) {
        this.m_left = left;
        this.m_right = right;
        this.setType(new ValueType(0));
    }

    public void print(PrintStream ps) {
        ps.println("InNode: type = " + this.getType());
        ps.println("Left node:");
        this.m_left.print(ps);
        ps.println("Right node:");
        this.m_right.print(ps);
    }

    public Value evaluate(PropertySource source) throws MissingPropertyException {
        Value result = null;
        PropertyNode prop = (PropertyNode)this.m_right;
        Value left = this.m_left.evaluate(source);
        result = ValueFactory.createBoolean(prop.inSequence(left, source));
        return result;
    }
}

