/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueFactory;

public class FloatValue
implements Value {
    private Float m_value;

    public FloatValue() {
        this(0.0f);
    }

    public FloatValue(float value) {
        this.m_value = new Float(value);
    }

    public FloatValue(Object value) {
        this.m_value = (Float)value;
    }

    public void setValue(Object value) {
        this.m_value = (Float)value;
    }

    public int getTypeId() {
        return 5;
    }

    public Object getValue() {
        return this.m_value;
    }

    public boolean equals(Value nv) {
        boolean result = false;
        if (nv.getTypeId() != 5) {
            throw new IllegalArgumentException();
        }
        result = this.m_value.equals(nv.getValue());
        return result;
    }

    public boolean lessThan(Value nv) {
        boolean result = false;
        if (nv.getTypeId() != 5) {
            throw new IllegalArgumentException();
        }
        Float f = (Float)nv.getValue();
        result = this.m_value.floatValue() < f.floatValue();
        return result;
    }

    public boolean lessThanEqual(Value nv) {
        return this.lessThan(nv) || this.equals(nv);
    }

    public boolean greaterThan(Value nv) {
        return !this.lessThan(nv) && !this.equals(nv);
    }

    public boolean greaterThanEqual(Value nv) {
        return !this.lessThan(nv);
    }

    public Value plus(Value nv) {
        FloatValue result = null;
        if (nv.getTypeId() != 5) {
            throw new IllegalArgumentException();
        }
        Float f = (Float)nv.getValue();
        result = new FloatValue(this.m_value.floatValue() + f.floatValue());
        return result;
    }

    public Value minus(Value nv) {
        FloatValue result = null;
        if (nv.getTypeId() != 5) {
            throw new IllegalArgumentException();
        }
        Float f = (Float)nv.getValue();
        result = new FloatValue(this.m_value.floatValue() - f.floatValue());
        return result;
    }

    public Value multiply(Value nv) {
        FloatValue result = null;
        if (nv.getTypeId() != 5) {
            throw new IllegalArgumentException();
        }
        Float f = (Float)nv.getValue();
        result = new FloatValue(this.m_value.floatValue() * f.floatValue());
        return result;
    }

    public Value divide(Value nv) {
        FloatValue result = null;
        if (nv.getTypeId() != 5) {
            throw new IllegalArgumentException();
        }
        Float f = (Float)nv.getValue();
        result = new FloatValue(this.m_value.floatValue() / f.floatValue());
        return result;
    }

    public Value negate() {
        FloatValue result = null;
        result = new FloatValue(-1.0f * this.m_value.floatValue());
        return result;
    }

    public Value convert(int typeId) {
        Value result = null;
        switch (typeId) {
            case 5: {
                result = new FloatValue(this.m_value);
                break;
            }
            case 6: {
                result = ValueFactory.createDouble(this.m_value.doubleValue());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result;
    }

    public String toString() {
        return this.m_value.toString();
    }
}

