/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import org.jacorb.trading.constraint.AddNode;
import org.jacorb.trading.constraint.AndNode;
import org.jacorb.trading.constraint.DivideNode;
import org.jacorb.trading.constraint.EqNode;
import org.jacorb.trading.constraint.ExistNode;
import org.jacorb.trading.constraint.ExprNode;
import org.jacorb.trading.constraint.GeNode;
import org.jacorb.trading.constraint.GtNode;
import org.jacorb.trading.constraint.InNode;
import org.jacorb.trading.constraint.LeNode;
import org.jacorb.trading.constraint.Lex;
import org.jacorb.trading.constraint.LiteralNode;
import org.jacorb.trading.constraint.LtNode;
import org.jacorb.trading.constraint.MissingPropertyException;
import org.jacorb.trading.constraint.MultiplyNode;
import org.jacorb.trading.constraint.NegNode;
import org.jacorb.trading.constraint.NeqNode;
import org.jacorb.trading.constraint.NotNode;
import org.jacorb.trading.constraint.OrNode;
import org.jacorb.trading.constraint.ParseException;
import org.jacorb.trading.constraint.PropertyNode;
import org.jacorb.trading.constraint.PropertySchema;
import org.jacorb.trading.constraint.PropertySource;
import org.jacorb.trading.constraint.SubstrNode;
import org.jacorb.trading.constraint.SubtractNode;
import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueType;

public class Expression {
    private PropertySchema m_schema;
    private ExprNode m_root;

    private Expression() {
    }

    public Expression(PropertySchema schema) {
        this.m_schema = schema;
    }

    public ValueType parse(Lex lex) throws ParseException {
        this.m_root = null;
        this.m_root = this.parseBoolOr(lex);
        if (this.m_root == null) {
            throw new ParseException("invalid input");
        }
        if (lex.getToken() != 1) {
            throw new ParseException("unexpected input");
        }
        return this.m_root.getType();
    }

    public Value evaluate(PropertySource source) {
        Value result = null;
        try {
            result = this.m_root.evaluate(source);
        }
        catch (MissingPropertyException e) {
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return result;
    }

    protected ExprNode parseBoolean(Lex lex) throws ParseException {
        LiteralNode result = null;
        int token = lex.getToken();
        if (token == 21 || token == 22) {
            result = new LiteralNode(0, lex.getLexeme());
            lex.nextToken();
        }
        return result;
    }

    protected ExprNode parseString(Lex lex) throws ParseException {
        LiteralNode result = null;
        int token = lex.getToken();
        if (token == 23) {
            result = new LiteralNode(2, lex.getLexeme());
            lex.nextToken();
        }
        return result;
    }

    protected ExprNode parseNumber(Lex lex) throws ParseException {
        LiteralNode result = null;
        int token = lex.getToken();
        if (token == 24) {
            result = new LiteralNode(1, lex.getLexeme());
            lex.nextToken();
        }
        return result;
    }

    protected ExprNode parseFactor(Lex lex) throws ParseException {
        ExprNode result = null;
        int token = lex.getToken();
        if (token == 2) {
            lex.nextToken();
            result = this.parseBoolOr(lex);
            if (lex.getToken() != 3) {
                throw new ParseException("missing closing parenthesis");
            }
            lex.nextToken();
        } else if (token == 4) {
            lex.nextToken();
            ExprNode ident = this.parseIdent(lex, false);
            if (ident == null) {
                throw new ParseException("operand to 'exist' must be a property");
            }
            result = new ExistNode(ident);
        } else if (token == 20) {
            result = this.parseIdent(lex, true);
        } else if (token == 24) {
            result = this.parseNumber(lex);
        } else if (token == 5) {
            lex.nextToken();
            ExprNode arg = null;
            if (lex.getToken() == 24) {
                arg = this.parseNumber(lex);
            } else if (lex.getToken() == 20) {
                arg = this.parseIdent(lex, true);
            }
            if (arg == null) {
                throw new ParseException("operand to unary '-' must be a number");
            }
            result = new NegNode(arg);
        } else if (token == 23) {
            result = this.parseString(lex);
        } else if (token == 21 || token == 22) {
            result = this.parseBoolean(lex);
        } else {
            throw new ParseException("unexpected factor '" + lex.getLexeme() + "'");
        }
        return result;
    }

    protected ExprNode parseFactorNot(Lex lex) throws ParseException {
        ExprNode result = null;
        int token = lex.getToken();
        if (token == 6) {
            lex.nextToken();
            ExprNode child = this.parseFactor(lex);
            ValueType childType = child.getType();
            if (!ValueType.isCompatible(childType.getId(), 0) || childType.isSequence()) {
                throw new ParseException("operand to 'not' must be a boolean expression");
            }
            result = new NotNode(child);
        } else {
            result = this.parseFactor(lex);
        }
        return result;
    }

    protected ExprNode parseTerm(Lex lex) throws ParseException {
        ExprNode result = this.parseFactorNot(lex);
        int token = lex.getToken();
        while (token == 7 || token == 8) {
            String op = lex.getLexeme();
            lex.nextToken();
            ExprNode right = this.parseFactorNot(lex);
            if (!result.getType().isNumber() || !right.getType().isNumber() || result.getType().isSequence() || right.getType().isSequence()) {
                throw new ParseException("operands to '" + op + "' must be numeric");
            }
            if (!ValueType.isCompatible(result.getType().getId(), right.getType().getId())) {
                throw new ParseException("operands to '" + op + "' are not compatible");
            }
            result = token == 7 ? new MultiplyNode(result, right) : new DivideNode(result, right);
            token = lex.getToken();
        }
        return result;
    }

    protected ExprNode parseExpr(Lex lex) throws ParseException {
        ExprNode result = this.parseTerm(lex);
        int token = lex.getToken();
        while (token == 9 || token == 5) {
            String op = lex.getLexeme();
            lex.nextToken();
            ExprNode right = this.parseTerm(lex);
            if (!result.getType().isNumber() || !right.getType().isNumber() || result.getType().isSequence() || right.getType().isSequence()) {
                throw new ParseException("operands to '" + op + "' must be numeric");
            }
            if (!ValueType.isCompatible(result.getType().getId(), right.getType().getId())) {
                throw new ParseException("operands to '" + op + "' are not compatible");
            }
            result = token == 9 ? new AddNode(result, right) : new SubtractNode(result, right);
            token = lex.getToken();
        }
        return result;
    }

    protected ExprNode parseIdent(Lex lex, boolean checkType) throws ParseException {
        PropertyNode result = null;
        int token = lex.getToken();
        if (token == 20) {
            String property = lex.getLexeme();
            ValueType type = this.m_schema.getPropertyType(property);
            if (type == null) {
                if (checkType) {
                    throw new ParseException("unknown property '" + property + "'");
                }
                type = new ValueType(9);
            }
            result = new PropertyNode(property, type);
            lex.nextToken();
        }
        return result;
    }

    protected ExprNode parseExprTwiddle(Lex lex) throws ParseException {
        ExprNode result = this.parseExpr(lex);
        int token = lex.getToken();
        if (token == 10) {
            lex.nextToken();
            ExprNode right = this.parseExpr(lex);
            if (!ValueType.isCompatible(result.getType().getId(), 8) || !ValueType.isCompatible(right.getType().getId(), 8)) {
                throw new ParseException("operands to '~' must be strings");
            }
            if (result.getType().isSequence() || right.getType().isSequence()) {
                throw new ParseException("sequence not allowed as operand to '~'");
            }
            result = new SubstrNode(result, right);
        }
        return result;
    }

    protected ExprNode parseExprIn(Lex lex) throws ParseException {
        ExprNode result = this.parseExprTwiddle(lex);
        int token = lex.getToken();
        if (token == 11) {
            lex.nextToken();
            ExprNode right = this.parseIdent(lex, true);
            if (right == null) {
                throw new ParseException("right operand to 'in' must be a property");
            }
            if (!right.getType().isSequence()) {
                throw new ParseException("right operand to 'in' must be a sequence property");
            }
            if (!ValueType.isCompatible(result.getType().getId(), right.getType().getId())) {
                throw new ParseException("operands to 'in' are not compatible");
            }
            result = new InNode(result, right);
        }
        return result;
    }

    protected ExprNode parseBoolCompare(Lex lex) throws ParseException {
        ExprNode result = this.parseExprIn(lex);
        int token = lex.getToken();
        if (token == 12) {
            lex.nextToken();
            ExprNode right = this.parseExprIn(lex);
            if (!ValueType.isCompatible(result.getType().getId(), right.getType().getId()) || result.getType().isSequence() || right.getType().isSequence()) {
                throw new ParseException("operands to '==' are not compatible");
            }
            result = new EqNode(result, right);
        } else if (token == 13) {
            lex.nextToken();
            ExprNode right = this.parseExprIn(lex);
            if (!ValueType.isCompatible(result.getType().getId(), right.getType().getId()) || result.getType().isSequence() || right.getType().isSequence()) {
                throw new ParseException("operands to '!=' are not compatible");
            }
            result = new NeqNode(result, right);
        } else if (token == 14) {
            lex.nextToken();
            ExprNode right = this.parseExprIn(lex);
            if (!ValueType.isCompatible(result.getType().getId(), right.getType().getId()) || result.getType().isSequence() || right.getType().isSequence()) {
                throw new ParseException("operands to '<' are not compatible");
            }
            result = new LtNode(result, right);
        } else if (token == 15) {
            lex.nextToken();
            ExprNode right = this.parseExprIn(lex);
            if (!ValueType.isCompatible(result.getType().getId(), right.getType().getId()) || result.getType().isSequence() || right.getType().isSequence()) {
                throw new ParseException("operands to '<=' are not compatible");
            }
            result = new LeNode(result, right);
        } else if (token == 16) {
            lex.nextToken();
            ExprNode right = this.parseExprIn(lex);
            if (!ValueType.isCompatible(result.getType().getId(), right.getType().getId()) || result.getType().isSequence() || right.getType().isSequence()) {
                throw new ParseException("operands to '>' are not compatible");
            }
            result = new GtNode(result, right);
        } else if (token == 17) {
            lex.nextToken();
            ExprNode right = this.parseExprIn(lex);
            if (!ValueType.isCompatible(result.getType().getId(), right.getType().getId()) || result.getType().isSequence() || right.getType().isSequence()) {
                throw new ParseException("operands to '>=' are not compatible");
            }
            result = new GeNode(result, right);
        }
        return result;
    }

    protected ExprNode parseBoolAnd(Lex lex) throws ParseException {
        ExprNode result = this.parseBoolCompare(lex);
        while (lex.getToken() == 18) {
            lex.nextToken();
            ExprNode right = this.parseBoolCompare(lex);
            if (!ValueType.isCompatible(result.getType().getId(), 0) || !ValueType.isCompatible(right.getType().getId(), 0) || result.getType().isSequence() || right.getType().isSequence()) {
                throw new ParseException("operands to 'and' must be boolean expressions");
            }
            result = new AndNode(result, right);
        }
        return result;
    }

    protected ExprNode parseBoolOr(Lex lex) throws ParseException {
        ExprNode result = this.parseBoolAnd(lex);
        while (lex.getToken() == 19) {
            lex.nextToken();
            ExprNode right = this.parseBoolAnd(lex);
            if (!ValueType.isCompatible(result.getType().getId(), 0) || !ValueType.isCompatible(right.getType().getId(), 0) || result.getType().isSequence() || right.getType().isSequence()) {
                throw new ParseException("operands to 'or' must be boolean expressions");
            }
            result = new OrNode(result, right);
        }
        return result;
    }
}

