/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueFactory;

public class CharValue
implements Value {
    private Character m_value;

    public CharValue() {
        this('\u0000');
    }

    public CharValue(char value) {
        this.m_value = new Character(value);
    }

    public CharValue(Object value) {
        this.m_value = (Character)value;
    }

    public void setValue(Object value) {
        this.m_value = (Character)value;
    }

    public int getTypeId() {
        return 7;
    }

    public Object getValue() {
        return this.m_value;
    }

    public boolean equals(Value nv) {
        boolean result = false;
        if (nv.getTypeId() != 7) {
            throw new IllegalArgumentException();
        }
        result = this.m_value.equals(nv.getValue());
        return result;
    }

    public boolean lessThan(Value nv) {
        boolean result = false;
        if (nv.getTypeId() != 7) {
            throw new IllegalArgumentException();
        }
        Character c = (Character)nv.getValue();
        result = this.m_value.charValue() < c.charValue();
        return result;
    }

    public boolean lessThanEqual(Value nv) {
        return this.lessThan(nv) || this.equals(nv);
    }

    public boolean greaterThan(Value nv) {
        return !this.lessThan(nv) && !this.equals(nv);
    }

    public boolean greaterThanEqual(Value nv) {
        return !this.lessThan(nv);
    }

    public Value plus(Value nv) {
        throw new ArithmeticException();
    }

    public Value minus(Value nv) {
        throw new ArithmeticException();
    }

    public Value multiply(Value nv) {
        throw new ArithmeticException();
    }

    public Value divide(Value nv) {
        throw new ArithmeticException();
    }

    public Value negate() {
        throw new ArithmeticException();
    }

    public Value convert(int typeId) {
        Value result = null;
        if (typeId == 7) {
            result = new CharValue(this.m_value);
        } else if (typeId == 8) {
            char[] arr = new char[]{this.m_value.charValue()};
            String s = new String(arr);
            result = ValueFactory.createString(s);
        } else {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public String toString() {
        return this.m_value.toString();
    }
}

