/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import java.io.PrintStream;
import org.jacorb.trading.constraint.ExprNode;
import org.jacorb.trading.constraint.MissingPropertyException;
import org.jacorb.trading.constraint.PropertySource;
import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueType;

public class AddNode
extends ExprNode {
    private ExprNode m_left;
    private ExprNode m_right;

    private AddNode() {
    }

    public AddNode(ExprNode left, ExprNode right) {
        this.m_left = left;
        this.m_right = right;
        int id = ValueType.promote(left.getType().getId(), right.getType().getId());
        this.setType(new ValueType(id));
    }

    public void print(PrintStream ps) {
        ps.println("AddNode: type = " + this.getType());
        ps.println("Left node:");
        this.m_left.print(ps);
        ps.println("Right node:");
        this.m_right.print(ps);
    }

    public Value evaluate(PropertySource source) throws MissingPropertyException {
        Value result = null;
        int id = this.getType().getId();
        Value v = this.m_left.evaluate(source);
        Value left = v.convert(id);
        v = this.m_right.evaluate(source);
        Value right = v.convert(id);
        result = left.plus(right);
        return result;
    }
}

