/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.client.util;

import java.io.PrintWriter;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynSequence;
import org.omg.DynamicAny.DynSequenceHelper;

public class AnyUtil {
    private AnyUtil() {
    }

    public static void print(ORB _orb, PrintWriter pw, Any val) {
        ORB orb = _orb;
        try {
            TypeCode tc = val.type();
            while (tc.kind() == TCKind.tk_alias) {
                tc = tc.content_type();
            }
            TCKind kind = tc.kind();
            if (kind == TCKind.tk_sequence) {
                AnyUtil.printSequence(_orb, pw, val);
            }
            switch (kind.value()) {
                case 2: {
                    short s = val.extract_short();
                    pw.print(s);
                    break;
                }
                case 3: {
                    int l = val.extract_long();
                    pw.print(l);
                    break;
                }
                case 4: {
                    short i = val.extract_ushort();
                    pw.print(i);
                    break;
                }
                case 5: {
                    long l = val.extract_ulong();
                    pw.print(l);
                    break;
                }
                case 6: {
                    float f = val.extract_float();
                    pw.print(f);
                    break;
                }
                case 7: {
                    double d = val.extract_double();
                    pw.print(d);
                    break;
                }
                case 8: {
                    boolean b = val.extract_boolean();
                    pw.print(b);
                    break;
                }
                case 9: {
                    char c = val.extract_char();
                    pw.print(c);
                    break;
                }
                case 18: {
                    String s = val.extract_string();
                    pw.print("'" + s + "'");
                    break;
                }
                case 10: {
                    byte b = val.extract_octet();
                    pw.print(b);
                    break;
                }
                case 14: {
                    Object obj = val.extract_Object();
                    if (obj == null) {
                        pw.print("nil");
                        break;
                    }
                    _orb.object_to_string(obj);
                }
            }
        }
        catch (BadKind e) {
            e.printStackTrace();
        }
        catch (BAD_OPERATION e) {
            e.printStackTrace();
        }
    }

    public static void print(PrintWriter pw, TypeCode tc) {
        try {
            TCKind kind = tc.kind();
            switch (kind.value()) {
                case 14: {
                    pw.print("interface " + tc.name());
                    break;
                }
                case 21: {
                    pw.print("typedef ");
                    TypeCode content = tc.content_type();
                    AnyUtil.printName(pw, content);
                    pw.print(" " + tc.name());
                    break;
                }
                case 18: {
                    pw.print("string");
                    int len = tc.length();
                    if (len != 0) {
                        pw.print("<" + len + ">");
                    }
                    break;
                }
                case 19: {
                    pw.print("sequence<");
                    TypeCode content = tc.content_type();
                    AnyUtil.printName(pw, content);
                    int len = tc.length();
                    if (len != 0) {
                        pw.print(", " + len);
                    }
                    pw.print(">");
                    break;
                }
                case 20: {
                    TypeCode content = tc.content_type();
                    AnyUtil.printName(pw, content);
                    int len = tc.length();
                    pw.print("[" + len + "]");
                    break;
                }
                default: {
                    AnyUtil.printKind(pw, kind);
                }
            }
        }
        catch (BadKind e) {
            e.printStackTrace();
        }
    }

    protected static void printSequence(ORB orb, PrintWriter pw, Any val) {
        try {
            TypeCode tc = val.type();
            while (tc.kind() == TCKind.tk_alias) {
                tc = tc.content_type();
            }
            TypeCode contentTC = tc.content_type();
            TCKind kind = contentTC.kind();
            DynAnyFactory factory = DynAnyFactoryHelper.narrow(orb.resolve_initial_references("DynAnyFactory"));
            DynAny da = factory.create_dyn_any(val);
            DynSequence ds = DynSequenceHelper.narrow(da);
            int len = ds.get_length();
            switch (kind.value()) {
                case 2: {
                    for (int i = 0; i < len; ++i) {
                        pw.print(ds.current_component().get_short());
                        if (i < len - 1) {
                            pw.print(", ");
                        }
                        ds.next();
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < len; ++i) {
                        pw.print(ds.current_component().get_long());
                        if (i < len - 1) {
                            pw.print(", ");
                        }
                        ds.next();
                    }
                    break;
                }
                case 4: {
                    for (int i = 0; i < len; ++i) {
                        pw.print(ds.current_component().get_ushort());
                        if (i < len - 1) {
                            pw.print(", ");
                        }
                        ds.next();
                    }
                    break;
                }
                case 5: {
                    for (int i = 0; i < len; ++i) {
                        pw.print(ds.current_component().get_ulong());
                        if (i < len - 1) {
                            pw.print(", ");
                        }
                        ds.next();
                    }
                    break;
                }
                case 6: {
                    for (int i = 0; i < len; ++i) {
                        pw.print(ds.current_component().get_float());
                        if (i < len - 1) {
                            pw.print(", ");
                        }
                        ds.next();
                    }
                    break;
                }
                case 7: {
                    for (int i = 0; i < len; ++i) {
                        pw.print(ds.current_component().get_double());
                        if (i < len - 1) {
                            pw.print(", ");
                        }
                        ds.next();
                    }
                    break;
                }
                case 8: {
                    for (int i = 0; i < len; ++i) {
                        pw.print(ds.current_component().get_boolean());
                        if (i < len - 1) {
                            pw.print(", ");
                        }
                        ds.next();
                    }
                    break;
                }
                case 9: {
                    for (int i = 0; i < len; ++i) {
                        pw.print(ds.current_component().get_char());
                        if (i < len - 1) {
                            pw.print(", ");
                        }
                        ds.next();
                    }
                    break;
                }
                case 18: {
                    for (int i = 0; i < len; ++i) {
                        pw.print("'" + ds.current_component().get_string() + "'");
                        if (i < len - 1) {
                            pw.print(", ");
                        }
                        ds.next();
                    }
                    break;
                }
                case 10: {
                    for (int i = 0; i < len; ++i) {
                        pw.print(ds.current_component().get_octet());
                        if (i < len - 1) {
                            pw.print(", ");
                        }
                        ds.next();
                    }
                    break;
                }
                case 14: {
                    for (int i = 0; i < len; ++i) {
                        Object obj = ds.current_component().get_reference();
                        if (obj == null) {
                            pw.println("nil");
                        } else {
                            orb.object_to_string(obj);
                        }
                        if (i < len - 1) {
                            pw.println();
                        }
                        ds.next();
                    }
                    break;
                }
            }
            da.destroy();
        }
        catch (BadKind e) {
            e.printStackTrace();
        }
        catch (InvalidName e) {
            e.printStackTrace();
        }
        catch (TypeMismatch e) {
            e.printStackTrace();
        }
        catch (InvalidValue e) {
            e.printStackTrace();
        }
        catch (InconsistentTypeCode e) {
            e.printStackTrace();
        }
        catch (BAD_OPERATION e) {
            e.printStackTrace();
        }
    }

    protected static void printName(PrintWriter pw, TypeCode tc) {
        try {
            TCKind kind = tc.kind();
            switch (kind.value()) {
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 21: 
                case 22: {
                    pw.print(tc.name());
                    break;
                }
                case 18: {
                    pw.print("string");
                    int len = tc.length();
                    if (len != 0) {
                        pw.print("<" + len + ">");
                    }
                    break;
                }
                case 19: {
                    pw.print("sequence<");
                    TypeCode content = tc.content_type();
                    AnyUtil.printName(pw, content);
                    int len = tc.length();
                    if (len != 0) {
                        pw.print(", " + len);
                    }
                    pw.print(">");
                    break;
                }
                case 20: {
                    TypeCode content = tc.content_type();
                    AnyUtil.printName(pw, content);
                    int len = tc.length();
                    pw.print("[" + len + "]");
                }
                default: {
                    AnyUtil.printKind(pw, kind);
                }
            }
        }
        catch (BadKind e) {
            e.printStackTrace();
        }
    }

    protected static void printKind(PrintWriter pw, TCKind kind) {
        switch (kind.value()) {
            case 0: {
                pw.print("null");
                break;
            }
            case 1: {
                pw.print("void");
                break;
            }
            case 2: {
                pw.print("short");
                break;
            }
            case 3: {
                pw.print("long");
                break;
            }
            case 4: {
                pw.print("unsigned short");
                break;
            }
            case 5: {
                pw.print("unsigned long");
                break;
            }
            case 6: {
                pw.print("float");
                break;
            }
            case 7: {
                pw.print("double");
                break;
            }
            case 8: {
                pw.print("boolean");
                break;
            }
            case 9: {
                pw.print("char");
                break;
            }
            case 10: {
                pw.print("octet");
                break;
            }
            case 11: {
                pw.print("any");
                break;
            }
            case 12: {
                pw.print("TypeCode");
                break;
            }
            case 13: {
                pw.print("Principal");
                break;
            }
            case 14: {
                pw.print("Object");
                break;
            }
            case 15: {
                pw.print("struct");
                break;
            }
            case 16: {
                pw.print("union");
                break;
            }
            case 17: {
                pw.print("enum");
                break;
            }
            case 18: {
                pw.print("string");
                break;
            }
            case 19: {
                pw.print("sequence");
                break;
            }
            case 20: {
                pw.print("array");
                break;
            }
            case 21: {
                pw.print("alias");
                break;
            }
            case 22: {
                pw.print("exception");
                break;
            }
            default: {
                pw.print("(unknown)");
            }
        }
    }
}

