/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.client.typemgr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import org.jacorb.trading.client.typemgr.LexException;

public class Lex {
    private StringBuffer m_input;
    private int m_token = 0;
    private StringBuffer m_buffer = new StringBuffer();
    private String m_lexeme = null;
    private int m_pos = 0;
    private int m_line = 1;
    private Hashtable m_literals = new Hashtable();
    private boolean m_eof = false;
    public static final int ERROR = 0;
    public static final int END = 1;
    public static final int LBRACE = 2;
    public static final int RBRACE = 3;
    public static final int LANGLE = 4;
    public static final int RANGLE = 5;
    public static final int COLON = 6;
    public static final int DOUBLECOLON = 7;
    public static final int SEMICOLON = 8;
    public static final int COMMA = 9;
    public static final int SERVICE = 10;
    public static final int INTERFACE = 11;
    public static final int IDENT = 12;
    public static final int MANDATORY = 13;
    public static final int READONLY = 14;
    public static final int PROPERTY = 15;
    public static final int UNSIGNED = 16;
    public static final int BOOLEAN = 17;
    public static final int CHAR = 18;
    public static final int SHORT = 19;
    public static final int LONG = 20;
    public static final int FLOAT = 21;
    public static final int DOUBLE = 22;
    public static final int STRING = 23;
    public static final int SEQUENCE = 24;
    public static final int OTHER = 25;

    private Lex() {
    }

    public Lex(Reader reader) {
        BufferedReader br = new BufferedReader(reader);
        this.m_input = new StringBuffer();
        boolean eof = false;
        char[] chars = new char[512];
        while (!eof) {
            try {
                int len = br.read(chars);
                if (len < 0) {
                    eof = true;
                    continue;
                }
                this.m_input.append(chars, 0, len);
            }
            catch (IOException e) {}
        }
        this.m_literals.put("service", new Integer(10));
        this.m_literals.put("interface", new Integer(11));
        this.m_literals.put("mandatory", new Integer(13));
        this.m_literals.put("readonly", new Integer(14));
        this.m_literals.put("property", new Integer(15));
        this.m_literals.put("unsigned", new Integer(16));
        this.m_literals.put("boolean", new Integer(17));
        this.m_literals.put("char", new Integer(18));
        this.m_literals.put("short", new Integer(19));
        this.m_literals.put("long", new Integer(20));
        this.m_literals.put("float", new Integer(21));
        this.m_literals.put("double", new Integer(22));
        this.m_literals.put("string", new Integer(23));
        this.m_literals.put("sequence", new Integer(24));
        this.m_literals.put("other", new Integer(25));
    }

    public void nextToken() throws LexException {
        int result = 0;
        boolean done = false;
        this.clearLexeme();
        block11: while (!done) {
            String lexeme;
            Integer val;
            char c = this.nextChar();
            if (this.eof()) {
                result = 1;
                break;
            }
            switch (c) {
                case '{': {
                    result = 2;
                    done = true;
                    this.addLexeme(c);
                    break;
                }
                case '}': {
                    result = 3;
                    done = true;
                    this.addLexeme(c);
                    break;
                }
                case '<': {
                    result = 4;
                    done = true;
                    this.addLexeme(c);
                    break;
                }
                case '>': {
                    result = 5;
                    done = true;
                    this.addLexeme(c);
                    break;
                }
                case ':': {
                    this.addLexeme(c);
                    c = this.nextChar();
                    if (c != ':') {
                        this.pushBack(c);
                        result = 6;
                        done = true;
                        break;
                    }
                    result = 7;
                    this.addLexeme(c);
                    done = true;
                    break;
                }
                case ';': {
                    result = 8;
                    done = true;
                    this.addLexeme(c);
                    break;
                }
                case ',': {
                    result = 9;
                    done = true;
                    this.addLexeme(c);
                    break;
                }
                case '/': {
                    c = this.nextChar();
                    if (c != '/') {
                        throw new LexException("expected comment", this.m_line);
                    }
                    while ((c = this.nextChar()) != '\n') {
                    }
                    continue block11;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block11;
                }
            }
            if (done) continue;
            if (c != '_' && !Character.isLetter(c)) {
                throw new LexException("unexpected input", this.m_line);
            }
            while (this.isIdent(c) && !this.eof()) {
                this.addLexeme(c);
                c = this.nextChar();
            }
            if (!this.eof()) {
                this.pushBack(c);
            }
            result = (val = (Integer)this.m_literals.get(lexeme = this.getLexeme())) == null ? 12 : val;
            done = true;
        }
        this.m_token = result;
    }

    public int getToken() {
        return this.m_token;
    }

    public String getLexeme() {
        if (this.m_lexeme == null) {
            this.m_lexeme = this.m_buffer.toString();
        }
        return this.m_lexeme;
    }

    public int getLine() {
        return this.m_line;
    }

    protected boolean eof() {
        return this.m_eof;
    }

    protected char nextChar() {
        char result = '\u0000';
        if (this.m_pos < this.m_input.length()) {
            result = this.m_input.charAt(this.m_pos);
            ++this.m_pos;
            if (result == '\n') {
                ++this.m_line;
            }
        } else {
            this.m_eof = true;
        }
        return result;
    }

    protected void pushBack(char c) {
        if (c != '\u0000') {
            --this.m_pos;
        }
    }

    protected boolean isIdent(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_';
    }

    protected void clearLexeme() {
        this.m_lexeme = null;
        this.m_buffer.setLength(0);
    }

    protected void addLexeme(char c) {
        this.m_buffer.append(c);
    }
}

