/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.client.query;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import org.jacorb.trading.client.util.AnyUtil;
import org.jacorb.trading.client.util.Constrain;
import org.jacorb.trading.client.util.QuickSort;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosTrading.DuplicatePolicyName;
import org.omg.CosTrading.DuplicatePropertyName;
import org.omg.CosTrading.IllegalConstraint;
import org.omg.CosTrading.IllegalPropertyName;
import org.omg.CosTrading.IllegalServiceType;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.LookupHelper;
import org.omg.CosTrading.LookupPackage.IllegalPolicyName;
import org.omg.CosTrading.LookupPackage.IllegalPreference;
import org.omg.CosTrading.LookupPackage.InvalidPolicyValue;
import org.omg.CosTrading.LookupPackage.PolicyTypeMismatch;
import org.omg.CosTrading.LookupPackage.SpecifiedProps;
import org.omg.CosTrading.Offer;
import org.omg.CosTrading.OfferIteratorHolder;
import org.omg.CosTrading.OfferSeqHolder;
import org.omg.CosTrading.Policy;
import org.omg.CosTrading.PolicyNameSeqHolder;
import org.omg.CosTrading.UnknownServiceType;
import org.omg.CosTradingRepos.ServiceTypeRepository;
import org.omg.CosTradingRepos.ServiceTypeRepositoryHelper;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.SpecifiedServiceTypes;

public class Query
extends Frame
implements ActionListener,
ItemListener,
Runnable {
    private Choice m_types;
    private TextField m_constraint;
    private TextField m_preference;
    private Checkbox m_exactType;
    private Checkbox m_useDynamic;
    private Checkbox m_useProxy;
    private Checkbox m_useProps;
    private TextField m_props;
    private Button m_query;
    private TextArea m_results;
    private Label m_status;
    private Lookup m_lookup;
    private ServiceTypeRepository m_repos;
    private static ORB s_orb;

    public Query(Lookup lookup) {
        super("Query");
        this.setFont(new Font("Helvetica", 0, 12));
        this.m_lookup = lookup;
        Object obj = lookup.type_repos();
        this.m_repos = ServiceTypeRepositoryHelper.narrow(obj);
        this.createContents();
    }

    protected void createContents() {
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        Panel typesPanel = new Panel();
        typesPanel.setLayout(new FlowLayout(0, 0, 0));
        typesPanel.add(new Label("Service type", 0));
        this.m_types = new Choice();
        this.loadTypes(this.m_types);
        typesPanel.add(this.m_types);
        Constrain.constrain(panel, typesPanel, 0, 0, 2, 1, 2, 18, 1.0, 0.0, 5, 10, 0, 10);
        Constrain.constrain(panel, new Label("Constraint", 0), 0, 1, 2, 1, 0, 18, 0.0, 0.0, 5, 10, 0, 10);
        this.m_constraint = new TextField(50);
        this.m_constraint.setEditable(true);
        Constrain.constrain(panel, this.m_constraint, 0, 2, 2, 1, 2, 18, 1.0, 0.0, 0, 10, 0, 10);
        Constrain.constrain(panel, new Label("Preference", 0), 0, 3, 2, 1, 0, 18, 0.0, 0.0, 5, 10, 0, 10);
        this.m_preference = new TextField(50);
        this.m_preference.setEditable(true);
        Constrain.constrain(panel, this.m_preference, 0, 4, 2, 1, 2, 18, 1.0, 0.0, 0, 10, 0, 10);
        this.m_useProps = new Checkbox("Desired properties", false);
        this.m_useProps.addItemListener(this);
        Constrain.constrain(panel, this.m_useProps, 0, 5, 2, 1, 0, 18, 0.0, 0.0, 5, 10, 0, 10);
        this.m_props = new TextField(40);
        this.m_props.setEditable(false);
        Constrain.constrain(panel, this.m_props, 0, 6, 2, 1, 2, 18, 1.0, 0.0, 0, 10, 0, 10);
        Panel policiesPanel = new Panel();
        policiesPanel.setLayout(new GridBagLayout());
        this.m_exactType = new Checkbox("Exact type", false);
        Constrain.constrain(policiesPanel, this.m_exactType, 0, 0, 1, 1, 0, 17);
        this.m_useDynamic = new Checkbox("Dynamic properties", false);
        Constrain.constrain(policiesPanel, this.m_useDynamic, 1, 0, 1, 1, 0, 10, 0.0, 0.0, 0, 10, 0, 10);
        this.m_useProxy = new Checkbox("Proxy offers", false);
        Constrain.constrain(policiesPanel, this.m_useProxy, 2, 0, 1, 1, 0, 13);
        Constrain.constrain(panel, policiesPanel, 0, 7, 2, 1, 2, 17, 1.0, 0.0, 5, 10, 0, 10);
        this.m_query = new Button("Query");
        this.m_query.setActionCommand("query");
        this.m_query.addActionListener(this);
        Constrain.constrain(panel, this.m_query, 0, 8, 2, 1, 0, 10, 0.0, 0.0, 5, 10, 0, 10, 30, 3);
        Constrain.constrain(panel, new Label("Results", 0), 0, 9, 2, 1, 0, 18, 0.0, 0.0, 5, 10, 0, 10);
        this.m_results = new TextArea(10, 50);
        this.m_results.setEditable(false);
        Constrain.constrain(panel, this.m_results, 0, 10, 2, 1, 1, 18, 1.0, 1.0, 0, 10, 0, 10);
        this.m_status = new Label("", 0);
        Constrain.constrain(panel, this.m_status, 0, 11, 2, 1, 2, 18, 1.0, 0.0, 0, 10, 3, 10);
        this.add(panel);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("query")) {
            new Thread(this).start();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.m_props.setEditable(e.getStateChange() == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            int count;
            String props;
            this.showStatus("Performing query...");
            this.m_query.setEnabled(false);
            this.m_results.setText("");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            String type = this.m_types.getSelectedItem();
            String constraint = this.m_constraint.getText();
            String preference = this.m_preference.getText();
            Policy[] policies = new Policy[3];
            policies[0] = new Policy();
            policies[0].name = "exact_type_match";
            policies[0].value = s_orb.create_any();
            policies[0].value.insert_boolean(this.m_exactType.getState());
            policies[1] = new Policy();
            policies[1].name = "use_dynamic_properties";
            policies[1].value = s_orb.create_any();
            policies[1].value.insert_boolean(this.m_useDynamic.getState());
            policies[2] = new Policy();
            policies[2].name = "use_proxy_offers";
            policies[2].value = s_orb.create_any();
            policies[2].value.insert_boolean(this.m_useProxy.getState());
            SpecifiedProps desiredProps = new SpecifiedProps();
            if (this.m_useProps.getState() && (props = this.m_props.getText().trim()).length() != 0) {
                StringTokenizer tok = new StringTokenizer(props, ",");
                String[] names = new String[tok.countTokens()];
                count = 0;
                while (tok.hasMoreTokens()) {
                    names[count++] = tok.nextToken().trim();
                }
                desiredProps.prop_names(names);
            }
            OfferSeqHolder offers = new OfferSeqHolder();
            OfferIteratorHolder iter = new OfferIteratorHolder();
            PolicyNameSeqHolder limits = new PolicyNameSeqHolder();
            this.m_lookup.query(type, constraint, preference, policies, desiredProps, 20, offers, iter, limits);
            count = offers.value.length;
            this.showStatus("Received " + count + " offers...");
            this.describeOffers(pw, offers.value);
            if (iter.value != null) {
                boolean more;
                OfferSeqHolder seq = new OfferSeqHolder();
                do {
                    more = iter.value.next_n(20, seq);
                    this.showStatus("Received " + (count += seq.value.length) + " offers...");
                    this.describeOffers(pw, seq.value);
                } while (more);
                iter.value.destroy();
            }
            pw.flush();
            this.m_results.setText(sw.toString());
        }
        catch (IllegalServiceType e) {
            this.showStatus("Illegal service type '" + e.type + "'");
        }
        catch (UnknownServiceType e) {
            this.showStatus("Unknown service type '" + e.type + "'");
        }
        catch (IllegalConstraint e) {
            this.showStatus("Illegal constraint");
        }
        catch (IllegalPreference e) {
            this.showStatus("Illegal preference");
        }
        catch (IllegalPolicyName e) {
            this.showStatus("Illegal policy '" + e.name + "'");
        }
        catch (PolicyTypeMismatch e) {
            this.showStatus("Policy type mismatch for '" + e.the_policy.name + "'");
        }
        catch (InvalidPolicyValue e) {
            this.showStatus("Invalid policy value for '" + e.the_policy.name + "'");
        }
        catch (IllegalPropertyName e) {
            this.showStatus("Illegal property name '" + e.name + "'");
        }
        catch (DuplicatePropertyName e) {
            this.showStatus("Duplicate property name '" + e.name + "'");
        }
        catch (DuplicatePolicyName e) {
            this.showStatus("Duplicate policy name '" + e.name + "'");
        }
        catch (SystemException e) {
            this.showStatus("System error occurred");
        }
        finally {
            this.m_query.setEnabled(true);
        }
    }

    protected void describeOffers(PrintWriter pw, Offer[] offers) {
        for (int i = 0; i < offers.length; ++i) {
            pw.println("Offer:");
            pw.println();
            for (int p = 0; p < offers[i].properties.length; ++p) {
                pw.print("  " + offers[i].properties[p].name + " = ");
                AnyUtil.print(s_orb, pw, offers[i].properties[p].value);
                pw.println();
            }
            pw.println();
            pw.println("  Reference:");
            String ref = s_orb.object_to_string(offers[i].reference);
            pw.println("    " + ref);
            pw.println();
        }
    }

    protected void loadTypes(Choice choice) {
        choice.removeAll();
        SpecifiedServiceTypes whichTypes = new SpecifiedServiceTypes();
        whichTypes.__default();
        String[] types = this.m_repos.list_types(whichTypes);
        QuickSort.sort(types);
        for (int i = 0; i < types.length; ++i) {
            choice.add(types[i]);
        }
    }

    protected void showStatus(String message) {
        this.m_status.setText(message);
    }

    protected void clearStatus() {
        this.m_status.setText("");
    }

    protected static void usage() {
        System.out.println("Usage: Query iorfile");
        System.exit(1);
    }

    public static void main(String[] args) {
        s_orb = ORB.init(args, null);
        Lookup lookup = null;
        try {
            Object obj = s_orb.resolve_initial_references("TradingService");
            if (obj == null) {
                System.out.println("Invalid object");
                System.exit(1);
            }
            lookup = LookupHelper.narrow(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        Query app = new Query(lookup);
        app.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                e.getWindow().dispose();
                System.exit(0);
            }
        });
        app.pack();
        app.setVisible(true);
    }
}

