/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.client.offers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Random;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosTrading.DuplicatePropertyName;
import org.omg.CosTrading.IllegalPropertyName;
import org.omg.CosTrading.IllegalServiceType;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.LookupHelper;
import org.omg.CosTrading.MissingMandatoryProperty;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.PropertyTypeMismatch;
import org.omg.CosTrading.ReadonlyDynamicProperty;
import org.omg.CosTrading.Register;
import org.omg.CosTrading.RegisterPackage.InterfaceTypeMismatch;
import org.omg.CosTrading.RegisterPackage.InvalidObjectRef;
import org.omg.CosTrading.UnknownServiceType;

public class export {
    public static void main(String[] args) {
        if (args.length < 1) {
            export.usage();
            return;
        }
        File f = new File(args[0]);
        if (!f.exists()) {
            System.err.println("File " + args[0] + " does not exist");
            export.usage();
        }
        if (!f.isFile()) {
            System.err.println(args[0] + " is not a file");
            export.usage();
        }
        ORB orb = ORB.init(args, null);
        Register reg = null;
        try {
            FileReader fr = new FileReader(f);
            BufferedReader in = new BufferedReader(fr);
            String ref = in.readLine();
            fr.close();
            Object obj = orb.string_to_object(ref);
            if (obj == null) {
                System.out.println("Invalid object");
                System.exit(1);
            }
            Lookup lookup = LookupHelper.narrow(obj);
            reg = lookup.register_if();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        try {
            Random rand = new Random();
            for (int i = 0; i < 10; ++i) {
                Property[] props = i % 2 == 0 ? new Property[4] : new Property[3];
                int num = 0;
                props[num] = new Property();
                props[num].name = "name";
                props[num].value = orb.create_any();
                props[num].value.insert_string("name #" + i);
                ++num;
                if (i % 2 == 0) {
                    props[num] = new Property();
                    props[num].name = "cost";
                    props[num].value = orb.create_any();
                    props[num].value.insert_double(Math.abs(rand.nextDouble()));
                    ++num;
                }
                props[num] = new Property();
                props[num].name = "version";
                props[num].value = orb.create_any();
                props[num].value.insert_string("1.0" + i);
                props[++num] = new Property();
                props[num].name = "count";
                props[num].value = orb.create_any();
                props[num].value.insert_long(Math.abs(rand.nextInt()) % 100);
                ++num;
                String id = reg.export(reg, "SubSvc", props);
                System.out.println("Offer id = " + id);
            }
        }
        catch (InvalidObjectRef e) {
            System.out.println("Invalid object reference");
        }
        catch (IllegalServiceType e) {
            System.out.println("Illegal service type: " + e.type);
        }
        catch (UnknownServiceType e) {
            System.out.println("Unknown service type: " + e.type);
        }
        catch (InterfaceTypeMismatch e) {
            System.out.println("Interface type mismatch: " + e.type);
        }
        catch (IllegalPropertyName e) {
            System.out.println("Illegal property name: " + e.name);
        }
        catch (PropertyTypeMismatch e) {
            System.out.println("Property type mismatch: " + e.prop.name);
        }
        catch (ReadonlyDynamicProperty e) {
            System.out.println("Readonly dynamic property: " + e.name);
        }
        catch (MissingMandatoryProperty e) {
            System.out.println("Missing mandatory property: " + e.name);
        }
        catch (DuplicatePropertyName e) {
            System.out.println("Duplicate property: " + e.name);
        }
        System.exit(0);
    }

    protected static void usage() {
        System.out.println("Usage: jtclient.offers.export iorfile");
        System.exit(1);
    }
}

