/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.client.offers;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.trading.client.util.Constrain;
import org.jacorb.trading.client.util.QuickSort;
import org.omg.CORBA.Object;
import org.omg.CosTrading.IllegalConstraint;
import org.omg.CosTrading.IllegalServiceType;
import org.omg.CosTrading.Register;
import org.omg.CosTrading.RegisterPackage.NoMatchingOffers;
import org.omg.CosTrading.UnknownServiceType;
import org.omg.CosTradingRepos.ServiceTypeRepository;
import org.omg.CosTradingRepos.ServiceTypeRepositoryHelper;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.SpecifiedServiceTypes;

public class ConstraintDialog
extends Dialog
implements ActionListener,
Runnable {
    private Choice m_types;
    private TextField m_constraint;
    private Button m_ok;
    private Button m_cancel;
    private Label m_status;
    private Register m_register;
    private ServiceTypeRepository m_repos;
    private Vector m_listeners = new Vector();
    private String m_actionCommand;

    public ConstraintDialog(Frame f, Register reg) {
        super(f, "Withdraw", false);
        this.m_register = reg;
        Object obj = reg.type_repos();
        this.m_repos = ServiceTypeRepositoryHelper.narrow(obj);
        this.createContents();
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ConstraintDialog.this.cancel();
            }
        });
        Point parentLoc = this.getParent().getLocation();
        this.setLocation(parentLoc.x + 30, parentLoc.y + 30);
    }

    protected void createContents() {
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        Panel typesPanel = new Panel();
        typesPanel.setLayout(new FlowLayout(0, 0, 0));
        typesPanel.add(new Label("Service type", 0));
        this.m_types = new Choice();
        this.loadTypes(this.m_types);
        typesPanel.add(this.m_types);
        Constrain.constrain(panel, typesPanel, 0, 0, 2, 1, 2, 18, 1.0, 0.0, 5, 10, 0, 10);
        Constrain.constrain(panel, new Label("Constraint", 0), 0, 1, 2, 1, 0, 18, 0.0, 0.0, 5, 10, 0, 10);
        this.m_constraint = new TextField(50);
        this.m_constraint.setEditable(true);
        Constrain.constrain(panel, this.m_constraint, 0, 2, 2, 1, 2, 18, 1.0, 0.0, 0, 10, 0, 10);
        this.m_ok = new Button("OK");
        this.m_ok.setActionCommand("ok");
        this.m_ok.addActionListener(this);
        Constrain.constrain(panel, this.m_ok, 0, 3, 1, 1, 0, 18, 0.0, 0.0, 10, 10, 0, 0, 30, 3);
        this.m_cancel = new Button("Cancel");
        this.m_cancel.setActionCommand("cancel");
        this.m_cancel.addActionListener(this);
        Constrain.constrain(panel, this.m_cancel, 1, 3, 1, 1, 0, 12, 0.0, 0.0, 10, 0, 0, 10, 10, 3);
        this.m_status = new Label("", 0);
        Constrain.constrain(panel, this.m_status, 0, 4, 2, 1, 2, 18, 1.0, 0.0, 5, 10, 5, 10);
        this.add(panel);
    }

    public void addActionListener(ActionListener l) {
        this.m_listeners.addElement(l);
    }

    public void removeActionListener(ActionListener l) {
        this.m_listeners.removeElement(l);
    }

    public void setActionCommand(String command) {
        this.m_actionCommand = command;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ok")) {
            this.ok();
        } else if (e.getActionCommand().equals("cancel")) {
            this.cancel();
        }
    }

    protected void ok() {
        new Thread(this).start();
    }

    protected void cancel() {
        this.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.showStatus("Withdrawing offers...");
            this.m_ok.setEnabled(false);
            this.m_cancel.setEnabled(false);
            String type = this.m_types.getSelectedItem();
            String constraint = this.m_constraint.getText();
            this.m_register.withdraw_using_constraint(type, constraint);
            this.setVisible(false);
            this.notifyListeners();
            this.clearStatus();
        }
        catch (IllegalServiceType e) {
            this.showStatus("Illegal service type '" + e.type + "'");
        }
        catch (UnknownServiceType e) {
            this.showStatus("Unknown service type '" + e.type + "'");
        }
        catch (IllegalConstraint e) {
            this.showStatus("Illegal constraint");
        }
        catch (NoMatchingOffers e) {
            this.showStatus("No matching offers found");
        }
        finally {
            this.m_ok.setEnabled(true);
            this.m_cancel.setEnabled(true);
        }
    }

    protected void notifyListeners() {
        ActionEvent evt = new ActionEvent(this, 1001, this.m_actionCommand);
        Enumeration e = this.m_listeners.elements();
        while (e.hasMoreElements()) {
            ActionListener l = (ActionListener)e.nextElement();
            l.actionPerformed(evt);
        }
    }

    protected void showStatus(String message) {
        this.m_status.setText(message);
    }

    protected void clearStatus() {
        this.m_status.setText("");
    }

    protected void loadTypes(Choice choice) {
        choice.removeAll();
        SpecifiedServiceTypes whichTypes = new SpecifiedServiceTypes();
        whichTypes.__default();
        String[] types = this.m_repos.list_types(whichTypes);
        QuickSort.sort(types);
        for (int i = 0; i < types.length; ++i) {
            choice.add(types[i]);
        }
    }
}

