/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;

public class KeyStoreUtil {
    public static KeyStore getKeyStore(String file_name, char[] storepass) throws IOException, GeneralSecurityException {
        InputStream in = null;
        URL url = Thread.currentThread().getContextClassLoader().getResource(file_name);
        if (url != null) {
            in = url.openStream();
        } else {
            File f = new File(file_name);
            if (!f.exists()) {
                String name = System.getProperty("user.home") + System.getProperty("file.separator") + file_name;
                f = new File(name);
                if (f.exists()) {
                    in = new FileInputStream(f);
                }
            } else {
                in = new FileInputStream(f);
            }
        }
        if (in == null) {
            throw new IOException("Unable to find keystore file " + file_name);
        }
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(in, storepass);
        in.close();
        return ks;
    }
}

