/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.level2;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.util.Vector;
import org.jacorb.security.level2.SecAttributeManager;
import org.omg.CORBA.LocalObject;
import org.omg.Security.AttributeListHolder;
import org.omg.Security.AttributeType;
import org.omg.Security.AuthenticationStatus;
import org.omg.Security.CommunicationDirection;
import org.omg.Security.InvocationCredentialsType;
import org.omg.Security.SecAttribute;
import org.omg.Security.SecurityFeature;
import org.omg.SecurityLevel2.Credentials;
import org.omg.TimeBase.UtcTHolder;

public class CredentialsImpl
extends LocalObject
implements Credentials,
Serializable {
    private SecAttribute[] my_attributes;
    private short accepting_options_supported;
    private short accepting_options_required;
    private short invocation_options_supported;
    private short invocation_options_required;
    private AuthenticationStatus authStatus = null;
    private InvocationCredentialsType type = null;
    private boolean[] securityFeaturesForRequests;
    private boolean[] securityFeaturesForReplies;
    private SecAttributeManager attrib_mgr = null;
    private boolean dirty = true;

    public CredentialsImpl(SecAttribute[] attributes, AuthenticationStatus status, InvocationCredentialsType type) {
        this.authStatus = status;
        this.my_attributes = attributes;
        this.type = type;
        this.attrib_mgr = SecAttributeManager.getInstance();
    }

    public Credentials copy() {
        try {
            PipedOutputStream pipe_out = new PipedOutputStream();
            PipedInputStream pipe_in = new PipedInputStream(pipe_out);
            ObjectOutputStream out = new ObjectOutputStream(pipe_out);
            out.writeObject(this);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(pipe_in);
            CredentialsImpl creds = (CredentialsImpl)in.readObject();
            in.close();
            pipe_in.close();
            pipe_out.close();
            return creds;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public InvocationCredentialsType credentials_type() {
        return this.type;
    }

    public AuthenticationStatus authentication_state() {
        return this.authStatus;
    }

    public String mechanism() {
        return null;
    }

    public short accepting_options_supported() {
        return this.accepting_options_supported;
    }

    public void accepting_options_supported(short arg) {
        this.accepting_options_supported = arg;
    }

    public short accepting_options_required() {
        return this.accepting_options_required;
    }

    public void accepting_options_required(short arg) {
        this.accepting_options_required = arg;
    }

    public short invocation_options_supported() {
        return this.invocation_options_supported;
    }

    public void invocation_options_supported(short arg) {
        this.invocation_options_supported = arg;
    }

    public short invocation_options_required() {
        return this.invocation_options_required;
    }

    public void invocation_options_required(short arg) {
        this.invocation_options_required = arg;
    }

    public SecAttribute[] get_attributes(AttributeType[] types) {
        if (types == null || types.length == 0) {
            return this.my_attributes;
        }
        Vector<SecAttribute> v = new Vector<SecAttribute>();
        for (int i = 0; i < types.length; ++i) {
            for (int j = 0; j < this.my_attributes.length; ++j) {
                if (this.my_attributes[j].attribute_type.attribute_family.family != types[i].attribute_family.family || this.my_attributes[j].attribute_type.attribute_type != types[i].attribute_type) continue;
                v.addElement(this.my_attributes[j]);
            }
        }
        Object[] result = new SecAttribute[v.size()];
        v.copyInto(result);
        return result;
    }

    public void destroy() {
    }

    public void set_security_feature(CommunicationDirection direction, SecurityFeature[] security_features) {
        switch (direction.value()) {
            case 1: {
                this.setFeatures(this.securityFeaturesForRequests, security_features);
            }
            case 2: {
                this.setFeatures(this.securityFeaturesForReplies, security_features);
            }
            case 0: {
                this.setFeatures(this.securityFeaturesForRequests, security_features);
                this.setFeatures(this.securityFeaturesForReplies, security_features);
            }
        }
    }

    private void setFeatures(boolean[] target, SecurityFeature[] features) {
        if (features.length > target.length) {
            throw new IllegalArgumentException("Too many features");
        }
        for (int i = 0; i < features.length; ++i) {
            int value = features[i].value();
            if (value > target.length || value < 0) {
                throw new IllegalArgumentException("SecurityFeatureValue out of range");
            }
            target[value] = true;
        }
    }

    public boolean get_security_feature(CommunicationDirection direction, SecurityFeature feature) {
        switch (direction.value()) {
            case 1: {
                return this.securityFeaturesForRequests[feature.value()];
            }
            case 2: {
                return this.securityFeaturesForReplies[feature.value()];
            }
        }
        return this.securityFeaturesForRequests[feature.value()] && this.securityFeaturesForReplies[feature.value()];
    }

    public boolean set_privileges(boolean force_commit, SecAttribute[] requested_privileges, AttributeListHolder actual_privileges) {
        for (int i = 0; i < requested_privileges.length; ++i) {
            if (this.attrib_mgr.getAttributeValue(requested_privileges[i]) != null) continue;
            throw new RuntimeException("SecAttribute not created by Manager");
        }
        Vector<SecAttribute> additional_privileges = new Vector<SecAttribute>();
        for (int i = 0; i < requested_privileges.length; ++i) {
            if (requested_privileges[i].attribute_type.attribute_family.family != 1) continue;
            additional_privileges.addElement(requested_privileges[i]);
        }
        if (additional_privileges.size() > 0) {
            SecAttribute[] tmp = new SecAttribute[this.my_attributes.length + additional_privileges.size()];
            System.arraycopy(this.my_attributes, 0, tmp, 0, this.my_attributes.length);
            for (int i = 0; i < additional_privileges.size(); ++i) {
                SecAttribute attrib;
                tmp[this.my_attributes.length + i] = attrib = (SecAttribute)additional_privileges.elementAt(i);
            }
            this.my_attributes = tmp;
            actual_privileges.value = tmp;
            this.dirty = true;
            return true;
        }
        return false;
    }

    public boolean is_valid(UtcTHolder expiry_time) {
        return false;
    }

    public boolean refresh(byte[] refresh_data) {
        return false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clearDirtyFlag() {
        this.dirty = false;
    }
}

