/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.Vector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.poa.Current;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.RPPoolManagerListener;
import org.jacorb.poa.RequestProcessor;
import org.jacorb.poa.except.POAInternalError;

public class RPPoolManager {
    private RPPoolManagerListener pmListener;
    private Current current;
    private Vector pool;
    private Vector activeProcessors;
    private int unused_size;
    private int max_pool_size;
    private int min_pool_size;
    private boolean inUse = false;
    private Configuration configuration;
    private Logger logger;

    private RPPoolManager() {
    }

    protected RPPoolManager(Current _current, int min, int max, Logger _logger, Configuration _configuration) {
        this.current = _current;
        this.max_pool_size = max;
        this.min_pool_size = min;
        this.logger = _logger;
        this.configuration = _configuration;
    }

    private void addProcessor() {
        RequestProcessor rp = new RequestProcessor(this);
        try {
            rp.configure(this.configuration);
        }
        catch (ConfigurationException ex) {
            throw new RuntimeException(ex.toString());
        }
        this.current._addContext(rp, rp);
        rp.setDaemon(true);
        this.pool.addElement(rp);
        ++this.unused_size;
        rp.start();
    }

    protected synchronized void addRPPoolManagerListener(RPPoolManagerListener listener) {
        this.pmListener = EventMulticaster.add(this.pmListener, listener);
    }

    protected synchronized void destroy() {
        if (this.pool == null || !this.inUse) {
            return;
        }
        while (!this.activeProcessors.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {}
        }
        Object[] rps = new RequestProcessor[this.pool.size()];
        this.pool.copyInto(rps);
        for (int i = 0; i < rps.length; ++i) {
            if (((RequestProcessor)rps[i]).isActive()) {
                throw new POAInternalError("error: request processor is active (RequestProcessorPM.destroy)");
            }
            this.pool.removeElement(rps[i]);
            --this.unused_size;
            this.current._removeContext((Thread)rps[i]);
            ((RequestProcessor)rps[i]).end();
        }
        this.inUse = false;
    }

    protected int getPoolCount() {
        return this.pool == null ? 0 : this.pool.size();
    }

    protected synchronized int getPoolSize() {
        return this.unused_size;
    }

    protected synchronized RequestProcessor getProcessor() {
        if (!this.inUse) {
            this.init();
            this.inUse = true;
        }
        if (this.pool.size() == 0 && this.unused_size < this.max_pool_size) {
            this.addProcessor();
        }
        while (this.pool.size() == 0) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Thread pool exhausted, consider increasing jacorb.poa.thread_pool_max (currently: " + this.max_pool_size + ")");
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        RequestProcessor rp = (RequestProcessor)this.pool.remove(this.pool.size() - 1);
        this.activeProcessors.add(rp);
        if (this.pmListener != null) {
            this.pmListener.processorRemovedFromPool(rp, this.pool.size(), this.unused_size);
        }
        return rp;
    }

    private void init() {
        this.pool = new Vector(this.max_pool_size);
        this.activeProcessors = new Vector(this.max_pool_size);
        for (int i = 0; i < this.min_pool_size; ++i) {
            this.addProcessor();
        }
    }

    protected synchronized void releaseProcessor(RequestProcessor rp) {
        this.activeProcessors.remove(rp);
        if (this.pool.size() < this.min_pool_size) {
            this.pool.addElement(rp);
        } else {
            --this.unused_size;
            this.current._removeContext(rp);
            rp.end();
        }
        if (this.pmListener != null) {
            this.pmListener.processorAddedToPool(rp, this.pool.size(), this.unused_size);
        }
        this.notifyAll();
    }

    protected synchronized void removeRPPoolManagerListener(RPPoolManagerListener listener) {
        this.pmListener = EventMulticaster.remove(this.pmListener, listener);
    }
}

