/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.poa.AOMListener;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.POA;
import org.jacorb.poa.RequestController;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.util.ByteArrayKey;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.poa.util.StringPair;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;

public class AOM {
    private AOMListener aomListener;
    private boolean unique;
    private boolean singleThreaded;
    private Logger logger;
    private Hashtable objectMap = new Hashtable();
    private Hashtable servantMap;
    private Vector etherealisationList = new Vector();
    private Vector incarnationList = new Vector();
    private Vector deactivationList = new Vector();
    private Object deactivationListLock = new Object();

    private AOM() {
    }

    protected AOM(boolean _unique, boolean single_threaded, Logger _logger) {
        this.unique = _unique;
        this.singleThreaded = single_threaded;
        this.logger = _logger;
        if (this.unique) {
            this.servantMap = new Hashtable();
        }
    }

    protected synchronized void add(byte[] oid, Servant servant) throws ObjectAlreadyActive, ServantAlreadyActive {
        ByteArrayKey oidbak = new ByteArrayKey(oid);
        while (this.incarnationList.contains(oidbak) || this.etherealisationList.contains(oidbak) || this.deactivationList.contains(oidbak) || this.servantMap != null && this.servantMap.get(servant) != null && this.deactivationList.contains((ByteArrayKey)this.servantMap.get(servant))) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        if (this.objectMap.containsKey(oidbak)) {
            throw new ObjectAlreadyActive();
        }
        if (this.unique && this.servantMap.containsKey(servant)) {
            throw new ServantAlreadyActive();
        }
        this.objectMap.put(oidbak, servant);
        if (this.unique) {
            this.servantMap.put(servant, oidbak);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("oid: " + POAUtil.convert(oid) + "object is activated");
        }
        if (this.aomListener != null) {
            this.aomListener.objectActivated(oid, servant, this.objectMap.size());
        }
    }

    protected synchronized void addAOMListener(AOMListener listener) {
        this.aomListener = EventMulticaster.add(this.aomListener, listener);
    }

    boolean isDeactivating(ByteArrayKey oid) {
        return this.deactivationList.contains(oid);
    }

    protected boolean contains(Servant servant) {
        if (this.unique) {
            return this.servantMap.containsKey(servant);
        }
        return this.objectMap.contains(servant);
    }

    protected synchronized StringPair[] deliverContent() {
        StringPair[] result = new StringPair[this.objectMap.size()];
        Enumeration en = this.objectMap.keys();
        for (int i = 0; i < result.length; ++i) {
            ByteArrayKey oidbak = (ByteArrayKey)en.nextElement();
            result[i] = new StringPair(oidbak.toString(), this.objectMap.get(oidbak).getClass().getName());
        }
        return result;
    }

    protected byte[] getObjectId(Servant servant) {
        if (!this.unique) {
            throw new POAInternalError("error: not UNIQUE_ID policy (getObjectId)");
        }
        ByteArrayKey oidbak = (ByteArrayKey)this.servantMap.get(servant);
        if (oidbak != null) {
            return oidbak.getBytes();
        }
        return null;
    }

    protected Servant getServant(byte[] oid) {
        return (Servant)this.objectMap.get(new ByteArrayKey(oid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Servant incarnate(byte[] oid, ServantActivator servant_activator, org.omg.PortableServer.POA poa) throws ForwardRequest {
        ByteArrayKey oidbak = new ByteArrayKey(oid);
        Servant servant = null;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("oid: " + POAUtil.convert(oid) + "incarnate");
        }
        while (!this.incarnationList.isEmpty() || !this.etherealisationList.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        if (this.objectMap.containsKey(oidbak)) {
            return (Servant)this.objectMap.get(oidbak);
        }
        this.incarnationList.addElement(oidbak);
        try {
            servant = servant_activator.incarnate(oid, poa);
        }
        finally {
            this.incarnationList.removeElement(oidbak);
            this.notifyAll();
        }
        if (servant == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("oid: " + POAUtil.convert(oid) + "servant is not incarnated (incarnate returns null)");
            }
            return null;
        }
        if (this.unique && this.servantMap.containsKey(servant)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("oid: " + POAUtil.convert(oid) + "servant is not incarnated (unique_id policy is violated)");
            }
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("oid: " + POAUtil.convert(oid) + "servant is incarnated");
        }
        if (this.aomListener != null) {
            this.aomListener.servantIncarnated(oid, servant);
        }
        try {
            this.add(oid, servant);
        }
        catch (ObjectAlreadyActive e) {
            throw new POAInternalError("error: object already active (AOM.incarnate)");
        }
        catch (ServantAlreadyActive e) {
            throw new POAInternalError("error: servant already active (AOM.incarnate)");
        }
        return servant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(byte[] oid, RequestController requestController, ServantActivator servantActivator, POA poa, boolean cleanupInProgress) throws ObjectNotActive {
        ByteArrayKey oidbak = new ByteArrayKey(oid);
        Object object = this.deactivationListLock;
        synchronized (object) {
            if (!this.objectMap.containsKey(oidbak) || this.deactivationList.contains(oidbak)) {
                throw new ObjectNotActive();
            }
            this.deactivationList.addElement(oidbak);
        }
        final byte[] oid_ = oid;
        final RequestController requestController_ = requestController;
        final ServantActivator servantActivator_ = servantActivator;
        final POA poa_ = poa;
        final boolean cleanupInProgress_ = cleanupInProgress;
        Thread thread = new Thread("AOM_RemovalThread"){

            public void run() {
                AOM.this._remove(oid_, requestController_, servantActivator_, poa_, cleanupInProgress_);
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _remove(byte[] oid, RequestController requestController, ServantActivator servantActivator, POA poa, boolean cleanupInProgress) {
        ByteArrayKey oidbak = new ByteArrayKey(oid);
        Servant servant = null;
        if (!this.objectMap.containsKey(oidbak)) {
            this.deactivationList.removeElement(oidbak);
            return;
        }
        if (requestController != null) {
            requestController.waitForObjectCompletion(oid);
        }
        AOM aOM = this;
        synchronized (aOM) {
            servant = (Servant)this.objectMap.get(oidbak);
            if (servant == null) {
                return;
            }
            this.objectMap.remove(oidbak);
            if (this.unique) {
                this.servantMap.remove(servant);
            }
            this.deactivationList.removeElement(oidbak);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("oid: " + POAUtil.convert(oid) + "object is deactivated");
            }
            if (this.aomListener != null) {
                this.aomListener.objectDeactivated(oid, servant, this.objectMap.size());
            }
            if (servantActivator == null) {
                requestController.freeObject(oid);
                this.notifyAll();
                return;
            }
            while (!this.incarnationList.isEmpty() || !this.etherealisationList.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            this.etherealisationList.addElement(oidbak);
            try {
                servantActivator.etherealize(oid, poa, servant, cleanupInProgress, this.contains(servant));
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("oid: " + POAUtil.convert(oid) + "servant is etherealized");
                }
                if (this.aomListener != null) {
                    this.aomListener.servantEtherialized(oid, servant);
                }
            }
            catch (SystemException e) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.info("oid: " + POAUtil.convert(oid) + "exception occurred during servant etherialisation: " + e.getMessage());
                }
            }
            finally {
                this.etherealisationList.removeElement(oidbak);
                this.notifyAll();
            }
            if (requestController != null) {
                requestController.freeObject(oid);
            }
        }
    }

    protected void removeAll(ServantActivator servant_activator, POA poa, boolean cleanup_in_progress) {
        Enumeration en = this.objectMap.keys();
        while (en.hasMoreElements()) {
            byte[] oid = ((ByteArrayKey)en.nextElement()).getBytes();
            this._remove(oid, null, servant_activator, poa, cleanup_in_progress);
        }
    }

    protected synchronized void removeAOMListener(AOMListener listener) {
        this.aomListener = EventMulticaster.remove(this.aomListener, listener);
    }

    protected int size() {
        return this.objectMap.size();
    }
}

