/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.standardInterceptors;

import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.ietf.jgss.Oid;
import org.jacorb.config.Configuration;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.portableInterceptor.IORInfoImpl;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.sasPolicy.ATLASPolicy;
import org.jacorb.sasPolicy.ATLASPolicyValues;
import org.jacorb.sasPolicy.SASPolicy;
import org.jacorb.sasPolicy.SASPolicyValues;
import org.jacorb.security.sas.ISASContext;
import org.jacorb.util.ObjectUtil;
import org.omg.ATLAS.ATLASLocator;
import org.omg.ATLAS.ATLASProfile;
import org.omg.ATLAS.ATLASProfileHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CSIIOP.AS_ContextSec;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.SAS_ContextSec;
import org.omg.CSIIOP.ServiceConfiguration;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.Encoding;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;

public class SASComponentInterceptor
extends LocalObject
implements IORInterceptor {
    private Configuration config;
    private Logger logger;
    private ORB orb;
    private Codec codec;
    private TaggedComponent tc;
    private ISASContext sasContext;

    public SASComponentInterceptor(ORBInitInfo info) {
        block8: {
            this.config = null;
            this.logger = null;
            this.orb = null;
            this.codec = null;
            this.tc = null;
            this.sasContext = null;
            this.orb = ((ORBInitInfoImpl)info).getORB();
            this.config = this.orb.getConfiguration();
            this.logger = this.config.getNamedLogger("jacorb.SAS.IOR");
            try {
                Encoding encoding = new Encoding(0, 1, 0);
                CodecFactory codec_factory = (CodecFactory)this.orb.resolve_initial_references("CodecFactory");
                this.codec = codec_factory.create_codec(encoding);
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block8;
                this.logger.error("Error initing SASComponentInterceptor: ", (Throwable)e);
            }
        }
        String contextClass = null;
        try {
            contextClass = this.config.getAttribute("jacorb.security.sas.contextClass");
            try {
                Class c = ObjectUtil.classForName(contextClass);
                this.sasContext = (ISASContext)c.newInstance();
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Could not instantiate SAS Context class " + contextClass + ": " + e);
                }
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (this.sasContext == null && this.logger.isErrorEnabled()) {
            this.logger.error("Could not load SAS context class: " + contextClass);
        }
    }

    public String name() {
        return "SASComponentCreator";
    }

    public void destroy() {
    }

    public void establish_components(IORInfo info) {
        block21: {
            ATLASPolicyValues atlasValues;
            SASPolicyValues sasValues;
            block20: {
                block19: {
                    if (this.sasContext == null) {
                        return;
                    }
                    sasValues = null;
                    try {
                        SASPolicy policy = (SASPolicy)((IORInfoImpl)info).get_effective_policy(102);
                        if (policy != null) {
                            sasValues = policy.value();
                        }
                    }
                    catch (BAD_PARAM e) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("No SAS Policy");
                        }
                    }
                    catch (Exception e) {
                        if (!this.logger.isWarnEnabled()) break block19;
                        this.logger.warn("Error fetching SAS policy: " + e);
                    }
                }
                if (sasValues == null) {
                    return;
                }
                if (sasValues.targetRequires == 0 && sasValues.targetSupports == 0) {
                    return;
                }
                atlasValues = null;
                try {
                    ATLASPolicy policy = (ATLASPolicy)info.get_effective_policy(103);
                    if (policy != null) {
                        atlasValues = policy.value();
                    }
                }
                catch (BAD_PARAM e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("No ATLAS Policy");
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isWarnEnabled()) break block20;
                    this.logger.warn("Error fetching ATLAS policy: " + e);
                }
            }
            try {
                if (this.tc == null) {
                    TaggedComponent transportMech = new TaggedComponent(34, new byte[0]);
                    byte[] targetName = this.sasContext.getClientPrincipal().getBytes();
                    ServiceConfiguration[] serviceConfiguration = null;
                    if (atlasValues == null) {
                        serviceConfiguration = new ServiceConfiguration[]{};
                    } else {
                        if (atlasValues.atlasCache == null) {
                            atlasValues.atlasCache = "";
                        }
                        ATLASLocator atlasLoc = new ATLASLocator();
                        atlasLoc.the_url(atlasValues.atlasURL);
                        ATLASProfile profile = new ATLASProfile();
                        profile.the_cache_id = atlasValues.atlasCache.getBytes();
                        profile.the_locator = atlasLoc;
                        byte[] cdrProfile = new byte[]{};
                        Any any = this.orb.create_any();
                        ATLASProfileHelper.insert(any, profile);
                        cdrProfile = this.codec.encode(any);
                        serviceConfiguration = new ServiceConfiguration[]{new ServiceConfiguration(3, cdrProfile)};
                    }
                    SAS_ContextSec sasContextSec = new SAS_ContextSec(0, 0, serviceConfiguration, new byte[0][0], 0);
                    boolean useStateful = this.config.getAttributeAsBoolean("jacorb.security.sas.stateful", true);
                    CompoundSecMech[] compoundSecMech = new CompoundSecMech[1];
                    Oid oid = new Oid(this.sasContext.getMechOID());
                    byte[] clientAuthenticationMech = oid.getDER();
                    AS_ContextSec asContextSec = new AS_ContextSec(sasValues.targetSupports, sasValues.targetRequires, clientAuthenticationMech, targetName);
                    compoundSecMech[0] = new CompoundSecMech(sasValues.targetRequires, transportMech, asContextSec, sasContextSec);
                    CompoundSecMechList compoundSecMechList = new CompoundSecMechList(useStateful, compoundSecMech);
                    CDROutputStream sasDataStream = new CDROutputStream(this.orb);
                    sasDataStream.beginEncapsulatedArray();
                    CompoundSecMechListHelper.write(sasDataStream, compoundSecMechList);
                    this.tc = new TaggedComponent(33, sasDataStream.getBufferCopy());
                    sasDataStream.close();
                    sasDataStream = null;
                }
                info.add_ior_component_to_profile(this.tc, 0);
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block21;
                this.logger.error("establish_components error: ", (Throwable)e);
            }
        }
    }
}

