/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.standardInterceptors;

import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.orb.ORB;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.orb.standardInterceptors.CodeSetInfoInterceptor;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;

public class IORInterceptorInitializer
extends LocalObject
implements ORBInitializer {
    public void post_init(ORBInitInfo info) {
        Configuration config = null;
        try {
            ORB orb = ((ORBInitInfoImpl)info).getORB();
            config = orb.getConfiguration();
            int giop_minor = config.getAttributeAsInteger("jacorb.giop_minor_version", 2);
            if (giop_minor > 0) {
                info.add_ior_interceptor(new CodeSetInfoInterceptor(orb));
            }
        }
        catch (Exception e) {
            if (config != null) {
                Logger logger = config.getNamedLogger("org.jacorb.interceptors.ior_init");
                if (logger.isErrorEnabled()) {
                    logger.error("During IORInterceptor.post_init(): " + e.getMessage());
                }
            }
            e.printStackTrace();
        }
    }

    public void pre_init(ORBInitInfo info) {
    }
}

