/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.rmi;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class PortableRemoteObjectDelegateImpl
implements PortableRemoteObjectDelegate {
    private static ORB _orb = null;

    public static synchronized ORB getORB() {
        if (_orb == null) {
            System.out.println("Unknwon ORB");
            _orb = ORB.init(new String[0], null);
        }
        return _orb;
    }

    public static synchronized void setORB(ORB orb) {
        if (_orb != null) {
            throw new IllegalStateException("RMI orb has already been initialized");
        }
        _orb = orb;
    }

    public void exportObject(Remote obj) throws RemoteException {
        if (obj == null) {
            throw new NullPointerException();
        }
        if (obj instanceof Stub) {
            throw new ExportException("Attempted to export a stub class");
        }
        Tie tie = Util.getTie((Remote)obj);
        if (tie != null) {
            throw new ExportException("Object already exported");
        }
        tie = PortableRemoteObjectDelegateImpl.toTie(obj);
        tie.orb(PortableRemoteObjectDelegateImpl.getORB());
        Util.registerTarget((Tie)tie, (Remote)obj);
    }

    public Remote toStub(Remote obj) throws NoSuchObjectException {
        if (obj instanceof Stub) {
            return obj;
        }
        Tie tie = null;
        if (obj instanceof Tie) {
            tie = (Tie)obj;
            obj = tie.getTarget();
        } else {
            tie = Util.getTie((Remote)obj);
        }
        if (tie == null) {
            throw new NoSuchObjectException("Object not exported");
        }
        Object thisObject = tie.thisObject();
        if (thisObject instanceof Remote) {
            return (Remote)((java.lang.Object)thisObject);
        }
        throw new NoSuchObjectException("Object not exported");
    }

    public void unexportObject(Remote obj) throws NoSuchObjectException {
        Tie tie = Util.getTie((Remote)obj);
        if (tie == null) {
            throw new NoSuchObjectException("Object not exported");
        }
        Util.unexportObject((Remote)obj);
    }

    public java.lang.Object narrow(java.lang.Object obj, Class newClass) throws ClassCastException {
        java.lang.Object result;
        Class<?> fromClass;
        block8: {
            if (newClass == null) {
                throw new ClassCastException("Can't narrow to null class");
            }
            if (obj == null) {
                return null;
            }
            fromClass = obj.getClass();
            result = null;
            try {
                if (newClass.isAssignableFrom(fromClass)) {
                    result = obj;
                    break block8;
                }
                Class<?>[] cs = fromClass.getInterfaces();
                Exception e1 = new Exception();
                try {
                    throw e1;
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    System.exit(2);
                }
            }
            catch (Exception e) {
                result = null;
            }
        }
        if (result == null) {
            throw new ClassCastException("Can't narrow from " + fromClass + " to " + newClass);
        }
        return result;
    }

    public void connect(Remote target, Remote source) throws RemoteException {
        throw new Error("Not implemented for PortableRemoteObjectDelegateImpl");
    }

    static Tie toTie(Remote obj) throws ExportException {
        for (Class<?> clz = obj.getClass(); clz != null; clz = clz.getSuperclass()) {
            try {
                String clzName = clz.getName();
                String[] clzParts = clzName.split("\\.");
                clzParts[clzParts.length - 1] = "_" + clzParts[clzParts.length - 1] + "_Tie";
                StringBuffer tieClzName = new StringBuffer("org.omg.stub");
                for (int i = 0; i < clzParts.length; ++i) {
                    tieClzName.append("." + clzParts[i]);
                }
                Class tieClass = Util.loadClass((String)tieClzName.toString(), (String)Util.getCodebase(clz), (ClassLoader)clz.getClassLoader());
                return (Tie)tieClass.newInstance();
            }
            catch (ClassNotFoundException ex) {
                continue;
            }
            catch (InstantiationException e) {
                throw new ExportException("InstantiationException: " + e, e);
            }
            catch (IllegalAccessException e) {
                throw new ExportException("IllegalAccessException: " + e, e);
            }
        }
        throw new ExportException("Tie class not found ");
    }
}

