/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jacorb.orb.ORB;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.IOP.CodecFactory;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class ORBInitInfoImpl
extends LocalObject
implements ORBInitInfo {
    private int slot_count = 0;
    private ORB orb = null;
    private Hashtable named_server_interceptors = null;
    private Vector anonymous_server_interceptors = null;
    private Hashtable named_client_interceptors = null;
    private Vector anonymous_client_interceptors = null;
    private Hashtable named_ior_interceptors = null;
    private Vector anonymous_ior_interceptors = null;
    private Hashtable policy_factories = null;
    private boolean valid = true;

    public ORBInitInfoImpl(ORB orb) {
        this.orb = orb;
        this.named_server_interceptors = new Hashtable();
        this.named_client_interceptors = new Hashtable();
        this.anonymous_server_interceptors = new Vector();
        this.anonymous_client_interceptors = new Vector();
        this.named_ior_interceptors = new Hashtable();
        this.anonymous_ior_interceptors = new Vector();
        this.policy_factories = new Hashtable();
    }

    public ORB getORB() {
        return this.orb;
    }

    public void setInvalid() {
        this.valid = false;
    }

    private void merge(Vector target, Hashtable source) {
        Enumeration enumeration = source.elements();
        while (enumeration.hasMoreElements()) {
            target.addElement(enumeration.nextElement());
        }
    }

    public Vector getClientInterceptors() {
        this.merge(this.anonymous_client_interceptors, this.named_client_interceptors);
        return this.anonymous_client_interceptors;
    }

    public Vector getServerInterceptors() {
        this.merge(this.anonymous_server_interceptors, this.named_server_interceptors);
        return this.anonymous_server_interceptors;
    }

    public Vector getIORInterceptors() {
        this.merge(this.anonymous_ior_interceptors, this.named_ior_interceptors);
        return this.anonymous_ior_interceptors;
    }

    public Hashtable getPolicyFactories() {
        return this.policy_factories;
    }

    public int getSlotCount() {
        return this.slot_count;
    }

    public void add_client_request_interceptor(ClientRequestInterceptor interceptor) throws DuplicateName {
        if (!this.valid) {
            throw new OBJECT_NOT_EXIST("This ORBInitIfo is not valid anymore!");
        }
        if (interceptor.name() == null) {
            throw new DuplicateName("The name is null!");
        }
        if (interceptor.name().length() == 0) {
            this.anonymous_client_interceptors.addElement(interceptor);
        } else {
            if (this.named_client_interceptors.containsKey(interceptor.name())) {
                throw new DuplicateName(interceptor.name());
            }
            this.named_client_interceptors.put(interceptor.name(), interceptor);
        }
    }

    public void add_ior_interceptor(IORInterceptor interceptor) throws DuplicateName {
        if (interceptor.name() == null) {
            throw new DuplicateName("The name is null!");
        }
        if (interceptor.name().length() == 0) {
            this.anonymous_ior_interceptors.addElement(interceptor);
        } else {
            if (this.named_ior_interceptors.containsKey(interceptor.name())) {
                throw new DuplicateName(interceptor.name());
            }
            this.named_ior_interceptors.put(interceptor.name(), interceptor);
        }
    }

    public void add_server_request_interceptor(ServerRequestInterceptor interceptor) throws DuplicateName {
        if (!this.valid) {
            throw new OBJECT_NOT_EXIST("This ORBInitIfo is not valid anymore!");
        }
        if (interceptor.name() == null) {
            throw new DuplicateName("The name is null!");
        }
        if (interceptor.name().length() == 0) {
            this.anonymous_server_interceptors.addElement(interceptor);
        } else {
            if (this.named_server_interceptors.containsKey(interceptor.name())) {
                throw new DuplicateName(interceptor.name());
            }
            this.named_server_interceptors.put(interceptor.name(), interceptor);
        }
    }

    public int allocate_slot_id() {
        if (!this.valid) {
            throw new OBJECT_NOT_EXIST("This ORBInitIfo is not valid anymore!");
        }
        return this.slot_count++;
    }

    public String[] arguments() {
        if (!this.valid) {
            throw new OBJECT_NOT_EXIST("This ORBInitIfo is not valid anymore!");
        }
        return this.orb._args;
    }

    public CodecFactory codec_factory() {
        if (!this.valid) {
            throw new OBJECT_NOT_EXIST("This ORBInitIfo is not valid anymore!");
        }
        try {
            return (CodecFactory)this.orb.resolve_initial_references("CodecFactory");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String orb_id() {
        if (!this.valid) {
            throw new OBJECT_NOT_EXIST("This ORBInitIfo is not valid anymore!");
        }
        return "jacorb:2.2.3";
    }

    public void register_initial_reference(String id, Object obj) throws InvalidName {
        if (!this.valid) {
            throw new OBJECT_NOT_EXIST("This ORBInitIfo is not valid anymore!");
        }
        try {
            this.orb.register_initial_reference(id, obj);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName e) {
            throw new InvalidName();
        }
    }

    public void register_policy_factory(int type, PolicyFactory policy_factory) {
        if (!this.valid) {
            throw new OBJECT_NOT_EXIST("This ORBInitIfo is not valid anymore!");
        }
        if (policy_factory == null) {
            throw new BAD_PARAM("Actual parameter policy_factory is null!");
        }
        Integer key = new Integer(type);
        if (this.policy_factories.containsKey(key)) {
            throw new BAD_INV_ORDER("A PolicyFactory for type " + type + " has already been registered!", 12, CompletionStatus.COMPLETED_MAYBE);
        }
        this.policy_factories.put(key, policy_factory);
    }

    public Object resolve_initial_references(String id) throws InvalidName {
        if (!this.valid) {
            throw new OBJECT_NOT_EXIST("This ORBInitIfo is not valid anymore!");
        }
        try {
            return this.orb.resolve_initial_references(id);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName e) {
            throw new InvalidName();
        }
    }
}

