/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.portableInterceptor.ClientInterceptorIterator;
import org.jacorb.orb.portableInterceptor.IORInterceptorIterator;
import org.jacorb.orb.portableInterceptor.PICurrentImpl;
import org.jacorb.orb.portableInterceptor.ServerInterceptorIterator;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class InterceptorManager {
    private Interceptor[] client_req_interceptors = null;
    private Interceptor[] server_req_interceptors = null;
    private Interceptor[] ior_interceptors = null;
    private int[] profile_tags = null;
    private org.omg.CORBA.ORB orb = null;
    private int current_slots = 0;
    private Logger logger;
    private static ThreadLocal piCurrent = new ThreadLocal();
    public static final PICurrentImpl EMPTY_CURRENT = new PICurrentImpl(null, 0);

    public InterceptorManager(Vector client_interceptors, Vector server_interceptors, Vector ior_intercept, int slot_count, org.omg.CORBA.ORB orb) {
        int _i;
        int min_index;
        String min;
        int j;
        this.logger = ((ORB)orb).getConfiguration().getNamedLogger("jacorb.orb.interceptors");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("InterceptorManager started with " + server_interceptors.size() + " SIs, " + client_interceptors.size() + " CIs and " + ior_intercept.size() + " IORIs");
        }
        this.client_req_interceptors = new ClientRequestInterceptor[client_interceptors.size()];
        for (j = 0; j < this.client_req_interceptors.length; ++j) {
            min = ((ClientRequestInterceptor)client_interceptors.elementAt(0)).name();
            min_index = 0;
            for (_i = 1; _i < client_interceptors.size(); ++_i) {
                if (min.compareTo(((ClientRequestInterceptor)client_interceptors.elementAt(_i)).name()) <= 0) continue;
                min = ((ClientRequestInterceptor)client_interceptors.elementAt(_i)).name();
                min_index = _i;
            }
            this.client_req_interceptors[j] = (ClientRequestInterceptor)client_interceptors.elementAt(min_index);
            client_interceptors.removeElementAt(min_index);
        }
        this.server_req_interceptors = new ServerRequestInterceptor[server_interceptors.size()];
        for (j = 0; j < this.server_req_interceptors.length; ++j) {
            min = ((ServerRequestInterceptor)server_interceptors.elementAt(0)).name();
            min_index = 0;
            for (_i = 1; _i < server_interceptors.size(); ++_i) {
                if (min.compareTo(((ServerRequestInterceptor)server_interceptors.elementAt(_i)).name()) <= 0) continue;
                min = ((ServerRequestInterceptor)server_interceptors.elementAt(_i)).name();
                min_index = _i;
            }
            this.server_req_interceptors[j] = (ServerRequestInterceptor)server_interceptors.elementAt(min_index);
            server_interceptors.removeElementAt(min_index);
        }
        this.ior_interceptors = new IORInterceptor[ior_intercept.size()];
        for (j = 0; j < this.ior_interceptors.length; ++j) {
            min = ((IORInterceptor)ior_intercept.elementAt(0)).name();
            min_index = 0;
            for (_i = 1; _i < ior_intercept.size(); ++_i) {
                if (min.compareTo(((IORInterceptor)ior_intercept.elementAt(_i)).name()) <= 0) continue;
                min = ((IORInterceptor)ior_intercept.elementAt(_i)).name();
                min_index = _i;
            }
            this.ior_interceptors[j] = (IORInterceptor)ior_intercept.elementAt(min_index);
            ior_intercept.removeElementAt(min_index);
        }
        this.orb = orb;
        this.current_slots = slot_count;
    }

    public Current getCurrent() {
        Current value = (Current)piCurrent.get();
        if (value == null) {
            value = this.getEmptyCurrent();
            piCurrent.set(value);
        }
        return value;
    }

    public void setTSCurrent(Current current) {
        piCurrent.set(current);
    }

    public void removeTSCurrent() {
        piCurrent.set(null);
    }

    public Current getEmptyCurrent() {
        return new PICurrentImpl(this.orb, this.current_slots);
    }

    public ClientInterceptorIterator getClientIterator() {
        return new ClientInterceptorIterator(this.client_req_interceptors);
    }

    public ServerInterceptorIterator getServerIterator() {
        return new ServerInterceptorIterator(this.server_req_interceptors);
    }

    public IORInterceptorIterator getIORIterator() {
        return new IORInterceptorIterator(this.ior_interceptors, this.profile_tags);
    }

    public void setProfileTags(int[] ptags) {
        this.profile_tags = ptags;
    }

    public boolean hasClientRequestInterceptors() {
        return this.client_req_interceptors.length > 0;
    }

    public boolean hasServerRequestInterceptors() {
        return this.server_req_interceptors.length > 0;
    }

    public boolean hasIORInterceptors() {
        return this.ior_interceptors.length > 0;
    }

    public void destroy() {
        int i;
        if (this.hasClientRequestInterceptors()) {
            for (i = 0; i < this.client_req_interceptors.length; ++i) {
                this.client_req_interceptors[i].destroy();
            }
        }
        if (this.hasServerRequestInterceptors()) {
            for (i = 0; i < this.server_req_interceptors.length; ++i) {
                this.server_req_interceptors[i].destroy();
            }
        }
        if (this.hasIORInterceptors()) {
            for (i = 0; i < this.ior_interceptors.length; ++i) {
                this.ior_interceptors[i].destroy();
            }
        }
    }
}

