/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.policies;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.policies.PolicyUtil;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.InvalidPolicies;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA._PolicyManagerLocalBase;

public class PolicyManager
extends _PolicyManagerLocalBase {
    private ORB orb;
    private Map policy_overrides = null;
    private Logger logger;

    public PolicyManager(ORB orb) {
        this.orb = orb;
        this.policy_overrides = new HashMap();
        this.logger = orb.getConfiguration().getNamedLogger("jacorb.orb.policies");
    }

    public synchronized Policy[] get_policy_overrides(int[] ts) {
        if (ts == null) {
            throw new IllegalArgumentException("Argument may not be null");
        }
        if (ts.length == 0) {
            return this.policy_overrides.values().toArray(new Policy[0]);
        }
        Vector<Policy> policyList = new Vector<Policy>();
        for (int i = 0; i < ts.length; ++i) {
            Policy p = (Policy)this.policy_overrides.get(new Integer(ts[i]));
            if (p == null) continue;
            policyList.add(p);
        }
        Policy[] result = policyList.toArray(new Policy[0]);
        if (this.logger.isDebugEnabled() && result.length > 0) {
            this.logger.debug("get_policy_overrides returns " + result.length + " policies");
        }
        return result;
    }

    public synchronized void set_policy_overrides(Policy[] policies, SetOverrideType set_add) throws InvalidPolicies {
        if (policies == null) {
            throw new IllegalArgumentException("Argument may not be null");
        }
        HashMap<Integer, Policy> newPolicies = new HashMap<Integer, Policy>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < policies.length; ++i) {
            if (!PolicyUtil.isInvocationPolicy(policies[i].policy_type())) {
                throw new NO_PERMISSION("Not an invocation policy, type " + policies[i].policy_type());
            }
            Integer key = new Integer(policies[i].policy_type());
            if (newPolicies.put(key, policies[i]) != null) {
                throw new BAD_PARAM("Multiple policies of type " + policies[i].policy_type(), 30, CompletionStatus.COMPLETED_NO);
            }
            sb.append(" " + policies[i].policy_type());
        }
        if (set_add == SetOverrideType.SET_OVERRIDE) {
            PolicyUtil.checkValidity(newPolicies);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SET_OVERRIDE, types: " + sb.toString());
            }
            this.policy_overrides = newPolicies;
        } else if (set_add == SetOverrideType.ADD_OVERRIDE) {
            HashMap<Integer, Policy> test = new HashMap<Integer, Policy>();
            test.putAll(newPolicies);
            PolicyUtil.checkValidity(test);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ADD_OVERRIDE, types: " + sb.toString());
            }
            this.policy_overrides = test;
        }
    }
}

