/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.omg.CORBA.portable.InputStream;

public class IIOPAddress
extends ProtocolAddressBase {
    private String source_name = null;
    private InetAddress host = null;
    private int port = -1;
    private boolean unresolvable = false;
    private boolean dnsEnabled = false;
    private Logger logger;

    public IIOPAddress(String hoststr, int port) {
        this.source_name = hoststr;
        this.port = port < 0 ? port + 65536 : port;
    }

    public IIOPAddress() {
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.logger = this.configuration.getNamedLogger("jacorb.iiop.address");
        this.dnsEnabled = configuration.getAttribute("jacorb.dns.enable", "off").equals("on");
    }

    private void init_host() {
        InetAddress localhost = null;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            byte[] lhaddr = new byte[]{127, 0, 0, 1};
            try {
                localhost = InetAddress.getByAddress("127.0.0.1", lhaddr);
            }
            catch (UnknownHostException ex2) {
                // empty catch block
            }
        }
        if (this.source_name == null || this.source_name.length() == 0) {
            this.host = localhost;
        } else {
            String hostname = null;
            String ip = null;
            int slash = this.source_name.indexOf(47);
            if (slash == -1) {
                ip = this.source_name;
            } else {
                ip = this.source_name.substring(slash + 1);
                if (slash > 0) {
                    hostname = this.source_name.substring(0, slash);
                }
            }
            byte[] hostIP = new byte[4];
            try {
                this.host = this.dnsEnabled || !IIOPAddress.isIP(ip, hostIP) ? InetAddress.getByName(ip) : InetAddress.getByAddress(hostIP);
            }
            catch (UnknownHostException ex) {
                if (this.logger != null && this.logger.isWarnEnabled()) {
                    this.logger.warn("init_host, " + this.source_name + " unresolvable");
                }
                this.unresolvable = true;
                try {
                    this.host = InetAddress.getByAddress(this.source_name, localhost.getAddress());
                }
                catch (UnknownHostException ex2) {
                    // empty catch block
                }
            }
        }
    }

    private static boolean isIP(String host, byte[] buffer) {
        int index = 0;
        int numberStart = 0;
        int length = host.length();
        int ch = 32;
        for (int i = 0; i < 4; ++i) {
            int octet = 0;
            while (index < length && (ch = (int)host.charAt(index)) != 46) {
                if (ch < 48 || ch > 57) {
                    return false;
                }
                octet = octet * 10 + (ch - 48);
                ++index;
            }
            if (octet >= 256) {
                return false;
            }
            buffer[i] = (byte)octet;
            if (index >= length && i == 3 && index - numberStart <= 3 && index - numberStart > 0) {
                return true;
            }
            if (ch != 46 || index - numberStart > 3 || index - numberStart <= 0) {
                return false;
            }
            numberStart = ++index;
        }
        return false;
    }

    public static IIOPAddress read(InputStream in) {
        String host = in.read_string();
        short port = in.read_ushort();
        IIOPAddress addr = new IIOPAddress(host, port);
        return addr;
    }

    public String getIP() {
        if (this.host == null) {
            this.init_host();
        }
        if (this.unresolvable) {
            return this.source_name;
        }
        return this.host.getHostAddress();
    }

    public String getHostname() {
        if (this.host == null) {
            this.init_host();
        }
        if (this.unresolvable) {
            return this.source_name;
        }
        return this.dnsEnabled ? this.host.getCanonicalHostName() : this.host.getHostAddress();
    }

    public void setHostname(String hn) {
        this.host = null;
        this.source_name = hn;
    }

    public InetAddress getConfiguredHost() {
        if (this.source_name == null || this.source_name.length() == 0) {
            return null;
        }
        if (this.host == null) {
            this.init_host();
        }
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public boolean equals(Object other) {
        if (other instanceof IIOPAddress) {
            IIOPAddress x = (IIOPAddress)other;
            if (this.port == x.port) {
                return this.source_name.equals(x.source_name);
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        if (this.source_name != null) {
            return this.source_name.hashCode() + this.port;
        }
        if (this.host != null) {
            return this.host.hashCode() + this.port;
        }
        return this.port;
    }

    public String toString() {
        return this.getHostname() + ":" + this.port;
    }

    public boolean fromString(String s) {
        int colon = s.indexOf(58);
        if (colon == -1) {
            return false;
        }
        this.source_name = null;
        int p = 0;
        this.source_name = colon > 0 ? s.substring(0, colon) : "";
        if (colon < s.length() - 1) {
            p = Integer.parseInt(s.substring(colon + 1));
        }
        this.init_host();
        this.port = p < 0 ? p + 65536 : p;
        return true;
    }

    public void write(CDROutputStream cdr) {
        cdr.write_string(this.getHostname());
        cdr.write_ushort((short)this.port);
    }

    public static IIOPAddress read(CDRInputStream cdr) {
        String hostname = cdr.read_string();
        short port = cdr.read_ushort();
        return new IIOPAddress(hostname, port);
    }

    public String getOriginalHost() {
        if (this.source_name == null) {
            if (!this.dnsEnabled) {
                return this.getIP();
            }
            return this.getHostname() + " / " + this.getIP();
        }
        return this.source_name;
    }

    void replaceFrom(IIOPAddress other) {
        if (other.source_name != null) {
            this.setHostname(other.source_name);
        }
        if (other.port != -1) {
            this.setPort(other.port);
        }
    }
}

