/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.orb.iiop.IIOPLoopback;
import org.jacorb.orb.iiop.IIOPLoopbackInputStream;
import org.jacorb.orb.iiop.IIOPLoopbackOutputStream;
import org.jacorb.orb.iiop.IIOPLoopbackRegistry;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.ETF.Profile;
import org.omg.SSLIOP.SSL;

public class ClientIIOPConnection
extends IIOPConnection
implements Configurable {
    private int timeout = 0;
    private int ssl_port = -1;
    private int noOfRetries = 5;
    private int retryInterval = 0;
    private boolean doSupportSSL = false;
    private TransportManager transportManager;
    public static int openTransports = 0;
    private Exception exception = null;
    static /* synthetic */ Class class$org$omg$CSIIOP$CompoundSecMechListHelper;
    static /* synthetic */ Class class$org$omg$SSLIOP$SSLHelper;

    public ClientIIOPConnection() {
        this.use_ssl = false;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.timeout = configuration.getAttributeAsInteger("jacorb.connection.client.idle_timeout", 0);
        this.noOfRetries = configuration.getAttributeAsInteger("jacorb.retries", 5);
        this.retryInterval = configuration.getAttributeAsInteger("jacorb.retry_interval", 500);
        this.doSupportSSL = configuration.getAttribute("jacorb.security.support_ssl", "off").equals("on");
        this.transportManager = this.configuration.getORB().getTransportManager();
    }

    public ClientIIOPConnection(ClientIIOPConnection other) {
        super(other);
        this.timeout = other.timeout;
        this.ssl_port = other.ssl_port;
    }

    public synchronized void connect(Profile server_profile, long time_out) {
        if (!this.connected) {
            if (!(server_profile instanceof IIOPProfile)) {
                throw new BAD_PARAM("attempt to connect an IIOP connection to a non-IIOP profile: " + server_profile.getClass());
            }
            this.profile = (IIOPProfile)server_profile;
            IIOPLoopback loopback = this.getLocalLoopback();
            if (loopback != null) {
                IIOPLoopbackInputStream lis = new IIOPLoopbackInputStream();
                IIOPLoopbackOutputStream los = new IIOPLoopbackOutputStream();
                loopback.initLoopback(lis, los);
                this.in_stream = lis;
                this.out_stream = los;
                this.connected = true;
                ++openTransports;
                return;
            }
            this.checkSSL();
            int retries = this.noOfRetries;
            while (retries >= 0) {
                try {
                    this.createSocket(time_out);
                    if (this.timeout != 0) {
                        this.socket.setSoTimeout(this.timeout);
                    }
                    this.in_stream = this.socket.getInputStream();
                    this.out_stream = new BufferedOutputStream(this.socket.getOutputStream());
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Connected to " + this.connection_info + " from local port " + this.socket.getLocalPort() + (this.isSSL() ? " via SSL" : ""));
                    }
                    this.connected = true;
                    ++openTransports;
                    return;
                }
                catch (IOException c) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Exception", (Throwable)c);
                    }
                    if (--retries < 0) continue;
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Retrying to connect to " + this.connection_info);
                    }
                    try {
                        Thread.sleep(this.retryInterval);
                    }
                    catch (InterruptedException i) {}
                }
                catch (TIMEOUT e) {
                    this.profile = null;
                    this.use_ssl = false;
                    this.ssl_port = -1;
                    throw e;
                }
            }
            if (retries < 0) {
                this.profile = null;
                this.use_ssl = false;
                this.ssl_port = -1;
                throw new TRANSIENT("Retries exceeded, couldn't reconnect to " + this.connection_info);
            }
        }
    }

    private IIOPLoopback getLocalLoopback() {
        IIOPProfile iiopProfile = (IIOPProfile)this.profile;
        ArrayList<ProtocolAddressBase> addressList = new ArrayList<ProtocolAddressBase>();
        addressList.add(iiopProfile.getAddress());
        addressList.addAll(iiopProfile.getAlternateAddresses());
        Iterator addressIterator = addressList.iterator();
        IIOPLoopbackRegistry registry = IIOPLoopbackRegistry.getRegistry();
        while (addressIterator.hasNext()) {
            IIOPAddress address = (IIOPAddress)addressIterator.next();
            IIOPLoopback loopback = registry.getLoopback(address);
            if (loopback == null) continue;
            return loopback;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSocket(long time_out) throws IOException {
        ArrayList<ProtocolAddressBase> addressList = new ArrayList<ProtocolAddressBase>();
        addressList.add(((IIOPProfile)this.profile).getAddress());
        addressList.addAll(((IIOPProfile)this.profile).getAlternateAddresses());
        Iterator addressIterator = addressList.iterator();
        this.exception = null;
        this.socket = null;
        while (this.socket == null && addressIterator.hasNext()) {
            try {
                IIOPAddress address = (IIOPAddress)addressIterator.next();
                final SocketFactory factory = this.use_ssl ? this.transportManager.getSSLSocketFactory() : this.transportManager.getSocketFactory();
                final String ipAddress = address.getIP();
                final int port = this.use_ssl ? this.ssl_port : address.getPort();
                this.connection_info = ipAddress + ":" + port;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Trying to connect to " + this.connection_info + " with timeout=" + time_out);
                }
                this.exception = null;
                this.socket = null;
                if (time_out > 0L) {
                    final ClientIIOPConnection self = this;
                    Thread thread = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run() {
                            ClientIIOPConnection clientIIOPConnection;
                            try {
                                try {
                                    ClientIIOPConnection.this.socket = factory.createSocket(ipAddress, port);
                                }
                                catch (Exception e) {
                                    ClientIIOPConnection.this.exception = e;
                                    Object var3_2 = null;
                                    ClientIIOPConnection clientIIOPConnection3 = self;
                                    synchronized (clientIIOPConnection3) {
                                        self.notify();
                                        return;
                                    }
                                }
                                Object var3_1 = null;
                                clientIIOPConnection = self;
                            }
                            catch (Throwable throwable) {
                                Object var3_3 = null;
                                ClientIIOPConnection clientIIOPConnection2 = self;
                                synchronized (clientIIOPConnection2) {
                                    self.notify();
                                    throw throwable;
                                }
                            }
                            synchronized (clientIIOPConnection) {
                                self.notify();
                                return;
                            }
                        }
                    });
                    thread.setDaemon(true);
                    try {
                        ClientIIOPConnection clientIIOPConnection = self;
                        synchronized (clientIIOPConnection) {
                            thread.start();
                            self.wait(time_out);
                        }
                    }
                    catch (InterruptedException _ex) {
                        // empty catch block
                    }
                    if (this.socket != null) continue;
                    if (this.exception == null) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("connect to " + this.connection_info + " with timeout=" + time_out + " timed out");
                        }
                        thread.interrupt();
                        this.exception = new TIMEOUT("connection timeout of " + time_out + " milliseconds expired");
                        continue;
                    }
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("connect to " + this.connection_info + " with timeout=" + time_out + " raised exception: " + this.exception.toString());
                    continue;
                }
                this.socket = factory.createSocket(ipAddress, port);
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
        if (this.exception != null) {
            if (this.exception instanceof IOException) {
                throw (IOException)this.exception;
            }
            if (this.exception instanceof TIMEOUT) {
                throw (TIMEOUT)this.exception;
            }
            throw new IOException("Unexpected exception occured: " + this.exception.toString());
        }
    }

    public synchronized void close() {
        try {
            if (this.connected) {
                if (this.socket != null) {
                    this.socket.close();
                }
                if (this.in_stream != null) {
                    this.in_stream.close();
                }
                if (this.out_stream != null) {
                    this.out_stream.close();
                }
                --openTransports;
            }
            this.connected = false;
        }
        catch (IOException ex) {
            throw this.to_COMM_FAILURE(ex);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Client-side TCP transport to " + this.connection_info + " closed.");
        }
    }

    private void checkSSL() {
        CompoundSecMechList sas = (CompoundSecMechList)((IIOPProfile)this.profile).getComponent(33, class$org$omg$CSIIOP$CompoundSecMechListHelper == null ? (class$org$omg$CSIIOP$CompoundSecMechListHelper = ClientIIOPConnection.class$("org.omg.CSIIOP.CompoundSecMechListHelper")) : class$org$omg$CSIIOP$CompoundSecMechListHelper);
        TLS_SEC_TRANS tls = null;
        if (sas != null && sas.mechanism_list[0].transport_mech.tag == 36) {
            try {
                byte[] tagData = sas.mechanism_list[0].transport_mech.component_data;
                CDRInputStream in = new CDRInputStream(null, tagData);
                in.openEncapsulatedArray();
                tls = TLS_SEC_TRANSHelper.read(in);
            }
            catch (Exception ex) {
                this.logger.warn("Error parsing TLS_SEC_TRANS: " + ex);
            }
        }
        SSL ssl = (SSL)((IIOPProfile)this.profile).getComponent(20, class$org$omg$SSLIOP$SSLHelper == null ? (class$org$omg$SSLIOP$SSLHelper = ClientIIOPConnection.class$("org.omg.SSLIOP.SSLHelper")) : class$org$omg$SSLIOP$SSLHelper);
        int minimum_options = 126;
        int client_required = 0;
        int client_supported = 0;
        if (this.doSupportSSL) {
            client_required = this.configuration.getAttributeAsInteger("jacorb.security.ssl.client.required_options", 16);
            client_supported = this.configuration.getAttributeAsInteger("jacorb.security.ssl.client.supported_options", 16);
        }
        if (tls != null && (tls.target_supports & minimum_options) != 0 && this.doSupportSSL && (client_supported & minimum_options) != 0 && ((tls.target_requires & minimum_options) != 0 || (client_required & minimum_options) != 0)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Selecting TLS for connection");
            }
            this.use_ssl = true;
            this.ssl_port = tls.addresses[0].port;
            if (this.ssl_port < 0) {
                this.ssl_port += 65536;
            }
        } else if (ssl != null && (ssl.target_supports & minimum_options) != 0 && this.doSupportSSL && (client_supported & minimum_options) != 0 && ((ssl.target_requires & minimum_options) != 0 || (client_required & minimum_options) != 0)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Selecting SSL for connection");
            }
            this.use_ssl = true;
            this.ssl_port = ssl.port;
            if (this.ssl_port < 0) {
                this.ssl_port += 65536;
            }
        } else {
            if (this.doSupportSSL && (client_required & minimum_options) != 0) {
                throw new NO_PERMISSION("Client-side policy requires SSL/TLS, but server doesn't support it");
            }
            this.use_ssl = false;
            this.ssl_port = -1;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

