/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.jacorb.orb.ORB;
import org.jacorb.orb.giop.MessageInputStream;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.portable.RemarshalException;

public abstract class ReplyPlaceholder {
    protected boolean ready = false;
    protected boolean communicationException = false;
    protected boolean remarshalException = false;
    protected boolean timeoutException = false;
    protected MessageInputStream in = null;
    protected int timeout;

    public ReplyPlaceholder(ORB orb) {
        this.timeout = orb.getConfiguration().getAttributeAsInteger("jacorb.connection.client.pending_reply_timeout", 0);
    }

    public synchronized void replyReceived(MessageInputStream in) {
        if (!this.timeoutException) {
            this.in = in;
            this.ready = true;
            this.notifyAll();
        }
    }

    public synchronized void cancel() {
        if (this.in == null) {
            this.communicationException = true;
            this.ready = true;
            this.notify();
        }
    }

    public synchronized void retry() {
        this.remarshalException = true;
        this.ready = true;
        this.notify();
    }

    protected synchronized MessageInputStream getInputStream() throws RemarshalException {
        while (!this.ready) {
            try {
                if (this.timeout > 0) {
                    this.wait(this.timeout);
                    if (this.ready) continue;
                    this.ready = true;
                    this.timeoutException = true;
                    continue;
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.remarshalException) {
            throw new RemarshalException();
        }
        if (this.communicationException) {
            throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.timeoutException) {
            throw new TIMEOUT("client timeout reached");
        }
        return this.in;
    }
}

