/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.LocateReplyOutputStream;
import org.jacorb.orb.giop.MessageOutputStream;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.orb.giop.ServiceContextTransportingOutputStream;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.UNKNOWN;
import org.omg.GIOP.ReplyStatusType_1_0;
import org.omg.GIOP.ReplyStatusType_1_0Helper;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.GIOP.ReplyStatusType_1_2Helper;
import org.omg.IOP.IORHelper;
import org.omg.IOP.ServiceContextListHelper;

public class ReplyOutputStream
extends ServiceContextTransportingOutputStream {
    private boolean is_locate_reply = false;
    private Logger logger;

    public ReplyOutputStream(int request_id, ReplyStatusType_1_2 reply_status, int giop_minor, boolean is_locate_reply, Logger logger) {
        this.is_locate_reply = is_locate_reply;
        this.setGIOPMinor(giop_minor);
        this.writeGIOPMsgHeader(1, giop_minor);
        switch (giop_minor) {
            case 0: 
            case 1: {
                ServiceContextListHelper.write(this, Messages.service_context);
                this.write_ulong(request_id);
                ReplyStatusType_1_0Helper.write(this, ReplyStatusType_1_0.from_int(reply_status.value()));
                break;
            }
            case 2: {
                this.write_ulong(request_id);
                ReplyStatusType_1_2Helper.write(this, reply_status);
                ServiceContextListHelper.write(this, Messages.service_context);
                this.markHeaderEnd();
                break;
            }
            default: {
                throw new MARSHAL("Unknown GIOP minor: " + giop_minor);
            }
        }
    }

    public void write_to(GIOPConnection conn) throws IOException {
        if (this.is_locate_reply) {
            ReplyInputStream r_in = new ReplyInputStream(null, this.getBufferCopy());
            MessageOutputStream lr_out = null;
            if (r_in.getGIOPMinor() < 2) {
                switch (r_in.rep_hdr.reply_status.value()) {
                    case 0: {
                        int status = r_in.read_boolean() ? 0 : 1;
                        lr_out = new LocateReplyOutputStream(r_in.rep_hdr.request_id, status, r_in.getGIOPMinor());
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("Received an exception when processing a LocateRequest");
                        }
                        lr_out = new LocateReplyOutputStream(r_in.rep_hdr.request_id, 0, r_in.getGIOPMinor());
                        break;
                    }
                    case 3: {
                        lr_out = new LocateReplyOutputStream(r_in.rep_hdr.request_id, 2, r_in.getGIOPMinor());
                        lr_out.write_IOR(IORHelper.read(r_in));
                    }
                }
            } else {
                switch (r_in.rep_hdr.reply_status.value()) {
                    case 0: {
                        int status = r_in.read_boolean() ? 0 : 1;
                        lr_out = new LocateReplyOutputStream(r_in.rep_hdr.request_id, status, r_in.getGIOPMinor());
                        break;
                    }
                    case 1: {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("Received an exception when processing a LocateRequest - mapping to UNKNOWN system exception");
                        }
                        lr_out = new LocateReplyOutputStream(r_in.rep_hdr.request_id, 4, r_in.getGIOPMinor());
                        SystemExceptionHelper.write(lr_out, new UNKNOWN());
                    }
                    case 2: {
                        lr_out = new LocateReplyOutputStream(r_in.rep_hdr.request_id, 4, r_in.getGIOPMinor());
                        SystemExceptionHelper.write(lr_out, SystemExceptionHelper.read(r_in));
                        break;
                    }
                    case 3: {
                        lr_out = new LocateReplyOutputStream(r_in.rep_hdr.request_id, 2, r_in.getGIOPMinor());
                        lr_out.write_IOR(IORHelper.read(r_in));
                    }
                }
            }
            lr_out.write_to(conn);
        } else {
            super.write_to(conn);
        }
    }
}

