/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.MessageReceptor;
import org.jacorb.util.threadpool.Consumer;
import org.jacorb.util.threadpool.ConsumerFactory;
import org.jacorb.util.threadpool.ThreadPool;

public class MessageReceptorPool {
    private static final int MAX_DEFAULT = 1000;
    private static MessageReceptorPool singleton = null;
    private int maxConnectionThreads = 1000;
    private ThreadPool pool = null;

    private MessageReceptorPool(Configuration myConfiguration) {
        org.jacorb.config.Configuration configuration = (org.jacorb.config.Configuration)myConfiguration;
        int maxConnectionThreads = 1000;
        String attribute = "jacorb.connection.max_threads";
        maxConnectionThreads = configuration.getAttributeAsInteger("jacorb.connection.max_threads", 1000);
        Logger logger = configuration.getNamedLogger("jacorb.orb.giop");
        if (logger.isDebugEnabled()) {
            logger.debug("Maximum connection threads: " + maxConnectionThreads);
        }
        this.pool = new ThreadPool(new ConsumerFactory(){

            public Consumer create() {
                return new MessageReceptor();
            }
        }, maxConnectionThreads, 5);
    }

    public static synchronized MessageReceptorPool getInstance(Configuration myConfiguration) {
        if (singleton == null) {
            singleton = new MessageReceptorPool(myConfiguration);
        }
        return singleton;
    }

    public void connectionCreated(GIOPConnection conn) {
        this.pool.putJob(conn);
    }
}

