/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.etf;

import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.ETF.Connection;
import org.omg.ETF.Handle;
import org.omg.ETF.Profile;
import org.omg.ETF._ListenerLocalBase;

public abstract class ListenerBase
extends _ListenerLocalBase
implements Configurable {
    protected ORB orb = null;
    protected Profile profile = null;
    protected Acceptor acceptor = null;
    protected org.jacorb.config.Configuration configuration = null;
    protected Logger logger = null;
    protected Handle up = null;
    protected List incoming_connections = new ArrayList();
    protected boolean terminated = false;

    public ListenerBase() {
    }

    public ListenerBase(ORB orb) {
        this.orb = orb;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)configuration;
        if (this.orb == null) {
            this.orb = this.configuration.getORB();
        }
        this.logger = this.configuration.getNamedLogger(this.configuration.getLoggerName(this.getClass()));
    }

    public void set_handle(Handle up) {
        this.up = up;
    }

    public void listen() {
        if (this.acceptor != null) {
            this.acceptor.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deliverConnection(Connection connection) {
        if (this.up != null) {
            this.up.add_input(connection);
        } else {
            List list = this.incoming_connections;
            synchronized (list) {
                this.incoming_connections.add(connection);
                this.incoming_connections.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection accept() {
        if (this.up != null) {
            throw new BAD_INV_ORDER("Must not call accept() when a Handle has been set");
        }
        List list = this.incoming_connections;
        synchronized (list) {
            while (!this.terminated && this.incoming_connections.isEmpty()) {
                try {
                    this.incoming_connections.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.terminated) {
                return (Connection)this.incoming_connections.remove(0);
            }
            return null;
        }
    }

    public void completed_data(Connection conn) {
        throw new NO_IMPLEMENT();
    }

    public void destroy() {
        if (this.acceptor != null) {
            this.acceptor.terminate();
        }
        this.terminated = true;
        if (this.up == null) {
            this.incoming_connections.notifyAll();
        }
    }

    public Profile endpoint() {
        return this.profile.copy();
    }

    protected abstract class Acceptor
    extends Thread {
        protected Acceptor() {
        }

        protected abstract void init();

        public abstract void run();

        public abstract void terminate();
    }
}

