/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.dsi;

import java.util.Enumeration;
import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.NVList;
import org.jacorb.orb.NamedValue;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestInputStream;
import org.jacorb.orb.portableInterceptor.ServerInterceptorIterator;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.Time;
import org.omg.CORBA.Any;
import org.omg.CORBA.Context;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.ParameterMode;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.Dynamic.Parameter;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.IOP.ServiceContext;
import org.omg.Messaging.PolicyValue;
import org.omg.Messaging.PolicyValueSeqHelper;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.TimeBase.UtcT;

public class ServerRequest
extends org.omg.CORBA.ServerRequest
implements ResponseHandler {
    private RequestInputStream in;
    private ReplyOutputStream out;
    private GIOPConnection connection;
    private UtcT requestStartTime = null;
    private UtcT requestEndTime = null;
    private UtcT replyEndTime = null;
    private List scopes;
    private boolean cachePoaNames;
    private int status = 0;
    private byte[] oid;
    private byte[] object_key;
    private Object reference = null;
    private String[] rest_of_name = null;
    private boolean stream_based;
    private SystemException sys_ex;
    private org.omg.PortableServer.ForwardRequest location_forward;
    private Any ex;
    private Any result;
    private NVList args;
    private ORB orb;
    private boolean usePreconstructedReply = false;
    private ServerRequestInfoImpl info = null;
    private Logger logger;

    public ServerRequest(ORB orb, RequestInputStream in, GIOPConnection _connection) {
        this.orb = orb;
        Configuration config = orb.getConfiguration();
        this.logger = config.getNamedLogger("jacorb.org.giop");
        this.cachePoaNames = config.getAttribute("jacorb.cachePoaNames", "off").equals("on");
        this.in = in;
        this.connection = _connection;
        this.getTimingPolicies();
        this.object_key = orb.mapObjectKey(ParsedIOR.extractObjectKey(in.req_hdr.target, orb));
        this.oid = POAUtil.extractOID(this.object_key);
    }

    public void setRemainingPOAName(String[] rest_of_name) {
        this.rest_of_name = rest_of_name;
    }

    public String[] remainingPOAName() {
        return this.rest_of_name;
    }

    public String operation() {
        return this.in.req_hdr.operation;
    }

    public Any result() {
        if (this.stream_based) {
            Any any = this.orb.create_any();
            CDROutputStream _out = (CDROutputStream)any.create_output_stream();
            byte[] result_buf = this.out.getBody();
            _out.setBuffer(result_buf);
            _out.skip(result_buf.length);
            return any;
        }
        return this.result;
    }

    public org.omg.CORBA.NVList arguments() {
        if (this.stream_based) {
            throw new RuntimeException("This ServerRequest is stream-based!");
        }
        return this.args;
    }

    public Any except() {
        if (this.stream_based) {
            throw new RuntimeException("This ServerRequest is stream-based!");
        }
        return this.ex;
    }

    public ReplyStatusType_1_2 status() {
        return ReplyStatusType_1_2.from_int(this.status);
    }

    public Context ctx() {
        return null;
    }

    public void arguments(org.omg.CORBA.NVList p) {
        this.args = (NVList)p;
        if (this.args != null) {
            this.in.mark(0);
            Enumeration e = this.args.enumerate();
            while (e.hasMoreElements()) {
                org.omg.CORBA.NamedValue nv = (org.omg.CORBA.NamedValue)e.nextElement();
                if (nv.flags() == 2) continue;
                try {
                    nv.value().read_value(this.in, nv.value().type());
                }
                catch (Exception ex) {
                    throw new MARSHAL("Couldn't unmarshal object of type " + nv.value().type() + " in ServerRequest.");
                }
            }
            try {
                this.in.reset();
            }
            catch (Exception ex) {
                throw new UNKNOWN("Could not reset input stream");
            }
            if (this.info != null) {
                Parameter[] params = new Parameter[this.args.count()];
                for (int i = 0; i < params.length; ++i) {
                    try {
                        org.omg.CORBA.NamedValue value = this.args.item(i);
                        ParameterMode mode = null;
                        if (value.flags() == 1) {
                            mode = ParameterMode.PARAM_IN;
                        } else if (value.flags() == 2) {
                            mode = ParameterMode.PARAM_OUT;
                        } else if (value.flags() == 3) {
                            mode = ParameterMode.PARAM_INOUT;
                        }
                        params[i] = new Parameter(value.value(), mode);
                        continue;
                    }
                    catch (Exception e2) {
                        if (!this.logger.isInfoEnabled()) continue;
                        this.logger.info("Caught exception ", (Throwable)e2);
                    }
                }
                this.info.setArguments(params);
                ServerInterceptorIterator intercept_iter = this.orb.getInterceptorManager().getServerIterator();
                try {
                    intercept_iter.iterate(this.info, (short)1);
                }
                catch (UserException ue) {
                    if (ue instanceof ForwardRequest) {
                        ForwardRequest fwd = (ForwardRequest)ue;
                        this.setLocationForward(new org.omg.PortableServer.ForwardRequest(fwd.forward));
                    }
                }
                catch (SystemException _sys_ex) {
                    this.setSystemException(_sys_ex);
                }
                this.info = null;
            }
        }
    }

    public void set_result(Any res) {
        if (this.stream_based) {
            throw new RuntimeException("This ServerRequest is stream-based!");
        }
        this.result = res;
    }

    public void set_exception(Any ex) {
        if (this.stream_based) {
            throw new RuntimeException("This ServerRequest is stream-based!");
        }
        this.ex = ex;
        this.status = 1;
    }

    public void reply() {
        block21: {
            if (this.responseExpected()) {
                if (this.usePreconstructedReply) {
                    block20: {
                        try {
                            this.connection.sendReply(this.out);
                        }
                        catch (Exception ioe) {
                            if (!this.logger.isInfoEnabled()) break block20;
                            this.logger.info("Error replying to request!", (Throwable)ioe);
                        }
                    }
                    return;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ServerRequest: reply to " + this.operation());
                }
                try {
                    if (this.out == null) {
                        this.out = new ReplyOutputStream(this.requestId(), ReplyStatusType_1_2.from_int(this.status), this.in.getGIOPMinor(), this.in.isLocateRequest(), this.logger);
                    }
                    if (!this.stream_based) {
                        if (this.status == 1) {
                            this.out.write_string(this.ex.type().id());
                            this.ex.write_value(this.out);
                        } else if (this.status == 0) {
                            if (this.result != null) {
                                this.result.write_value(this.out);
                            }
                            if (this.args != null) {
                                Enumeration e = this.args.enumerate();
                                while (e.hasMoreElements()) {
                                    NamedValue nv = (NamedValue)e.nextElement();
                                    if (nv.flags() == 1) continue;
                                    try {
                                        nv.send(this.out);
                                    }
                                    catch (Exception ex) {
                                        throw new MARSHAL("Couldn't return (in)out arg of type " + nv.value().type() + " in ServerRequest.");
                                    }
                                }
                            }
                        }
                    }
                    if (this.status == 3) {
                        this.out.write_Object(this.location_forward.forward_reference);
                    } else if (this.status == 2) {
                        SystemExceptionHelper.write(this.out, this.sys_ex);
                    }
                    this.connection.sendReply(this.out);
                }
                catch (Exception ioe) {
                    if (!this.logger.isInfoEnabled()) break block21;
                    this.logger.info("Error replying to request!", (Throwable)ioe);
                }
            }
        }
    }

    public OutputStream createReply() {
        this.stream_based = true;
        if (this.out != null) {
            return this.out;
        }
        if (!this.stream_based) {
            throw new INTERNAL("ServerRequest not stream-based!");
        }
        this.out = new ReplyOutputStream(this.requestId(), ReplyStatusType_1_2.NO_EXCEPTION, this.in.getGIOPMinor(), this.in.isLocateRequest(), this.logger);
        return this.out;
    }

    public OutputStream createExceptionReply() {
        this.stream_based = true;
        this.status = 1;
        this.out = new ReplyOutputStream(this.requestId(), ReplyStatusType_1_2.USER_EXCEPTION, this.in.getGIOPMinor(), this.in.isLocateRequest(), this.logger);
        return this.out;
    }

    public void setSystemException(SystemException s) {
        this.status = 2;
        this.out = new ReplyOutputStream(this.requestId(), ReplyStatusType_1_2.SYSTEM_EXCEPTION, this.in.getGIOPMinor(), this.in.isLocateRequest(), this.logger);
        String msg = s.getMessage();
        if (msg != null) {
            this.out.addServiceContext(this.createExceptionDetailMessage(msg));
        }
        this.sys_ex = s;
    }

    private ServiceContext createExceptionDetailMessage(String message) {
        CDROutputStream out = new CDROutputStream();
        out.beginEncapsulatedArray();
        out.write_wstring(message);
        return new ServiceContext(14, out.getBufferCopy());
    }

    public void setLocationForward(org.omg.PortableServer.ForwardRequest r) {
        this.status = 3;
        this.out = new ReplyOutputStream(this.requestId(), ReplyStatusType_1_2.LOCATION_FORWARD, this.in.getGIOPMinor(), this.in.isLocateRequest(), this.logger);
        this.location_forward = r;
    }

    public CDRInputStream getInputStream() {
        this.stream_based = true;
        return this.in;
    }

    public ReplyOutputStream getReplyOutputStream() {
        if (this.out == null) {
            this.createReply();
        }
        this.stream_based = true;
        return this.out;
    }

    public boolean responseExpected() {
        return Messages.responseExpected(this.in.req_hdr.response_flags);
    }

    public short syncScope() {
        switch (this.in.req_hdr.response_flags) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        throw new RuntimeException("Illegal SYNC_SCOPE: " + this.in.req_hdr.response_flags);
    }

    public SystemException getSystemException() {
        return this.sys_ex;
    }

    public int requestId() {
        return this.in.req_hdr.request_id;
    }

    public byte[] objectKey() {
        return this.object_key;
    }

    public List getScopes() {
        if (this.scopes == null || !this.cachePoaNames) {
            this.scopes = POAUtil.extractScopedPOANames(POAUtil.extractPOAName(this.object_key));
        }
        return this.scopes;
    }

    public ServiceContext[] getServiceContext() {
        return this.in.req_hdr.service_context;
    }

    public byte[] objectId() {
        return this.oid;
    }

    public boolean streamBased() {
        return this.stream_based;
    }

    public void setReference(Object o) {
        this.reference = o;
    }

    public Object getReference() {
        return this.reference;
    }

    public RequestInputStream get_in() {
        return this.in;
    }

    public ReplyOutputStream get_out() {
        if (this.out == null) {
            this.out = new ReplyOutputStream(this.requestId(), ReplyStatusType_1_2.NO_EXCEPTION, this.in.getGIOPMinor(), this.in.isLocateRequest(), this.logger);
        }
        return this.out;
    }

    public void setServerRequestInfo(ServerRequestInfoImpl info) {
        this.info = info;
    }

    public Object getForwardReference() {
        if (this.location_forward != null) {
            return this.location_forward.forward_reference;
        }
        return null;
    }

    public GIOPConnection getConnection() {
        return this.connection;
    }

    public void setUsePreconstructedReply(boolean use) {
        this.usePreconstructedReply = use;
    }

    private void getTimingPolicies() {
        ServiceContext ctx = this.in.getServiceContext(7);
        if (ctx != null) {
            CDRInputStream input = new CDRInputStream(null, ctx.context_data);
            input.openEncapsulatedArray();
            PolicyValue[] p = PolicyValueSeqHelper.read(input);
            for (int i = 0; i < p.length; ++i) {
                if (p[i].ptype == 27) {
                    this.requestStartTime = Time.fromCDR(p[i].pvalue);
                    continue;
                }
                if (p[i].ptype == 28) {
                    this.requestEndTime = Time.fromCDR(p[i].pvalue);
                    continue;
                }
                if (p[i].ptype != 30) continue;
                this.replyEndTime = Time.fromCDR(p[i].pvalue);
            }
        }
    }

    public UtcT getReplyEndTime() {
        return this.replyEndTime;
    }

    public UtcT getRequestEndTime() {
        return this.requestEndTime;
    }

    public UtcT getRequestStartTime() {
        return this.requestStartTime;
    }
}

