/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ClientInterceptorHandler;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ExceptionHolderImpl;
import org.jacorb.orb.ORB;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.MessageInputStream;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.orb.giop.ReplyPlaceholder;
import org.jacorb.util.Time;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.ServantObject;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.Messaging.ReplyHandler;
import org.omg.TimeBase.UtcT;

public class ReplyReceiver
extends ReplyPlaceholder
implements Configurable {
    private Delegate delegate = null;
    private ClientInterceptorHandler interceptors = null;
    private ReplyHandler replyHandler = null;
    private String operation;
    private UtcT replyEndTime;
    private Timer timer;
    private Configuration configuration = null;
    private Logger logger;
    private boolean retry_on_failure = false;
    static /* synthetic */ Class class$org$omg$CORBA$portable$InvokeHandler;

    public ReplyReceiver(Delegate delegate, String operation, UtcT replyEndTime, ClientInterceptorHandler interceptors, ReplyHandler replyHandler) {
        super((ORB)delegate.orb(null));
        this.delegate = delegate;
        this.operation = operation;
        this.replyEndTime = replyEndTime;
        this.interceptors = interceptors;
        this.replyHandler = replyHandler;
        if (replyEndTime != null) {
            this.timer = new Timer(replyEndTime);
            this.timer.setName("ReplyReceiver Timer");
            this.timer.start();
        } else {
            this.timer = null;
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
        this.logger = ((org.jacorb.config.Configuration)configuration).getNamedLogger("jacorb.orb.rep_recv");
        this.retry_on_failure = configuration.getAttribute("jacorb.connection.client.retry_on_failure", "off").equals("on");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyReceived(MessageInputStream in) {
        Set pending_replies;
        if (this.timeoutException) {
            return;
        }
        if (this.timer != null) {
            this.timer.wakeup();
        }
        Set set = pending_replies = this.delegate.get_pending_replies();
        synchronized (set) {
            ReplyReceiver replyReceiver = this;
            synchronized (replyReceiver) {
                if (this.timeoutException) {
                    return;
                }
                this.in = in;
                this.delegate.replyDone(this);
                if (this.replyHandler != null) {
                    this.performCallback((ReplyInputStream)in);
                } else {
                    this.ready = true;
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void performCallback(ReplyInputStream reply) {
        org.omg.CORBA.portable.Delegate replyHandlerDelegate = ((ObjectImpl)((java.lang.Object)this.replyHandler))._get_delegate();
        ServantObject so = replyHandlerDelegate.servant_preinvoke(this.replyHandler, this.operation, class$org$omg$CORBA$portable$InvokeHandler == null ? (class$org$omg$CORBA$portable$InvokeHandler = ReplyReceiver.class$("org.omg.CORBA.portable.InvokeHandler")) : class$org$omg$CORBA$portable$InvokeHandler);
        try {
            switch (reply.getStatus().value()) {
                case 0: {
                    ((InvokeHandler)so.servant)._invoke(this.operation, reply, new DummyResponseHandler());
                    return;
                }
                case 1: 
                case 2: {
                    ExceptionHolderImpl holder = new ExceptionHolderImpl(reply);
                    org.omg.CORBA_2_3.ORB orb = (org.omg.CORBA_2_3.ORB)replyHandlerDelegate.orb(null);
                    orb.register_value_factory("IDL:omg.org/Messaging/ExceptionHolder:1.0", new ExceptionHolderFactory());
                    CDRInputStream input = new CDRInputStream(orb, holder.marshal());
                    ((InvokeHandler)so.servant)._invoke(this.operation + "_excep", input, new DummyResponseHandler());
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            if (!this.logger.isWarnEnabled()) return;
            this.logger.warn("Exception during callback: " + e.getMessage());
            return;
        }
        finally {
            replyHandlerDelegate.servant_postinvoke(this.replyHandler, so);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performExceptionCallback(ExceptionHolderImpl holder) {
        org.omg.CORBA.portable.Delegate replyHandlerDelegate = ((ObjectImpl)((java.lang.Object)this.replyHandler))._get_delegate();
        ServantObject so = replyHandlerDelegate.servant_preinvoke(this.replyHandler, this.operation, class$org$omg$CORBA$portable$InvokeHandler == null ? (class$org$omg$CORBA$portable$InvokeHandler = ReplyReceiver.class$("org.omg.CORBA.portable.InvokeHandler")) : class$org$omg$CORBA$portable$InvokeHandler);
        try {
            org.omg.CORBA_2_3.ORB orb = (org.omg.CORBA_2_3.ORB)replyHandlerDelegate.orb(null);
            orb.register_value_factory("IDL:omg.org/Messaging/ExceptionHolder:1.0", new ExceptionHolderFactory());
            CDRInputStream input = new CDRInputStream(orb, holder.marshal());
            ((InvokeHandler)so.servant)._invoke(this.operation + "_excep", input, new DummyResponseHandler());
        }
        catch (Exception e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception during callback: " + e.getMessage());
            }
        }
        finally {
            replyHandlerDelegate.servant_postinvoke(this.replyHandler, so);
        }
    }

    public synchronized ReplyInputStream getReply() throws RemarshalException, ApplicationException {
        try {
            try {
                this.getInputStream();
            }
            catch (COMM_FAILURE ex) {
                if (this.retry_on_failure) {
                    throw new RemarshalException();
                }
                throw ex;
            }
        }
        catch (SystemException se) {
            this.interceptors.handle_receive_exception(se);
            throw se;
        }
        catch (RemarshalException re) {
            this.delegate.waitOnBarrier();
            throw new RemarshalException();
        }
        ReplyInputStream reply = (ReplyInputStream)this.in;
        ReplyStatusType_1_2 status = this.delegate.doNotCheckExceptions() ? ReplyStatusType_1_2.NO_EXCEPTION : reply.getStatus();
        switch (status.value()) {
            case 0: {
                this.interceptors.handle_receive_reply(reply);
                return reply;
            }
            case 1: {
                ApplicationException ae = this.getApplicationException(reply);
                this.interceptors.handle_receive_exception(ae, reply);
                throw ae;
            }
            case 2: {
                SystemException se = SystemExceptionHelper.read(reply);
                this.interceptors.handle_receive_exception(se, reply);
                throw se;
            }
            case 3: 
            case 4: {
                Object forward_reference = reply.read_Object();
                this.interceptors.handle_location_forward(reply, forward_reference);
                this.doRebind(forward_reference);
                throw new RemarshalException();
            }
            case 5: {
                throw new NO_IMPLEMENT("WARNING: Got reply status NEEDS_ADDRESSING_MODE (not implemented).");
            }
        }
        throw new MARSHAL("Received unexpected reply status: " + status.value());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRebind(Object forward_reference) {
        try {
            Set pending_replies;
            this.delegate.lockBarrier();
            Set set = pending_replies = this.delegate.get_pending_replies();
            synchronized (set) {
                Iterator i = pending_replies.iterator();
                while (i.hasNext()) {
                    ReplyPlaceholder p = (ReplyPlaceholder)i.next();
                    p.retry();
                }
            }
            this.delegate.rebind(forward_reference);
        }
        finally {
            this.delegate.openBarrier();
        }
    }

    private ApplicationException getApplicationException(ReplyInputStream reply) {
        String id;
        block2: {
            reply.mark(0);
            id = reply.read_string();
            try {
                reply.reset();
            }
            catch (IOException ioe) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error("Exception int reset(): " + ioe.getMessage());
            }
        }
        return new ApplicationException(id, reply);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Timer
    extends Thread {
        private boolean awakened = false;
        private UtcT endTime;

        public Timer(UtcT endTime) {
            this.endTime = endTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Timer timer = this;
            synchronized (timer) {
                ReplyReceiver.this.timeoutException = false;
                if (!this.awakened) {
                    block12: {
                        long time = Time.millisTo(this.endTime);
                        if (time > 0L) {
                            try {
                                this.wait(time);
                            }
                            catch (InterruptedException ex) {
                                if (!ReplyReceiver.this.logger.isInfoEnabled()) break block12;
                                ReplyReceiver.this.logger.info("Interrupted while waiting for timeout");
                            }
                        }
                    }
                    if (!this.awakened) {
                        ReplyReceiver replyReceiver = ReplyReceiver.this;
                        synchronized (replyReceiver) {
                            ReplyReceiver.this.timeoutException = true;
                            if (ReplyReceiver.this.replyHandler != null) {
                                ExceptionHolderImpl exHolder = new ExceptionHolderImpl(new TIMEOUT());
                                ReplyReceiver.this.performExceptionCallback(exHolder);
                            }
                            ReplyReceiver.this.ready = true;
                            ReplyReceiver.this.notifyAll();
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void wakeup() {
            Timer timer = this;
            synchronized (timer) {
                this.awakened = true;
                ReplyReceiver.this.timeoutException = false;
                this.notifyAll();
            }
        }
    }

    private static class ExceptionHolderFactory
    implements ValueFactory {
        private ExceptionHolderFactory() {
        }

        public Serializable read_value(InputStream is) {
            ExceptionHolderImpl result = new ExceptionHolderImpl();
            result._read(is);
            return result;
        }
    }

    private class DummyResponseHandler
    implements ResponseHandler {
        private DummyResponseHandler() {
        }

        public OutputStream createReply() {
            Time.waitFor(ReplyReceiver.this.delegate.getReplyStartTime());
            return null;
        }

        public OutputStream createExceptionReply() {
            return null;
        }
    }
}

