/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.notification.NoTranslationException;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.PushOperation;
import org.jacorb.notification.engine.PushTaskExecutorFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.servant.AbstractProxyPushSupplier;
import org.jacorb.notification.servant.ITypedAdmin;
import org.jacorb.notification.servant.ITypedProxy;
import org.jacorb.notification.servant.TypedProxyPushSupplierImplMBean;
import org.omg.CORBA.Any;
import org.omg.CORBA.NVList;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Request;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.EventTypeHelper;
import org.omg.CosNotification.Property;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosTypedEventComm.TypedPushConsumer;
import org.omg.CosTypedNotifyChannelAdmin.TypedProxyPushSupplierHelper;
import org.omg.CosTypedNotifyChannelAdmin.TypedProxyPushSupplierOperations;
import org.omg.CosTypedNotifyChannelAdmin.TypedProxyPushSupplierPOATie;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class TypedProxyPushSupplierImpl
extends AbstractProxyPushSupplier
implements TypedProxyPushSupplierOperations,
ITypedProxy,
TypedProxyPushSupplierImplMBean {
    private TypedPushConsumer pushConsumer_;
    private Object typedConsumer_;
    private static final TypeCode TYPE_CODE_VOID = ORB.init().get_primitive_tc(TCKind.tk_void);
    private final String supportedInterface_;
    private long timeSpent_ = 0L;

    public TypedProxyPushSupplierImpl(ITypedAdmin admin, ConsumerAdmin consumerAdmin, ORB orb, POA poa, Configuration conf, TaskProcessor taskProcessor, PushTaskExecutorFactory pushTaskExecutorFactory, OfferManager offerManager, SubscriptionManager subscriptionManager) throws ConfigurationException {
        super(admin, orb, poa, conf, taskProcessor, pushTaskExecutorFactory, offerManager, subscriptionManager, consumerAdmin);
        this.supportedInterface_ = admin.getSupportedInterface();
    }

    public void disconnect_push_supplier() {
        this.destroy();
    }

    public void connect_typed_push_consumer(TypedPushConsumer typedPushConsumer) throws AlreadyConnected, TypeError {
        this.logger_.info("connect typed_push_supplier");
        this.checkIsNotConnected();
        this.connectClient(typedPushConsumer);
        this.pushConsumer_ = typedPushConsumer;
        this.typedConsumer_ = this.pushConsumer_.get_typed_consumer();
        if (!this.typedConsumer_._is_a(this.supportedInterface_)) {
            throw new TypeError();
        }
    }

    public ProxyType MyType() {
        return ProxyType.PUSH_TYPED;
    }

    public Object activate() {
        return TypedProxyPushSupplierHelper.narrow(this.getServant()._this_object(this.getORB()));
    }

    public void isIDLAssignable(String ifName) throws IllegalArgumentException {
        if (this.typedConsumer_._is_a(ifName)) {
            return;
        }
        if (ifName.indexOf("Pull") > 0) {
            int idx = ifName.indexOf("Pull");
            StringBuffer _nonPullIF = new StringBuffer();
            _nonPullIF.append(ifName.substring(0, idx));
            _nonPullIF.append(ifName.substring(idx + 4));
            if (this.typedConsumer_._is_a(_nonPullIF.toString())) {
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushPendingData() {
        Message[] messages = this.getAllMessages();
        for (int i = 0; i < messages.length; ++i) {
            try {
                this.deliverMessageWithRetry(messages[i]);
                continue;
            }
            finally {
                messages[i].dispose();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void deliverMessageWithRetry(Message message) {
        try {
            void var3_4;
            String _fullQualifiedOperation;
            Property[] _props = message.toTypedEvent();
            if ("operation".equals(_props[0].name)) {
                _fullQualifiedOperation = _props[0].value.extract_string();
            } else if ("event_type".equals(_props[0].name)) {
                _fullQualifiedOperation = EventTypeHelper.extract((Any)_props[0].value).type_name;
                String _idlType = EventTypeHelper.extract((Any)_props[0].value).domain_name;
                this.isIDLAssignable(_idlType);
            } else {
                throw new IllegalArgumentException();
            }
            int _idx = var3_4.lastIndexOf("::");
            String _operation = var3_4.substring(_idx + 2);
            Request _request = this.typedConsumer_._request(_operation);
            NVList _arguments = _request.arguments();
            for (int x = 1; x < _props.length; ++x) {
                _arguments.add_value(_props[x].name, _props[x].value, 1);
            }
            _request.set_return_type(TYPE_CODE_VOID);
            try {
                this.deliverMessageInternal(_request);
            }
            catch (Exception t) {
                PushTypedOperation _failedOperation = new PushTypedOperation(_request);
                this.handleFailedPushOperation(_failedOperation, t);
            }
        }
        catch (NoTranslationException e) {
            this.logger_.info("No Translation possible", (Throwable)e);
        }
    }

    void deliverMessageInternal(Request request) {
        long now = System.currentTimeMillis();
        request.invoke();
        this.timeSpent_ += System.currentTimeMillis() - now;
        this.resetErrorCounter();
    }

    protected void disconnectClient() {
        if (this.pushConsumer_ != null) {
            this.pushConsumer_.disconnect_push_consumer();
            this.pushConsumer_ = null;
        }
    }

    public synchronized Servant getServant() {
        if (this.thisServant_ == null) {
            this.thisServant_ = new TypedProxyPushSupplierPOATie(this);
        }
        return this.thisServant_;
    }

    protected long getCost() {
        return this.timeSpent_;
    }

    public String getSupportedInterface() {
        return this.supportedInterface_;
    }

    private class PushTypedOperation
    implements PushOperation {
        private final Request request_;

        public PushTypedOperation(Request request) {
            this.request_ = request;
        }

        public void invokePush() throws Disconnected {
            TypedProxyPushSupplierImpl.this.deliverMessageInternal(this.request_);
        }

        public void dispose() {
        }
    }
}

