/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.MessagePushOperation;
import org.jacorb.notification.engine.PushTaskExecutorFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.servant.AbstractProxyPushSupplier;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.notification.servant.StructuredProxyPushSupplierImplMBean;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.ProxySupplierHelper;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplierOperations;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplierPOATie;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyComm.StructuredPushConsumer;
import org.omg.CosNotifyComm.StructuredPushConsumerOperations;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class StructuredProxyPushSupplierImpl
extends AbstractProxyPushSupplier
implements StructuredProxyPushSupplierOperations,
StructuredProxyPushSupplierImplMBean {
    private static final StructuredPushConsumerOperations NULL_CONSUMER = new StructuredPushConsumerOperations(){

        public void push_structured_event(StructuredEvent event) {
        }

        public void disconnect_structured_push_consumer() {
        }

        public void offer_change(EventType[] added, EventType[] removed) throws InvalidEventType {
        }
    };
    private StructuredPushConsumerOperations pushConsumer_;
    private long timeSpent_;

    public StructuredProxyPushSupplierImpl(IAdmin admin, ORB orb, POA poa, Configuration conf, TaskProcessor taskProcessor, PushTaskExecutorFactory pushTaskExecutorFactory, OfferManager offerManager, SubscriptionManager subscriptionManager, ConsumerAdmin consumerAdmin) throws ConfigurationException {
        super(admin, orb, poa, conf, taskProcessor, pushTaskExecutorFactory, offerManager, subscriptionManager, consumerAdmin);
    }

    public ProxyType MyType() {
        return ProxyType.PUSH_STRUCTURED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushPendingData() {
        Message[] _mesgs = this.getAllMessages();
        if (_mesgs != null) {
            for (int x = 0; x < _mesgs.length; ++x) {
                try {
                    this.deliverMessageWithRetry(_mesgs[x]);
                    continue;
                }
                finally {
                    _mesgs[x].dispose();
                }
            }
        }
    }

    private void deliverMessageWithRetry(Message message) {
        try {
            this.deliverMessageInternal(message);
        }
        catch (Exception e) {
            PushStructuredOperation _failedOperation = new PushStructuredOperation(message);
            this.handleFailedPushOperation(_failedOperation, e);
        }
    }

    void deliverMessageInternal(Message message) throws Disconnected {
        long now = System.currentTimeMillis();
        this.pushConsumer_.push_structured_event(message.toStructuredEvent());
        long _duration = System.currentTimeMillis() - now;
        this.timeSpent_ += _duration;
        this.resetErrorCounter();
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Push took " + _duration + " ms");
        }
    }

    public void connect_structured_push_consumer(StructuredPushConsumer consumer) throws AlreadyConnected {
        this.checkIsNotConnected();
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("connect structured_push_consumer");
        }
        this.pushConsumer_ = consumer;
        this.connectClient(consumer);
    }

    public void disconnect_structured_push_supplier() {
        this.destroy();
    }

    protected void connectionResumed() {
        this.schedulePush();
    }

    protected void disconnectClient() {
        this.pushConsumer_.disconnect_structured_push_consumer();
        this.pushConsumer_ = NULL_CONSUMER;
    }

    public synchronized Servant getServant() {
        if (this.thisServant_ == null) {
            this.thisServant_ = new StructuredProxyPushSupplierPOATie(this);
        }
        return this.thisServant_;
    }

    public Object activate() {
        return ProxySupplierHelper.narrow(this.getServant()._this_object(this.getORB()));
    }

    protected long getCost() {
        return this.timeSpent_;
    }

    private class PushStructuredOperation
    extends MessagePushOperation {
        public PushStructuredOperation(Message message) {
            super(message);
        }

        public void invokePush() throws Disconnected {
            StructuredProxyPushSupplierImpl.this.deliverMessageInternal(this.message_);
        }
    }
}

