/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.conf.Default;
import org.jacorb.notification.engine.AbstractRetryStrategy;
import org.jacorb.notification.engine.PushOperation;
import org.jacorb.notification.engine.PushTaskExecutor;
import org.jacorb.notification.engine.PushTaskExecutorFactory;
import org.jacorb.notification.engine.RetryException;
import org.jacorb.notification.engine.RetryStrategy;
import org.jacorb.notification.engine.RetryStrategyFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.IProxyPushSupplier;
import org.jacorb.notification.servant.AbstractProxySupplier;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.ORB;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.PortableServer.POA;
import org.picocontainer.defaults.DefaultPicoContainer;

public abstract class AbstractProxyPushSupplier
extends AbstractProxySupplier
implements IProxyPushSupplier {
    private static final String NOTIFY_PUSH_FAILED = "notification.proxy.push_failed";
    private final AtomicReference retryStrategyFactory_;
    private final AtomicBoolean enabled_ = new AtomicBoolean(true);
    private final PushTaskExecutor pushTaskExecutor_;
    private final AtomicInteger pushCounter_ = new AtomicInteger(0);
    private final AtomicInteger pushErrors_ = new AtomicInteger(0);
    private final PushTaskExecutor.PushTask pushTask_ = new PushTaskExecutor.PushTask(){

        public void doPush() {
            AbstractProxyPushSupplier.this.pushPendingData();
        }

        public void cancel() {
        }
    };
    static /* synthetic */ Class class$org$jacorb$notification$engine$TaskProcessor;
    static /* synthetic */ Class class$org$jacorb$notification$engine$RetryStrategyFactory;

    public AbstractProxyPushSupplier(IAdmin admin, ORB orb, POA poa, Configuration conf, TaskProcessor taskProcessor, PushTaskExecutorFactory pushTaskExecutorFactory, OfferManager offerManager, SubscriptionManager subscriptionManager, ConsumerAdmin consumerAdmin) throws ConfigurationException {
        super(admin, orb, poa, conf, taskProcessor, offerManager, subscriptionManager, consumerAdmin);
        this.pushTaskExecutor_ = pushTaskExecutorFactory.newExecutor(this);
        this.retryStrategyFactory_ = new AtomicReference((Object)this.newRetryStrategyFactory(conf, taskProcessor));
        this.eventTypes_.add(NOTIFY_PUSH_FAILED);
    }

    protected void handleFailedPushOperation(PushOperation operation, Exception error) {
        if (this.isDestroyed()) {
            operation.dispose();
            return;
        }
        this.sendNotification(NOTIFY_PUSH_FAILED, "Push Operation failed");
        this.pushErrors_.getAndIncrement();
        this.incErrorCounter();
        if (AbstractRetryStrategy.isFatalException(error)) {
            if (this.logger_.isErrorEnabled()) {
                this.logger_.error("push raised " + error + ": will destroy ProxySupplier, " + "disconnect Consumer", (Throwable)error);
            }
            operation.dispose();
            this.destroy();
        } else if (!this.isRetryAllowed()) {
            operation.dispose();
            this.destroy();
        } else if (!this.isDestroyed()) {
            RetryStrategy _retry = this.newRetryStrategy(this, operation);
            try {
                _retry.retry();
            }
            catch (RetryException e) {
                this.logger_.error("retry failed", (Throwable)e);
                _retry.dispose();
                this.destroy();
            }
        } else {
            throw new IllegalStateException("should not happen");
        }
    }

    private RetryStrategy newRetryStrategy(IProxyPushSupplier pushSupplier, PushOperation pushOperation) {
        return ((RetryStrategyFactory)this.retryStrategyFactory_.get()).newRetryStrategy(pushSupplier, pushOperation);
    }

    private RetryStrategyFactory newRetryStrategyFactory(Configuration config, TaskProcessor taskProcessor) throws ConfigurationException {
        String factoryName = config.getAttribute("jacorb.notification.proxysupplier.retrystrategy_factory", Default.DEFAULT_RETRY_STRATEGY_FACTORY);
        try {
            return this.newRetryStrategyFactory(config, taskProcessor, factoryName);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("jacorb.notification.proxysupplier.retrystrategy_factory", (Throwable)e);
        }
    }

    public void setRetryStrategy(String factoryName) throws ClassNotFoundException {
        RetryStrategyFactory factory = this.newRetryStrategyFactory(this.config_, this.getTaskProcessor(), factoryName);
        this.retryStrategyFactory_.set((Object)factory);
        this.logger_.info("set RetryStrategyFactory: " + factoryName);
    }

    public String getRetryStrategy() {
        return this.retryStrategyFactory_.get().getClass().getName();
    }

    private RetryStrategyFactory newRetryStrategyFactory(Configuration config, TaskProcessor taskProcessor, String factoryName) throws ClassNotFoundException {
        Class factoryClazz = ObjectUtil.classForName(factoryName);
        DefaultPicoContainer pico = new DefaultPicoContainer();
        pico.registerComponentInstance((Object)(class$org$jacorb$notification$engine$TaskProcessor == null ? (class$org$jacorb$notification$engine$TaskProcessor = AbstractProxyPushSupplier.class$("org.jacorb.notification.engine.TaskProcessor")) : class$org$jacorb$notification$engine$TaskProcessor), (Object)taskProcessor);
        pico.registerComponentImplementation((Object)(class$org$jacorb$notification$engine$RetryStrategyFactory == null ? (class$org$jacorb$notification$engine$RetryStrategyFactory = AbstractProxyPushSupplier.class$("org.jacorb.notification.engine.RetryStrategyFactory")) : class$org$jacorb$notification$engine$RetryStrategyFactory), factoryClazz);
        pico.registerComponentInstance((Object)config);
        return (RetryStrategyFactory)pico.getComponentInstance((Object)(class$org$jacorb$notification$engine$RetryStrategyFactory == null ? (class$org$jacorb$notification$engine$RetryStrategyFactory = AbstractProxyPushSupplier.class$("org.jacorb.notification.engine.RetryStrategyFactory")) : class$org$jacorb$notification$engine$RetryStrategyFactory));
    }

    public final void schedulePush() {
        if (!this.isDestroyed() && !this.isSuspended() && this.isEnabled()) {
            this.schedulePush(this.pushTask_);
        }
    }

    public final void schedulePush(PushTaskExecutor.PushTask pushTask) {
        this.pushTaskExecutor_.executePush(pushTask);
    }

    public final void messageQueued() {
        if (this.isEnabled()) {
            this.schedulePush();
        }
    }

    public void resetErrorCounter() {
        super.resetErrorCounter();
        this.pushCounter_.getAndIncrement();
        this.enableDelivery();
    }

    public void disableDelivery() {
        boolean _wasEnabled = this.enabled_.getAndSet(false);
        if (_wasEnabled) {
            this.logger_.debug("Disabled Delivery to ProxySupplier");
        }
    }

    protected boolean isEnabled() {
        return this.enabled_.get();
    }

    private void enableDelivery() {
        boolean _wasEnabled = this.enabled_.getAndSet(true);
        if (!_wasEnabled) {
            this.logger_.debug("Reenable Delivery to ProxySupplier");
        }
    }

    public int getPushOperationCount() {
        return this.pushCounter_.get();
    }

    public int getPushErrorCount() {
        return this.pushErrors_.get();
    }

    public int getAveragePushDuration() {
        return (int)this.getCost() / this.getPushOperationCount();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

