/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.FilterManager;
import org.jacorb.notification.IContainer;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.JMXManageable;
import org.jacorb.notification.servant.AbstractProxyMBean;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.notification.util.DisposableManager;
import org.jacorb.notification.util.QoSPropertySet;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.QoSAdminOperations;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.ConnectionAlreadyActive;
import org.omg.CosNotifyChannelAdmin.ConnectionAlreadyInactive;
import org.omg.CosNotifyChannelAdmin.NotConnected;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterAdminOperations;
import org.omg.CosNotifyFilter.FilterNotFound;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.CosNotifyFilter.MappingFilterHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.picocontainer.PicoContainer;

public abstract class AbstractProxy
implements FilterAdminOperations,
QoSAdminOperations,
FilterStage,
ManageableServant,
Configurable,
JMXManageable,
AbstractProxyMBean {
    private final MappingFilter nullMappingFilterRef_;
    private final boolean isIDPublic_;
    protected final Logger logger_;
    private final AtomicBoolean connected_ = new AtomicBoolean(false);
    protected final QoSPropertySet qosSettings_;
    private final Integer id_;
    protected final OfferManager offerManager_;
    protected final SubscriptionManager subscriptionManager_;
    protected Servant thisServant_;
    private MappingFilter lifetimeFilter_;
    private MappingFilter priorityFilter_;
    private final FilterManager filterManager_;
    private final AtomicBoolean destroyed_ = new AtomicBoolean(false);
    private final AtomicBoolean disposeInProgress_ = new AtomicBoolean(false);
    private final AtomicInteger errorCounter_ = new AtomicInteger(0);
    private final POA poa_;
    private final ORB orb_;
    private final TaskProcessor taskProcessor_;
    private boolean isInterFilterGroupOperatorOR_;
    private final boolean disposedProxyDisconnectsClient_;
    private final AtomicBoolean active_ = new AtomicBoolean(true);
    private final DisposableManager disposables_ = new DisposableManager();
    private final PicoContainer container_;
    private Object client_;
    private final String parentMBean_;
    protected final Set eventTypes_ = new HashSet();
    private JMXManageable.JMXCallback jmxCallback_;
    protected Configuration config_;
    static /* synthetic */ Class class$org$jacorb$notification$IContainer;

    protected AbstractProxy(IAdmin admin, ORB orb, POA poa, Configuration conf, TaskProcessor taskProcessor, OfferManager offerManager, SubscriptionManager subscriptionManager) {
        this.parentMBean_ = admin.getAdminMBean();
        this.id_ = new Integer(admin.getProxyID());
        this.isIDPublic_ = admin.isIDPublic();
        this.container_ = admin.getContainer();
        this.orb_ = orb;
        this.poa_ = poa;
        this.taskProcessor_ = taskProcessor;
        this.offerManager_ = offerManager;
        this.subscriptionManager_ = subscriptionManager;
        this.filterManager_ = new FilterManager();
        this.nullMappingFilterRef_ = MappingFilterHelper.narrow(orb.string_to_object(orb.object_to_string(null)));
        this.logger_ = ((org.jacorb.config.Configuration)conf).getNamedLogger(this.getClass().getName());
        this.disposedProxyDisconnectsClient_ = conf.getAttribute("jacorb.notification.proxy.destroy_causes_disconnect", "on").equals("on");
        this.qosSettings_ = new QoSPropertySet(conf, 2);
        this.configure(conf);
    }

    public void configure(Configuration conf) {
        this.config_ = conf;
    }

    public void registerDisposable(Disposable d) {
        this.disposables_.addDisposable(d);
    }

    public boolean isIDPublic() {
        return this.isIDPublic_;
    }

    protected POA getPOA() {
        return this.poa_;
    }

    protected ORB getORB() {
        return this.orb_;
    }

    protected TaskProcessor getTaskProcessor() {
        return this.taskProcessor_;
    }

    public final int add_filter(Filter filter) {
        return this.filterManager_.add_filter(filter);
    }

    public final void remove_filter(int n) throws FilterNotFound {
        this.filterManager_.remove_filter(n);
    }

    public final Filter get_filter(int n) throws FilterNotFound {
        return this.filterManager_.get_filter(n);
    }

    public final int[] get_all_filters() {
        return this.filterManager_.get_all_filters();
    }

    public final void remove_all_filters() {
        this.filterManager_.remove_all_filters();
    }

    public void validate_event_qos(Property[] qosProps, NamedPropertyRangeSeqHolder propSeqHolder) {
        throw new NO_IMPLEMENT();
    }

    public final void validate_qos(Property[] props, NamedPropertyRangeSeqHolder propertyRange) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(props, propertyRange);
    }

    public final void set_qos(Property[] qosProps) throws UnsupportedQoS {
        this.qosSettings_.set_qos(qosProps);
    }

    public final Property[] get_qos() {
        return this.qosSettings_.get_qos();
    }

    public final void priority_filter(MappingFilter filter) {
        this.priorityFilter_ = filter;
    }

    public final MappingFilter priority_filter() {
        if (this.priorityFilter_ == null) {
            return this.nullMappingFilterRef_;
        }
        return this.priorityFilter_;
    }

    public final MappingFilter lifetime_filter() {
        if (this.lifetimeFilter_ == null) {
            return this.nullMappingFilterRef_;
        }
        return this.lifetimeFilter_;
    }

    public final void lifetime_filter(MappingFilter filter) {
        this.lifetimeFilter_ = filter;
    }

    public final Integer getID() {
        return this.id_;
    }

    public final POA _default_POA() {
        return this.getPOA();
    }

    public final List getFilters() {
        return this.filterManager_.getFilters();
    }

    public final void deactivate() {
        this.logger_.info("deactivate Proxy");
        try {
            byte[] _oid = this.getPOA().servant_to_id(this.getServant());
            this.getPOA().deactivate_object(_oid);
        }
        catch (Exception e) {
            this.logger_.error("Couldn't deactivate Proxy", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryDisconnectClient() {
        try {
            if (this.disposedProxyDisconnectsClient_ && this.connected_.get()) {
                this.logger_.info("disconnect_client");
                this.disconnectClient();
            }
        }
        catch (Exception e) {
            this.logger_.error("disconnect_client raised an unexpected error: ignore", (Throwable)e);
        }
        finally {
            this.connected_.set(false);
        }
    }

    public final boolean isDestroyed() {
        return this.destroyed_.get();
    }

    protected void checkDestroyStatus() throws OBJECT_NOT_EXIST {
        if (!this.destroyed_.compareAndSet(false, true)) {
            this.logger_.error("Already destroyed");
            throw new OBJECT_NOT_EXIST();
        }
    }

    public final void destroy() {
        this.checkDestroyStatus();
        this.container_.dispose();
        List list = this.container_.getComponentInstancesOfType(class$org$jacorb$notification$IContainer == null ? (class$org$jacorb$notification$IContainer = AbstractProxy.class$("org.jacorb.notification.IContainer")) : class$org$jacorb$notification$IContainer);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            IContainer element = (IContainer)i.next();
            element.destroy();
        }
    }

    public void dispose() {
        this.logger_.info("Destroy Proxy " + this.id_);
        this.disposeInProgress_.set(true);
        this.tryDisconnectClient();
        this.deactivate();
        this.removeListener();
        this.remove_all_filters();
        this.disposables_.dispose();
    }

    public abstract ProxyType MyType();

    void setInterFilterGroupOperatorOR(boolean b) {
        this.isInterFilterGroupOperatorOR_ = b;
    }

    public final boolean hasInterFilterGroupOperatorOR() {
        return this.isInterFilterGroupOperatorOR_;
    }

    public final boolean getConnected() {
        return !this.disposeInProgress_.get() && this.connected_.get();
    }

    public final boolean hasLifetimeFilter() {
        return this.lifetimeFilter_ != null;
    }

    public final boolean hasPriorityFilter() {
        return this.priorityFilter_ != null;
    }

    public final MappingFilter getLifetimeFilter() {
        return this.lifetimeFilter_;
    }

    public final MappingFilter getPriorityFilter() {
        return this.priorityFilter_;
    }

    public void resetErrorCounter() {
        this.errorCounter_.set(0);
    }

    public final int getErrorCounter() {
        return this.errorCounter_.get();
    }

    public final int incErrorCounter() {
        return this.errorCounter_.getAndIncrement();
    }

    public boolean isSuspended() {
        return !this.active_.get();
    }

    public final void suspend_connection() throws NotConnected, ConnectionAlreadyInactive {
        this.checkIsConnected();
        if (!this.active_.compareAndSet(true, false)) {
            throw new ConnectionAlreadyInactive();
        }
        this.connectionSuspended();
    }

    protected void connectionSuspended() {
    }

    public final void resume_connection() throws NotConnected, ConnectionAlreadyActive {
        this.checkIsConnected();
        if (!this.active_.compareAndSet(false, true)) {
            throw new ConnectionAlreadyActive();
        }
        this.connectionResumed();
    }

    protected void connectionResumed() {
    }

    protected void checkIsConnected() throws NotConnected {
        if (!this.connected_.get()) {
            throw new NotConnected();
        }
    }

    protected void checkIsNotConnected() throws AlreadyConnected {
        if (this.connected_.get()) {
            throw new AlreadyConnected();
        }
    }

    protected void checkStillConnected() throws Disconnected {
        if (!this.connected_.get()) {
            this.logger_.fatalError("access on a not connected proxy");
            this.destroy();
            throw new Disconnected();
        }
    }

    protected void connectClient(Object client) {
        this.connected_.set(true);
        this.client_ = client;
    }

    protected abstract void disconnectClient();

    protected abstract Servant getServant();

    protected void handleDisconnected(Disconnected e) {
        this.logger_.fatalError("Illegal state: Client think it's disconnected. Proxy thinks Client is still connected. The Proxy will be destroyed.", (Throwable)e);
        this.destroy();
    }

    protected abstract void removeListener();

    public final String getJMXObjectName() {
        return "proxy=" + this.getMBeanName() + ", " + this.parentMBean_;
    }

    public final String getMBeanName() {
        return this.getMBeanType() + "-" + this.getID();
    }

    protected String getMBeanType() {
        String clazzName = this.getClass().getName();
        String rawClazz = clazzName.substring(clazzName.lastIndexOf(46) + 1);
        return rawClazz.substring(0, rawClazz.length() - "Impl".length());
    }

    public String[] getJMXNotificationTypes() {
        return this.eventTypes_.toArray(new String[this.eventTypes_.size()]);
    }

    public void setJMXCallback(JMXManageable.JMXCallback callback) {
        this.jmxCallback_ = callback;
    }

    protected void sendNotification(String type, String message) {
        if (this.jmxCallback_ != null) {
            this.jmxCallback_.sendJMXNotification(type, message);
        }
    }

    public String getStatus() {
        String _status = this.destroyed_.get() ? "DESTROYED" : (!this.connected_.get() ? "NOT CONNECTED" : (this.active_.get() ? "ACTIVE" : "SUSPENDED"));
        return _status;
    }

    public String getClientIOR() {
        return this.client_ != null ? this.orb_.object_to_string(this.client_) : "";
    }

    public String getInterFilterGroupOperator() {
        return this.isInterFilterGroupOperatorOR_ ? "OR_OP" : "AND_OP";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

