/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.FilterManager;
import org.jacorb.notification.IContainer;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.container.PicoContainerFactory;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.JMXManageable;
import org.jacorb.notification.interfaces.ProxyEvent;
import org.jacorb.notification.interfaces.ProxyEventListener;
import org.jacorb.notification.servant.AbstractProxy;
import org.jacorb.notification.servant.IAdmin;
import org.jacorb.notification.servant.IEventChannel;
import org.jacorb.notification.servant.ITypedAdmin;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.notification.util.DisposableManager;
import org.jacorb.notification.util.QoSPropertySet;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.QoSAdminOperations;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.InterFilterGroupOperator;
import org.omg.CosNotifyChannelAdmin.ProxyNotFound;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterAdminOperations;
import org.omg.CosNotifyFilter.FilterNotFound;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public abstract class AbstractAdmin
implements QoSAdminOperations,
FilterAdminOperations,
FilterStage,
ManageableServant,
JMXManageable {
    protected static final InterFilterGroupOperator DEFAULT_FILTER_GROUP_OPERATOR = InterFilterGroupOperator.AND_OP;
    private final DisposableManager disposables_ = new DisposableManager();
    private final Integer id_;
    private InterFilterGroupOperator filterGroupOperator_;
    protected final MutablePicoContainer container_;
    private final FilterManager filterManager_;
    private final WeakReference eventChannelReference_;
    private final QoSPropertySet qosSettings_;
    private final MessageFactory messageFactory_;
    protected final OfferManager offerManager_;
    protected final SubscriptionManager subscriptionManager_;
    protected final Logger logger_;
    private final ORB orb_;
    private final POA poa_;
    protected final Object modifyProxiesLock_ = new Object();
    protected final Map pullServants_ = new HashMap();
    protected final Map pushServants_ = new HashMap();
    private final AtomicInteger proxyIdPool_ = new AtomicInteger(0);
    private final AtomicBoolean disposed_ = new AtomicBoolean(false);
    private final List proxyEventListener_ = new ArrayList();
    private final int channelID_;
    private final String parentMBean_;
    private JMXManageable.JMXCallback jmxCallback_;
    static /* synthetic */ Class class$org$jacorb$notification$servant$ITypedAdmin;
    static /* synthetic */ Class class$org$jacorb$notification$IContainer;
    static /* synthetic */ Class class$org$jacorb$notification$servant$IAdmin;

    protected AbstractAdmin(IEventChannel channel, ORB orb, POA poa, Configuration config, MessageFactory messageFactory, OfferManager offerManager, SubscriptionManager subscriptionManager) {
        this.parentMBean_ = channel.getChannelMBean();
        this.container_ = channel.getContainer();
        this.id_ = new Integer(channel.getAdminID());
        this.orb_ = orb;
        this.poa_ = poa;
        this.messageFactory_ = messageFactory;
        this.filterManager_ = new FilterManager();
        this.eventChannelReference_ = new WeakReference<EventChannel>(channel.getEventChannel());
        this.channelID_ = channel.getChannelID();
        this.logger_ = ((org.jacorb.config.Configuration)config).getNamedLogger(this.getClass().getName());
        this.qosSettings_ = new QoSPropertySet(config, 1);
        this.offerManager_ = offerManager;
        this.subscriptionManager_ = subscriptionManager;
    }

    public final void registerDisposable(Disposable disposable) {
        this.disposables_.addDisposable(disposable);
    }

    public void setInterFilterGroupOperator(InterFilterGroupOperator operator) {
        this.filterGroupOperator_ = operator;
    }

    protected POA getPOA() {
        return this.poa_;
    }

    protected ORB getORB() {
        return this.orb_;
    }

    protected MessageFactory getMessageFactory() {
        return this.messageFactory_;
    }

    public POA _default_POA() {
        return this.getPOA();
    }

    int getProxyID() {
        return this.proxyIdPool_.getAndIncrement();
    }

    public List getFilters() {
        return this.filterManager_.getFilters();
    }

    public int add_filter(Filter aFilter) {
        return this.filterManager_.add_filter(aFilter);
    }

    public void remove_filter(int aFilterId) throws FilterNotFound {
        this.filterManager_.remove_filter(aFilterId);
    }

    public Filter get_filter(int aFilterId) throws FilterNotFound {
        return this.filterManager_.get_filter(aFilterId);
    }

    public int[] get_all_filters() {
        return this.filterManager_.get_all_filters();
    }

    public void remove_all_filters() {
        this.filterManager_.remove_all_filters();
    }

    public final InterFilterGroupOperator MyOperator() {
        return this.filterGroupOperator_;
    }

    public final EventChannel MyChannel() {
        return (EventChannel)this.eventChannelReference_.get();
    }

    public final int MyID() {
        return this.getID();
    }

    public final int getChannelID() {
        return this.channelID_;
    }

    public Property[] get_qos() {
        return this.qosSettings_.get_qos();
    }

    public void set_qos(Property[] props) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(props, new NamedPropertyRangeSeqHolder());
        this.qosSettings_.set_qos(props);
        this.logger_.debug("set_qos: " + this.qosSettings_);
    }

    public void validate_qos(Property[] props, NamedPropertyRangeSeqHolder propertyRangeSeqHolder) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(props, propertyRangeSeqHolder);
    }

    public final void destroy() {
        this.checkDestroyStatus();
        this.container_.dispose();
        List list = this.container_.getComponentInstancesOfType(class$org$jacorb$notification$IContainer == null ? (class$org$jacorb$notification$IContainer = AbstractAdmin.class$("org.jacorb.notification.IContainer")) : class$org$jacorb$notification$IContainer);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            IContainer element = (IContainer)i.next();
            element.destroy();
        }
    }

    private void checkDestroyStatus() throws OBJECT_NOT_EXIST {
        if (!this.disposed_.compareAndSet(false, true)) {
            throw new OBJECT_NOT_EXIST();
        }
    }

    public void dispose() {
        this.logger_.info("destroy Admin " + this.MyID());
        this.deactivate();
        this.remove_all_filters();
        this.disposables_.dispose();
        this.proxyEventListener_.clear();
    }

    public void deactivate() {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("deactivate Admin: " + this.getID());
        }
        try {
            byte[] _oid = this.getPOA().servant_to_id(this.getServant());
            this.getPOA().deactivate_object(_oid);
        }
        catch (Exception e) {
            this.logger_.error("Couldn't deactivate Admin", (Throwable)e);
        }
    }

    public abstract Servant getServant();

    public Integer getID() {
        return this.id_;
    }

    public boolean isDestroyed() {
        return this.disposed_.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCreateProxyRequestEvent() throws AdminLimitExceeded {
        List list = this.proxyEventListener_;
        synchronized (list) {
            ProxyEvent _event = new ProxyEvent(this);
            Iterator _i = this.proxyEventListener_.iterator();
            while (_i.hasNext()) {
                ProxyEventListener _listener = (ProxyEventListener)_i.next();
                _listener.actionProxyCreationRequest(_event);
            }
        }
    }

    public boolean hasLifetimeFilter() {
        return false;
    }

    public boolean hasPriorityFilter() {
        return false;
    }

    public MappingFilter getLifetimeFilter() {
        throw new UnsupportedOperationException();
    }

    public MappingFilter getPriorityFilter() {
        throw new UnsupportedOperationException();
    }

    public String getInterFilterGroupOperator() {
        return this.filterGroupOperator_.value() == 0 ? "AND_OP" : "OR_OP";
    }

    public boolean hasInterFilterGroupOperatorOR() {
        return this.filterGroupOperator_.value() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractProxy getProxy(int id) throws ProxyNotFound {
        AbstractProxy _servant;
        Integer _id = new Integer(id);
        Object object = this.modifyProxiesLock_;
        synchronized (object) {
            _servant = (AbstractProxy)this.pullServants_.get(_id);
            if (_servant == null) {
                _servant = (AbstractProxy)this.pushServants_.get(_id);
            }
        }
        if (_servant == null) {
            throw new ProxyNotFound("The proxy with ID=" + id + " does not exist");
        }
        if (!_servant.isIDPublic()) {
            throw new ProxyNotFound("The proxy with ID=" + id + " is a EventStyle proxy and therefor not accessible by ID");
        }
        return _servant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] get_all_notify_proxies(Map map, Object lock) {
        ArrayList _allIDsList = new ArrayList();
        Object object = lock;
        synchronized (object) {
            Iterator _i = map.entrySet().iterator();
            while (_i.hasNext()) {
                Map.Entry _entry = _i.next();
                if (!((AbstractProxy)_entry.getValue()).isIDPublic()) continue;
                _allIDsList.add(_entry.getKey());
            }
        }
        int[] _allIDsArray = new int[_allIDsList.size()];
        for (int x = 0; x < _allIDsArray.length; ++x) {
            _allIDsArray[x] = (Integer)_allIDsList.get(x);
        }
        return _allIDsArray;
    }

    protected void configureQoS(AbstractProxy proxy) throws UnsupportedQoS {
        this.logger_.debug("configure new AbstractProxy with " + this.qosSettings_);
        proxy.set_qos(this.qosSettings_.get_qos());
    }

    protected void configureInterFilterGroupOperator(AbstractProxy proxy) {
        if (this.filterGroupOperator_.value() == 1) {
            proxy.setInterFilterGroupOperatorOR(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProxyEventListener(ProxyEventListener l) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            this.proxyEventListener_.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProxyEventListener(ProxyEventListener listener) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            this.proxyEventListener_.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireProxyRemoved(AbstractProxy proxy) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            Iterator i = this.proxyEventListener_.iterator();
            ProxyEvent e = new ProxyEvent(proxy);
            while (i.hasNext()) {
                ((ProxyEventListener)i.next()).actionProxyDisposed(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProxyCreated(AbstractProxy proxy) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            Iterator i = this.proxyEventListener_.iterator();
            ProxyEvent e = new ProxyEvent(proxy);
            while (i.hasNext()) {
                ((ProxyEventListener)i.next()).actionProxyCreated(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addProxyToMap(final AbstractProxy proxy, final Map map, final Object lock) {
        Object object = lock;
        synchronized (object) {
            map.put(proxy.getID(), proxy);
            this.fireProxyCreated(proxy);
        }
        proxy.registerDisposable(new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                Object object = lock;
                synchronized (object) {
                    map.remove(proxy.getID());
                    AbstractAdmin.this.fireProxyRemoved(proxy);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List getProxies() {
        ArrayList _list = new ArrayList();
        Object object = this.modifyProxiesLock_;
        synchronized (object) {
            _list.addAll(this.pullServants_.values());
            _list.addAll(this.pushServants_.values());
        }
        return _list;
    }

    protected MutablePicoContainer newContainerForNotifyStyleProxy() {
        return this.newContainerForProxy(true);
    }

    protected MutablePicoContainer newContainerForEventStyleProxy() {
        return this.newContainerForProxy(false);
    }

    protected MutablePicoContainer newContainerForTypedProxy(String supportedInterface) {
        MutablePicoContainer _container = this.newContainerForNotifyStyleProxy();
        IAdmin _admin = (IAdmin)_container.getComponentInstanceOfType(class$org$jacorb$notification$servant$IAdmin == null ? (class$org$jacorb$notification$servant$IAdmin = AbstractAdmin.class$("org.jacorb.notification.servant.IAdmin")) : class$org$jacorb$notification$servant$IAdmin);
        ITypedAdminImpl _typedAdmin = new ITypedAdminImpl(_admin, _container, supportedInterface);
        _container.registerComponentInstance((Object)(class$org$jacorb$notification$servant$ITypedAdmin == null ? (class$org$jacorb$notification$servant$ITypedAdmin = AbstractAdmin.class$("org.jacorb.notification.servant.ITypedAdmin")) : class$org$jacorb$notification$servant$ITypedAdmin), (Object)_typedAdmin);
        return _container;
    }

    private MutablePicoContainer newContainerForProxy(boolean isIDPublic) {
        int proxyID = this.getProxyID();
        return this.newContainerForProxy(proxyID, isIDPublic);
    }

    private MutablePicoContainer newContainerForProxy(final int proxyID, final boolean isIDPublic) {
        final MutablePicoContainer _containerForProxy = PicoContainerFactory.createChildContainer(this.container_);
        IAdmin _admin = new IAdmin(){

            public MutablePicoContainer getContainer() {
                return _containerForProxy;
            }

            public int getProxyID() {
                return proxyID;
            }

            public boolean isIDPublic() {
                return isIDPublic;
            }

            public void destroy() {
                AbstractAdmin.this.container_.removeChildContainer((PicoContainer)_containerForProxy);
            }

            public String getAdminMBean() {
                return AbstractAdmin.this.getJMXObjectName();
            }
        };
        _containerForProxy.registerComponentInstance((Object)(class$org$jacorb$notification$servant$IAdmin == null ? (class$org$jacorb$notification$servant$IAdmin = AbstractAdmin.class$("org.jacorb.notification.servant.IAdmin")) : class$org$jacorb$notification$servant$IAdmin), (Object)_admin);
        return _containerForProxy;
    }

    public final String getJMXObjectName() {
        return "admin=" + this.getMBeanName() + ", " + this.parentMBean_;
    }

    public final String getMBeanName() {
        return this.getMBeanType() + "-" + this.getID();
    }

    protected abstract String getMBeanType();

    public String[] getJMXNotificationTypes() {
        return new String[0];
    }

    public final void setJMXCallback(JMXManageable.JMXCallback callback) {
        this.jmxCallback_ = callback;
    }

    protected final void sendNotification(String type, String message) {
        if (this.jmxCallback_ != null) {
            this.jmxCallback_.sendJMXNotification(type, message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ITypedAdminImpl
    implements ITypedAdmin {
        private final IAdmin admin_;
        private final MutablePicoContainer container_;
        private final String supportedInterface_;

        private ITypedAdminImpl(IAdmin admin, MutablePicoContainer container, String supportedInterface) {
            this.admin_ = admin;
            this.container_ = container;
            this.supportedInterface_ = supportedInterface;
        }

        public String getSupportedInterface() {
            return this.supportedInterface_;
        }

        public int getProxyID() {
            return this.admin_.getProxyID();
        }

        public boolean isIDPublic() {
            return this.admin_.isIDPublic();
        }

        public MutablePicoContainer getContainer() {
            return this.admin_.getContainer();
        }

        public void destroy() {
            this.container_.unregisterComponent((Object)(class$org$jacorb$notification$servant$ITypedAdmin == null ? (class$org$jacorb$notification$servant$ITypedAdmin = AbstractAdmin.class$("org.jacorb.notification.servant.ITypedAdmin")) : class$org$jacorb$notification$servant$ITypedAdmin));
            this.admin_.destroy();
        }

        public String getAdminMBean() {
            return this.admin_.getAdminMBean();
        }
    }
}

