/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import java.util.Comparator;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.queue.HeapEntry;

class QueueUtil {
    static final Message[] MESSAGE_ARRAY_TEMPLATE = new Message[0];
    static final HeapEntry[] HEAP_ENTRY_ARRAY_TEMPLATE = new HeapEntry[0];
    static Comparator ASCENDING_TIMEOUT_COMPARATOR = new Comparator(){

        public int compare(Object left, Object right) {
            Message _left = QueueUtil.toMessage(left);
            Message _right = QueueUtil.toMessage(right);
            if (_left.hasTimeout()) {
                if (!_right.hasTimeout()) {
                    return -1;
                }
                return (int)(_left.getTimeout() - _right.getTimeout());
            }
            if (_right.hasTimeout()) {
                return 1;
            }
            return 0;
        }
    };
    static Comparator ASCENDING_AGE_COMPARATOR = new Comparator(){

        public int compare(Object left, Object right) {
            HeapEntry _left = (HeapEntry)left;
            HeapEntry _right = (HeapEntry)right;
            return (int)(_left.order_ - _right.order_);
        }
    };
    static Comparator DESCENDING_AGE_COMPARATOR = new Comparator(){

        public int compare(Object left, Object right) {
            return -ASCENDING_AGE_COMPARATOR.compare(left, right);
        }
    };
    static Comparator ASCENDING_PRIORITY_COMPARATOR = new Comparator(){

        public int compare(Object left, Object right) {
            Message _right = QueueUtil.toMessage(right);
            Message _left = QueueUtil.toMessage(left);
            return _left.getPriority() - _right.getPriority();
        }
    };
    static Comparator DESCENDING_PRIORITY_COMPARATOR = new Comparator(){

        public int compare(Object left, Object right) {
            return -ASCENDING_PRIORITY_COMPARATOR.compare(left, right);
        }
    };

    private QueueUtil() {
    }

    /*
     * WARNING - void declaration
     */
    static Message toMessage(Object object) {
        void var1_1;
        Message _message;
        if (object instanceof HeapEntry) {
            _message = ((HeapEntry)object).event_;
        } else if (object instanceof Message) {
            _message = (Message)object;
        } else {
            throw new IllegalArgumentException();
        }
        return var1_1;
    }
}

