/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import edu.emory.mathcs.backport.java.util.PriorityQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.queue.AbstractBoundedEventQueue;
import org.jacorb.notification.queue.EventQueueOverflowStrategy;
import org.jacorb.notification.queue.HeapEntry;
import org.jacorb.notification.queue.QueueUtil;

public class BoundedPriorityEventQueue
extends AbstractBoundedEventQueue {
    private final PriorityQueue heap_;
    private long counter_ = 0L;
    private final int maxCapacity_;

    public BoundedPriorityEventQueue(int maxSize, EventQueueOverflowStrategy overflowStrategy) {
        super(maxSize, overflowStrategy, new Object());
        this.maxCapacity_ = maxSize;
        this.heap_ = new PriorityQueue(this.maxCapacity_, QueueUtil.DESCENDING_PRIORITY_COMPARATOR);
    }

    public String getOrderPolicyName() {
        return "PriorityOrder";
    }

    protected Message getNextElement() {
        return ((HeapEntry)this.heap_.remove()).event_;
    }

    protected Message getEarliestTimeout() {
        return this.removeFirstElement(QueueUtil.ASCENDING_TIMEOUT_COMPARATOR);
    }

    protected Message getOldestElement() {
        return this.removeFirstElement(QueueUtil.ASCENDING_AGE_COMPARATOR);
    }

    protected Message getYoungestElement() {
        return this.removeFirstElement(QueueUtil.DESCENDING_AGE_COMPARATOR);
    }

    protected Message getLeastPriority() {
        return this.removeFirstElement(QueueUtil.ASCENDING_PRIORITY_COMPARATOR);
    }

    protected Message[] getElements(int max) {
        ArrayList<Message> _events = new ArrayList<Message>();
        while (this.heap_.peek() != null && _events.size() <= max) {
            _events.add(((HeapEntry)this.heap_.remove()).event_);
        }
        return _events.toArray(QueueUtil.MESSAGE_ARRAY_TEMPLATE);
    }

    protected void addElement(Message event) {
        this.heap_.add((Object)new HeapEntry(event, this.counter_++));
    }

    private List removeAllEntries() {
        List _entries = this.copyAllEntries();
        this.heap_.clear();
        return _entries;
    }

    protected Message[] getAllElements() {
        List _entries = this.removeAllEntries();
        Message[] _messages = new Message[_entries.size()];
        Iterator i = _entries.iterator();
        int x = 0;
        while (i.hasNext()) {
            HeapEntry e = (HeapEntry)i.next();
            _messages[x++] = e.event_;
        }
        return _messages;
    }

    private Message removeFirstElement(Comparator comp) {
        List _entries = this.copyAllEntries();
        Collections.sort(_entries, comp);
        HeapEntry _entry = (HeapEntry)_entries.get(0);
        this.heap_.remove((Object)_entry);
        return _entry.event_;
    }

    private List copyAllEntries() {
        ArrayList _entries = new ArrayList(this.heap_.size());
        _entries.addAll(this.heap_);
        return _entries;
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public int getSize() {
        return this.heap_.size();
    }

    public String toString() {
        return this.heap_.toString();
    }
}

