/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter;

import java.lang.reflect.Field;
import org.jacorb.notification.filter.DynamicTypeException;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.ImmutableEvaluationResultWrapper;
import org.omg.CORBA.Any;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;

public class EvaluationResult {
    public static final EvaluationResult BOOL_TRUE;
    public static final EvaluationResult BOOL_FALSE;
    private int typeCode_;
    private Object value_;
    private Any any_;
    static /* synthetic */ Class class$org$omg$CORBA$TCKind;

    protected Object getValue() {
        return this.value_;
    }

    private Object setValue(Object value) {
        Object _old = this.value_;
        this.value_ = value;
        return _old;
    }

    public boolean isLongLong() {
        return this.typeCode_ == 23;
    }

    public boolean isDouble() {
        return this.typeCode_ == 7;
    }

    public boolean isFloat() {
        return this.typeCode_ == 6;
    }

    public boolean isLong() {
        return this.typeCode_ == 3;
    }

    public boolean isString() {
        return this.typeCode_ == 18;
    }

    public void setString(String s) {
        this.setValue(s);
        this.typeCode_ = 18;
    }

    public void setFloat(float f) {
        this.setFloat(new Double(f));
    }

    public void setFloat(double d) {
        this.setFloat(new Double(d));
    }

    public void setFloat(Double d) {
        this.setValue(d);
        this.typeCode_ = 6;
    }

    public void setLongLong(long l) {
        this.setLongLong(new Double(l));
    }

    public void setLongLong(Double d) {
        this.setValue(d);
        this.typeCode_ = 23;
    }

    public void setLong(int l) {
        this.setLong(new Double(l));
    }

    public void setLong(Double d) {
        this.setValue(d);
        this.typeCode_ = 3;
    }

    public void setDouble(Double d) {
        this.setValue(d);
        this.typeCode_ = 7;
    }

    public void setDouble(double d) {
        this.setDouble(new Double(d));
    }

    public String getString() throws DynamicTypeException {
        try {
            return (String)this.getValue();
        }
        catch (ClassCastException c) {
            throw this.newDynamicTypeException("String");
        }
    }

    private DynamicTypeException newDynamicTypeException(String type) {
        return new DynamicTypeException("could not convert value: " + this.getValue() + " to " + type);
    }

    private static DynamicTypeException newDynamicTypeException(String operand, EvaluationResult left, EvaluationResult right) {
        return new DynamicTypeException("failed to " + operand + ": incompatible operands " + left + " and " + right);
    }

    public long getLongLong() throws DynamicTypeException {
        try {
            return ((Double)this.getValue()).longValue();
        }
        catch (ClassCastException e) {
            try {
                return (Boolean)this.getValue() != false ? 1L : 0L;
            }
            catch (ClassCastException e2) {
                try {
                    String _s = (String)this.getValue();
                    if (_s.length() == 1) {
                        return _s.charAt(0);
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                throw this.newDynamicTypeException("LongLong");
            }
        }
    }

    public int getLong() throws DynamicTypeException {
        block8: {
            if (this.getValue() != null) {
                try {
                    return ((Double)this.getValue()).intValue();
                }
                catch (ClassCastException e) {
                    try {
                        return (Boolean)this.getValue() != false ? 1 : 0;
                    }
                    catch (ClassCastException e2) {
                        try {
                            String _s = (String)this.getValue();
                            if (_s.length() == 1) {
                                return _s.charAt(0);
                            }
                            break block8;
                        }
                        catch (ClassCastException classCastException) {}
                        break block8;
                    }
                }
            }
            return this.any_.extract_long();
        }
        throw this.newDynamicTypeException("Long");
    }

    public double getDouble() throws DynamicTypeException {
        try {
            return (Double)this.getValue();
        }
        catch (ClassCastException e) {
            try {
                return (Boolean)this.getValue() != false ? 1.0 : 0.0;
            }
            catch (ClassCastException e2) {
                try {
                    String _s = (String)this.getValue();
                    if (_s.length() == 1) {
                        return _s.charAt(0);
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                throw this.newDynamicTypeException("Double");
            }
        }
    }

    public float getFloat() throws DynamicTypeException {
        try {
            return ((Double)this.getValue()).floatValue();
        }
        catch (ClassCastException e) {
            try {
                return (Boolean)this.getValue() != false ? 1.0f : 0.0f;
            }
            catch (ClassCastException e2) {
                try {
                    String _str = (String)this.getValue();
                    if (_str.length() == 1) {
                        return _str.charAt(0);
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                throw this.newDynamicTypeException("Float");
            }
        }
    }

    public boolean getBool() throws DynamicTypeException {
        try {
            return (Boolean)this.getValue();
        }
        catch (ClassCastException classCastException) {
            throw this.newDynamicTypeException("Boolean");
        }
    }

    public void setBool(boolean value) {
        this.setValue(value);
        this.typeCode_ = 8;
    }

    public Any getAny() {
        return this.any_;
    }

    public void addAny(Any any) {
        this.any_ = any;
    }

    private static String typeCodeToName(int x) {
        try {
            Field[] _fields = (class$org$omg$CORBA$TCKind == null ? (class$org$omg$CORBA$TCKind = EvaluationResult.class$("org.omg.CORBA.TCKind")) : class$org$omg$CORBA$TCKind).getDeclaredFields();
            return _fields[x].getName();
        }
        catch (Exception e) {
            return "unknown: " + x;
        }
    }

    public String toString() {
        StringBuffer _buffer = new StringBuffer("{");
        _buffer.append(this.getValue());
        _buffer.append(";TC=");
        _buffer.append(EvaluationResult.typeCodeToName(this.typeCode_));
        _buffer.append(";any=");
        _buffer.append(this.any_);
        _buffer.append("}");
        return _buffer.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof EvaluationResult) {
            return ((EvaluationResult)o).getValue().equals(this.getValue());
        }
        return super.equals(o);
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public int compareTo(EvaluationResult other) throws DynamicTypeException, EvaluationException {
        int _result;
        if (this.getValue() == null && this.any_ != null && other.getValue() instanceof String) {
            try {
                String _left = this.any_.type().member_name(0);
                _result = _left.compareTo(other.getString());
            }
            catch (BadKind e) {
                throw new EvaluationException(e);
            }
            catch (Bounds e) {
                throw new EvaluationException(e);
            }
        } else if (this.isString() || other.isString()) {
            _result = this.getString().compareTo(other.getString());
        } else if (this.isFloat() || other.isFloat()) {
            float _l = this.getFloat();
            float _r = other.getFloat();
            _result = Float.compare(_l, _r);
        } else {
            int _l = this.getLong();
            int _r = other.getLong();
            _result = _l - _r;
        }
        return _result;
    }

    public static EvaluationResult wrapImmutable(EvaluationResult e) {
        return new ImmutableEvaluationResultWrapper(e);
    }

    public static EvaluationResult plus(EvaluationResult left, EvaluationResult right) throws DynamicTypeException {
        EvaluationResult _res = new EvaluationResult();
        if (left.isDouble() || right.isDouble()) {
            _res.setDouble(left.getDouble() + right.getDouble());
        } else if (left.isFloat() || right.isFloat()) {
            _res.setFloat(left.getDouble() + right.getDouble());
        } else if (left.isLongLong() || right.isLongLong()) {
            _res.setLongLong(left.getLongLong() + right.getLongLong());
        } else if (left.isLong() || right.isLong()) {
            _res.setLong(left.getLong() + right.getLong());
        } else {
            throw EvaluationResult.newDynamicTypeException("add", left, right);
        }
        return _res;
    }

    public static EvaluationResult minus(EvaluationResult left, EvaluationResult right) throws DynamicTypeException {
        EvaluationResult _res = new EvaluationResult();
        if (left.isDouble() || right.isDouble()) {
            _res.setDouble(left.getDouble() - right.getDouble());
        } else if (left.isFloat() || right.isFloat()) {
            _res.setFloat(left.getDouble() - right.getDouble());
        } else if (left.isLongLong() || right.isLongLong()) {
            _res.setLongLong(left.getLongLong() - right.getLongLong());
        } else if (left.isLong() || right.isLong()) {
            _res.setLong(left.getLong() - right.getLong());
        } else {
            throw EvaluationResult.newDynamicTypeException("subtract", left, right);
        }
        return _res;
    }

    public static EvaluationResult unaryMinus(EvaluationResult r) throws DynamicTypeException {
        EvaluationResult _ret = new EvaluationResult();
        if (r.isFloat()) {
            _ret.setFloat(-r.getFloat());
        } else {
            _ret.setDouble(-r.getDouble());
        }
        return _ret;
    }

    public static EvaluationResult div(EvaluationResult left, EvaluationResult right) throws DynamicTypeException {
        EvaluationResult _res = new EvaluationResult();
        if (left.isDouble() || right.isDouble()) {
            _res.setDouble(left.getDouble() / right.getDouble());
        } else if (left.isFloat() || right.isFloat()) {
            _res.setFloat(left.getDouble() / right.getDouble());
        } else if (left.isLongLong() || right.isLongLong()) {
            _res.setLongLong(left.getLongLong() / right.getLongLong());
        } else if (left.isLong() || right.isLong()) {
            _res.setLong(left.getLong() / right.getLong());
        } else {
            throw EvaluationResult.newDynamicTypeException("divide", left, right);
        }
        return _res;
    }

    public static EvaluationResult mult(EvaluationResult left, EvaluationResult right) throws DynamicTypeException {
        EvaluationResult _res = new EvaluationResult();
        if (left.isDouble() || right.isDouble()) {
            _res.setDouble(left.getDouble() * right.getDouble());
        } else if (left.isFloat() || right.isFloat()) {
            _res.setFloat(left.getDouble() * right.getDouble());
        } else if (left.isLongLong() || right.isLongLong()) {
            _res.setLongLong(left.getLongLong() * right.getLongLong());
        } else if (left.isLong() || right.isLong()) {
            _res.setLong(left.getLong() * right.getLong());
        } else {
            throw EvaluationResult.newDynamicTypeException("multiply", left, right);
        }
        return _res;
    }

    public static EvaluationResult fromAny(Any any) {
        EvaluationResult result;
        if (any == null) {
            return null;
        }
        switch (any.type().kind().value()) {
            case 11: {
                result = EvaluationResult.fromAny(any.extract_any());
                break;
            }
            default: {
                result = new EvaluationResult();
                EvaluationResult.extractIntoEvaluationResult(result, any);
            }
        }
        return result;
    }

    private static void extractIntoEvaluationResult(EvaluationResult result, Any any) {
        switch (any.type().kind().value()) {
            case 8: {
                result.setBool(any.extract_boolean());
                break;
            }
            case 18: {
                result.setString(any.extract_string());
                break;
            }
            case 3: {
                result.setLong(any.extract_long());
                break;
            }
            case 2: {
                result.setLong(any.extract_short());
                break;
            }
            case 24: {
                result.setLongLong(any.extract_ulonglong());
                break;
            }
            default: {
                result.addAny(any);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        EvaluationResult _r = new EvaluationResult();
        _r.setBool(true);
        BOOL_TRUE = EvaluationResult.wrapImmutable(_r);
        _r = new EvaluationResult();
        _r.setBool(false);
        BOOL_FALSE = EvaluationResult.wrapImmutable(_r);
    }
}

