/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.util.Date;
import org.jacorb.notification.AbstractMessage;
import org.jacorb.notification.NoTranslationException;
import org.jacorb.notification.filter.ComponentName;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.TCKind;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotification.StructuredEventHelper;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;
import org.omg.TimeBase.TimeTHelper;
import org.omg.TimeBase.UtcT;
import org.omg.TimeBase.UtcTHelper;

public class StructuredEventMessage
extends AbstractMessage {
    private Any anyValue_;
    private StructuredEvent structuredEventValue_;
    private Property[] typedEventValue_;
    private String constraintKey_;
    private Date startTime_ = null;
    private Date stopTime_ = null;
    private long timeout_ = 0L;
    private boolean isTimeoutSet_;
    private short priority_;
    private NoTranslationException translationException_ = null;

    public synchronized void setStructuredEvent(StructuredEvent structuredEvent, boolean startTimeSupported, boolean stopTimeSupported) {
        this.structuredEventValue_ = structuredEvent;
        this.constraintKey_ = AbstractMessage.calcConstraintKey(this.structuredEventValue_.header.fixed_header.event_type.domain_name, this.structuredEventValue_.header.fixed_header.event_type.type_name);
        this.parseQosSettings(startTimeSupported, stopTimeSupported);
    }

    public void doReset() {
        this.anyValue_ = null;
        this.structuredEventValue_ = null;
        this.typedEventValue_ = null;
        this.constraintKey_ = null;
        this.startTime_ = null;
        this.stopTime_ = null;
        this.priority_ = 0;
        this.translationException_ = null;
    }

    public int getType() {
        return 1;
    }

    public synchronized Any toAny() {
        if (this.anyValue_ == null) {
            this.anyValue_ = sOrb.create_any();
            StructuredEventHelper.insert(this.anyValue_, this.structuredEventValue_);
        }
        return this.anyValue_;
    }

    public synchronized StructuredEvent toStructuredEvent() {
        return this.structuredEventValue_;
    }

    public synchronized Property[] toTypedEvent() throws NoTranslationException {
        if (this.translationException_ != null) {
            throw this.translationException_;
        }
        if (this.typedEventValue_ == null) {
            try {
                if (!this.structuredEventValue_.filterable_data[0].name.equals("operation")) {
                    throw new IllegalArgumentException();
                }
                if (!this.structuredEventValue_.filterable_data[0].value.type().kind().equals(TCKind.tk_string)) {
                    throw new IllegalArgumentException();
                }
                this.typedEventValue_ = this.structuredEventValue_.filterable_data;
            }
            catch (Exception e) {
                this.translationException_ = new NoTranslationException(e);
                throw this.translationException_;
            }
        }
        return this.typedEventValue_;
    }

    public synchronized String getConstraintKey() {
        return this.constraintKey_;
    }

    public EvaluationResult extractFilterableData(EvaluationContext context, ComponentName root, String name) throws EvaluationException {
        Any _any = context.getETCLEvaluator().evaluatePropertyList(this.toStructuredEvent().filterable_data, name);
        return EvaluationResult.fromAny(_any);
    }

    public EvaluationResult extractVariableHeader(EvaluationContext context, ComponentName root, String name) throws EvaluationException {
        Any _any = context.getETCLEvaluator().evaluatePropertyList(this.toStructuredEvent().header.variable_header, name);
        return EvaluationResult.fromAny(_any);
    }

    private synchronized void parseQosSettings(boolean startTimeSupported, boolean stopTimeSupported) {
        Property[] props = this.toStructuredEvent().header.variable_header;
        for (int x = 0; x < props.length; ++x) {
            if (startTimeSupported && "StartTime".equals(props[x].name)) {
                this.startTime_ = new Date(StructuredEventMessage.unixTime(UtcTHelper.extract(props[x].value)));
                continue;
            }
            if (stopTimeSupported && "StopTime".equals(props[x].name)) {
                this.stopTime_ = new Date(StructuredEventMessage.unixTime(UtcTHelper.extract(props[x].value)));
                continue;
            }
            if (stopTimeSupported && "Timeout".equals(props[x].name)) {
                this.setTimeout(TimeTHelper.extract(props[x].value) / 10000L);
                continue;
            }
            if (!"Priority".equals(props[x].name)) continue;
            this.priority_ = props[x].value.extract_short();
        }
    }

    private static long unixTime(UtcT corbaTime) {
        long _unixTime = (corbaTime.time - 122192928000000000L) / 10000L;
        if (corbaTime.tdf != 0) {
            _unixTime -= (long)(corbaTime.tdf * 60000);
        }
        return _unixTime;
    }

    public synchronized boolean hasStartTime() {
        return this.startTime_ != null;
    }

    public synchronized long getStartTime() {
        return this.startTime_.getTime();
    }

    public synchronized boolean hasStopTime() {
        return this.stopTime_ != null;
    }

    public synchronized long getStopTime() {
        return this.stopTime_.getTime();
    }

    public synchronized boolean hasTimeout() {
        return this.isTimeoutSet_;
    }

    public synchronized long getTimeout() {
        return this.timeout_;
    }

    private synchronized void setTimeout(long timeout) {
        this.isTimeoutSet_ = true;
        this.timeout_ = timeout;
    }

    public boolean match(Filter filter) throws UnsupportedFilterableData {
        return filter.match_structured(this.toStructuredEvent());
    }

    public synchronized int getPriority() {
        return this.priority_;
    }

    public boolean match(MappingFilter filter, AnyHolder value) throws UnsupportedFilterableData {
        return filter.match_structured(this.toStructuredEvent(), value);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("StructuredEventMessage [referenced=");
        buffer.append(this.referenced_);
        buffer.append(", StructuredEvent=");
        buffer.append(this.toStructuredEvent());
        buffer.append("]");
        return buffer.toString();
    }
}

