/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import java.util.Hashtable;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.TypeCode;

public class TypeCodeUtil {
    private static Hashtable cache = new Hashtable();

    public static org.omg.CORBA.TypeCode getTypeCode(Class c, Object o, Logger logger) throws ClassNotFoundException {
        return TypeCodeUtil.getTypeCode(c, null, o, null, logger);
    }

    public static org.omg.CORBA.TypeCode getTypeCode(Class c, ClassLoader classLoader, Object o, String idlName, Logger logger) throws ClassNotFoundException {
        String typeName = c.getName();
        if (logger.isDebugEnabled()) {
            logger.debug("TypeCodes.getTypeCode for class : " + typeName + " idlName: " + idlName);
        }
        ClassLoader loader = classLoader != null ? classLoader : c.getClassLoader();
        org.omg.CORBA.TypeCode _tc = (org.omg.CORBA.TypeCode)cache.get(typeName);
        if (_tc != null) {
            return _tc;
        }
        if (idlName != null && (_tc = (org.omg.CORBA.TypeCode)cache.get(idlName)) != null) {
            return _tc;
        }
        if (c.isPrimitive()) {
            if (typeName.equals("void")) {
                return new TypeCode(1);
            }
            if (typeName.equals("int")) {
                return new TypeCode(3);
            }
            if (typeName.equals("long")) {
                return new TypeCode(23);
            }
            if (typeName.equals("short")) {
                return new TypeCode(2);
            }
            if (typeName.equals("float")) {
                return new TypeCode(6);
            }
            if (typeName.equals("double")) {
                return new TypeCode(7);
            }
            if (typeName.equals("boolean")) {
                return new TypeCode(8);
            }
            if (typeName.equals("byte")) {
                return new TypeCode(10);
            }
            if (typeName.equals("char")) {
                return new TypeCode(9);
            }
            if (typeName.equals("wchar")) {
                return new TypeCode(26);
            }
            System.err.println("- TypeCode.getTypeCode, primitive class not found " + typeName);
            return null;
        }
        Class<?> tcClass = null;
        Class<?> idlEntity = null;
        try {
            tcClass = Class.forName("org.omg.CORBA.TypeCode", true, loader);
            idlEntity = Class.forName("org.omg.CORBA.portable.IDLEntity", true, loader);
        }
        catch (ClassNotFoundException ce) {
            logger.fatalError("Can't load org.jacorb base classes!", (Throwable)ce);
            throw ce;
        }
        boolean field_size = false;
        if (tcClass.isAssignableFrom(c)) {
            return new TypeCode(12);
        }
        if (idlName != null && idlName.length() > 0) {
            try {
                if (idlName.equals("java.lang.String")) {
                    return new TypeCode(18);
                }
                if (idlName.equals("org.omg.CORBA.Boolean")) {
                    return new TypeCode(8);
                }
                if (idlName.equals("org.omg.CORBA.Byte")) {
                    return new TypeCode(10);
                }
                if (idlName.equals("org.omg.CORBA.Short")) {
                    return new TypeCode(2);
                }
                if (idlName.equals("org.omg.CORBA.Long")) {
                    return new TypeCode(23);
                }
                if (idlName.equals("org.omg.CORBA.Int")) {
                    return new TypeCode(3);
                }
                if (idlName.equals("org.omg.CORBA.String")) {
                    return new TypeCode(18);
                }
                if (idlName.equals("org.omg.CORBA.Char")) {
                    return new TypeCode(9);
                }
                if (idlName.equals("org.omg.CORBA.Float")) {
                    return new TypeCode(6);
                }
                if (idlName.equals("org.omg.CORBA.Double")) {
                    return new TypeCode(7);
                }
                if (idlName.equals("org.omg.CORBA.Any")) {
                    return new TypeCode(11);
                }
                if (idlName.equals("org.omg.CORBA.Object")) {
                    return new TypeCode(14);
                }
                if (idlName.equals("org.omg.CORBA.TypeCode")) {
                    return new TypeCode(12);
                }
                Class<?> type = Class.forName(idlName + "Helper", true, loader);
                return (org.omg.CORBA.TypeCode)type.getDeclaredMethod("type", null).invoke(null, (Object[])null);
            }
            catch (ClassNotFoundException cnfe) {
                logger.debug("Caught Exception", (Throwable)cnfe);
                throw new RuntimeException("Could not create TypeCode for: " + c.getName() + ", no helper class for " + idlName);
            }
            catch (Exception e) {
                logger.error("Caught Exception", (Throwable)e);
            }
        }
        if (idlEntity.isAssignableFrom(c)) {
            try {
                Class<?> resultHelperClass = Class.forName(c.getName() + "Helper", true, loader);
                return (org.omg.CORBA.TypeCode)resultHelperClass.getDeclaredMethod("type", null).invoke(null, (Object[])null);
            }
            catch (Exception cnfe) {
                logger.error("Caught Exception", (Throwable)cnfe);
                throw new RuntimeException("Could not create TypeCode for: " + c.getName());
            }
        }
        throw new RuntimeException("Could not create TypeCode for: " + c.getName() + ", not an IDLEntity");
    }

    private static String idToIDL(String s) {
        s = s.startsWith("IDL:") ? s.substring(4, s.lastIndexOf(":")) : s.replace('.', '/') + ":1.0";
        StringBuffer sb = new StringBuffer(s);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '/') continue;
            sb.setCharAt(i, ':');
            sb.insert(i, ':');
        }
        return sb.toString();
    }

    static {
        cache.put("java.lang.String", new TypeCode(18));
        cache.put("org.omg.CORBA.String", new TypeCode(18));
        cache.put("java.lang.Void", new TypeCode(1));
        cache.put("java.lang.Long", new TypeCode(23));
        cache.put("java.lang.Integer", new TypeCode(3));
        cache.put("java.lang.Short", new TypeCode(2));
        cache.put("java.lang.Float", new TypeCode(6));
        cache.put("java.lang.Double", new TypeCode(7));
        cache.put("java.lang.Boolean", new TypeCode(8));
        cache.put("java.lang.Byte", new TypeCode(10));
        cache.put("org.omg.CORBA.Any", new TypeCode(11));
        cache.put("java.lang.Character", new TypeCode(9));
        cache.put("org.omg.CORBA.TypeCode", new TypeCode(12));
        cache.put("org.omg.CORBA.Principal", new TypeCode(13));
        cache.put("org.omg.CORBA.Object", new TypeCode(14, "IDL:omg.org/CORBA/Object:1.0", "IDL:omg.org/CORBA/Object:1.0"));
    }
}

