/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import java.util.StringTokenizer;
import org.jacorb.util.ObjectUtil;
import org.jacorb.util.ValueHandler;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.portable.BoxedValueHelper;

public class RepositoryID {
    static /* synthetic */ Class class$org$omg$CORBA$portable$IDLEntity;

    public static String className(String repId, ClassLoader loader) {
        return RepositoryID.className(repId, null, loader);
    }

    public static String className(String repId, String suffix, ClassLoader loader) {
        if (repId.startsWith("RMI:")) {
            repId = RepositoryID.convertFromISOLatin1(repId);
            return repId.substring(4, repId.indexOf(58, 4)) + (suffix != null ? suffix : "");
        }
        if (repId.startsWith("IDL:")) {
            String id = repId.substring(4, repId.lastIndexOf(58)) + (suffix != null ? suffix : "");
            if (id.equals("omg.org/CORBA/WStringValue")) {
                return "java.lang.String";
            }
            int firstSlash = id.indexOf("/");
            String prefix = id.substring(0, firstSlash);
            if (prefix.equals("omg.org")) {
                return RepositoryID.ir2scopes("org.omg", id.substring(firstSlash + 1), loader);
            }
            if (prefix.indexOf(46) != -1) {
                return RepositoryID.ir2scopes(RepositoryID.reversePrefix(prefix), id.substring(firstSlash + 1), loader);
            }
            return RepositoryID.ir2scopes("", id, loader);
        }
        throw new INTF_REPOS("Unrecognized RepositoryID: " + repId);
    }

    private static String convertFromISOLatin1(String id) {
        StringBuffer dest = new StringBuffer(id.length());
        int pos = 0;
        int index = -1;
        while ((index = id.indexOf("\\U", pos)) != -1) {
            dest.append(id.substring(pos, index));
            pos = index + 6;
            char theChar = (char)Integer.parseInt(id.substring(index + 2, index + 6), 16);
            dest.append(theChar);
        }
        if (pos < id.length()) {
            dest.append(id.substring(pos));
        }
        return dest.toString();
    }

    private static final String reversePrefix(String prefix) {
        StringTokenizer tok = new StringTokenizer(prefix, ".");
        String result = tok.nextToken();
        while (tok.hasMoreTokens()) {
            result = tok.nextToken() + '.' + result;
        }
        return result;
    }

    private static String ir2scopes(String prefix, String s, ClassLoader loader) {
        if (s.indexOf("/") < 0) {
            return s;
        }
        StringTokenizer strtok = new StringTokenizer(s, "/");
        int count = strtok.countTokens();
        StringBuffer sb = new StringBuffer();
        sb.append(prefix);
        int i = 0;
        while (strtok.hasMoreTokens()) {
            String sc = strtok.nextToken();
            Class c = null;
            c = sb.toString().length() > 0 ? RepositoryID.loadClass(sb.toString() + "." + sc, loader) : RepositoryID.loadClass(sc, loader);
            if (c == null) {
                if (sb.toString().length() > 0) {
                    sb.append("." + sc);
                } else {
                    sb.append(sc);
                }
            } else if (i < count - 1) {
                sb.append("." + sc + "Package");
            } else {
                sb.append("." + sc);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String repId(Class c) {
        if ((class$org$omg$CORBA$portable$IDLEntity == null ? (class$org$omg$CORBA$portable$IDLEntity = RepositoryID.class$("org.omg.CORBA.portable.IDLEntity")) : class$org$omg$CORBA$portable$IDLEntity).isAssignableFrom(c)) {
            String className = c.getName();
            String head = "";
            String body = "";
            if (className.startsWith("org.omg") || className.startsWith("org/omg")) {
                if (className.length() > 7) {
                    body = className.substring(7);
                }
                return "IDL:omg.org/" + RepositoryID.scopesToIR(body) + ":1.0";
            }
            return "IDL:" + RepositoryID.scopesToIR(className) + ":1.0";
        }
        return ValueHandler.getRMIRepositoryID(c);
    }

    private static String scopesToIR(String s) {
        if (s.indexOf(".") < 0) {
            return s;
        }
        StringTokenizer strtok = new StringTokenizer(s, ".");
        String[] scopes = new String[strtok.countTokens()];
        int i = 0;
        while (strtok.hasMoreTokens()) {
            String sc = strtok.nextToken();
            scopes[i] = sc.endsWith("Package") ? sc.substring(0, sc.indexOf("Package")) : sc;
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        if (scopes.length > 1) {
            for (int i2 = 0; i2 < scopes.length - 1; ++i2) {
                sb.append(scopes[i2] + "/");
            }
        }
        sb.append(scopes[scopes.length - 1]);
        return sb.toString();
    }

    public static String toRepositoryID(String className, boolean resolveClass, ClassLoader loader) {
        if (className.equals("") || className.startsWith("IDL:") || className.startsWith("RMI:")) {
            return className;
        }
        if (resolveClass) {
            Class c = RepositoryID.loadClass(className, loader);
            if (c == null) {
                throw new IllegalArgumentException("cannot find class: " + className);
            }
            return RepositoryID.repId(c);
        }
        return "IDL:" + className + ":1.0";
    }

    public static String toRepositoryID(String className, ClassLoader loader) {
        return RepositoryID.toRepositoryID(className, true, loader);
    }

    private static Class loadClass(String name, ClassLoader loader) {
        try {
            if (loader != null) {
                return loader.loadClass(name);
            }
            return ObjectUtil.classForName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static BoxedValueHelper createBoxedValueHelper(String repId, ClassLoader loader) {
        String className = RepositoryID.className(repId, "Helper", loader);
        Class c = RepositoryID.loadClass(className, loader);
        if (c != null) {
            try {
                return (BoxedValueHelper)c.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

