/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.dds;

import java.util.Iterator;
import java.util.Vector;
import org.jacorb.dds.DomainParticipantImpl;
import org.jacorb.dds.ThreadSubscriber;
import org.jacorb.events.EventChannelImpl;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.PortableServer.POA;
import org.omg.dds.DomainParticipant;
import org.omg.dds.DomainParticipantFactory;
import org.omg.dds.DomainParticipantFactoryPOA;
import org.omg.dds.DomainParticipantHelper;
import org.omg.dds.DomainParticipantListener;
import org.omg.dds.DomainParticipantQos;
import org.omg.dds.DomainParticipantQosHolder;

public class DomainParticipantFactoryImpl
extends DomainParticipantFactoryPOA {
    private ORB orb;
    private POA poa;
    private DomainParticipantQos defaultqos;
    private ThreadSubscriber Consummer;
    private Vector allParticipant;
    private DomainParticipantFactoryImpl impl;
    private DomainParticipantFactory ref;

    public void setPOA(POA poa) {
        this.poa = poa;
    }

    public void setORB(ORB orb) {
        this.orb = orb;
    }

    public DomainParticipantFactoryImpl(ORB orb, POA poa) {
        this.orb = orb;
        this.poa = poa;
        try {
            NamingContextExt nc = NamingContextExtHelper.narrow(orb.resolve_initial_references("NameService"));
            EventChannelImpl channel = new EventChannelImpl(orb, poa);
            Object o = poa.servant_to_reference(channel);
            nc.rebind(nc.to_name("eventchannel"), o);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.allParticipant = new Vector();
        this.Consummer = new ThreadSubscriber(orb, poa);
        this.Consummer.start();
    }

    public DomainParticipant create_participant(int domainId, DomainParticipantQos qos, DomainParticipantListener a_listener) {
        DomainParticipant ref = null;
        DomainParticipantImpl impl = new DomainParticipantImpl(domainId, qos, a_listener);
        impl.setORB(this.orb);
        impl.setPOA(this.poa);
        try {
            ref = this.has_domainId(domainId);
            if (ref != null) {
                return ref;
            }
            Object objRef = this.orb.resolve_initial_references("NameService");
            NamingContextExt ncRef = NamingContextExtHelper.narrow(objRef);
            Object oref = this.poa.servant_to_reference(impl);
            ref = DomainParticipantHelper.narrow(oref);
            if (ncRef != null) {
                NameComponent[] path = ncRef.to_name(new Integer(domainId).toString());
                ncRef.rebind(path, ref);
                this.allParticipant.add(ref);
                this.Consummer.add(ref);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return ref;
    }

    public int delete_participant(DomainParticipant a_participant) {
        try {
            boolean delete_ok = ((DomainParticipantImpl)this.poa.reference_to_servant(a_participant)).isDeletable();
            if (!delete_ok) {
                return 4;
            }
            Object objRef = this.orb.resolve_initial_references("NameService");
            NamingContextExt ncRef = NamingContextExtHelper.narrow(objRef);
            String id = new Integer(a_participant.get_domain_id()).toString();
            NameComponent[] path = ncRef.to_name(id);
            ncRef.unbind(path);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace(System.out);
        }
        return 0;
    }

    public DomainParticipant has_domainId(int domainId) {
        Iterator it = this.allParticipant.iterator();
        while (it.hasNext()) {
            DomainParticipant temp = (DomainParticipant)it.next();
            if (temp.get_domain_id() != domainId) continue;
            return temp;
        }
        return null;
    }

    public DomainParticipant lookup_participant(int domainId) {
        DomainParticipant ref = null;
        try {
            Object objRef = this.orb.resolve_initial_references("NameService");
            NamingContextExt ncRef = NamingContextExtHelper.narrow(objRef);
            ref = DomainParticipantHelper.narrow(ncRef.resolve_str(new Integer(domainId).toString()));
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace(System.out);
        }
        return ref;
    }

    public int set_default_participant_qos(DomainParticipantQos qos) {
        this.defaultqos = qos;
        return 0;
    }

    public void get_default_participant_qos(DomainParticipantQosHolder qos) {
        qos.value = this.defaultqos;
    }

    public ORB getOrb() {
        return this.orb;
    }

    public POA getPoa() {
        return this.poa;
    }
}

