/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSModelGroupDefinition;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.Constants;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.metadata.AddMethodMetaData;
import org.jboss.xb.binding.metadata.CharactersMetaData;
import org.jboss.xb.binding.metadata.ClassMetaData;
import org.jboss.xb.binding.metadata.MapEntryMetaData;
import org.jboss.xb.binding.metadata.PackageMetaData;
import org.jboss.xb.binding.metadata.PropertyMetaData;
import org.jboss.xb.binding.metadata.PutMethodMetaData;
import org.jboss.xb.binding.metadata.SchemaMetaData;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.metadata.XsdAnnotation;
import org.jboss.xb.binding.metadata.XsdAppInfo;
import org.jboss.xb.binding.sunday.unmarshalling.AllBinding;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ChoiceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultHandlers;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SequenceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;

public class XsdBinder {
    static final Logger log = Logger.getLogger((Class)XsdBinder.class);
    private static final ThreadLocal xsdBinding = new ThreadLocal();

    private static XsdBinding getXsdBinding() {
        XsdBinding local = (XsdBinding)xsdBinding.get();
        if (local == null) {
            local = new XsdBinding();
            xsdBinding.set(local);
        }
        return local;
    }

    private XsdBinder() {
    }

    public static SchemaBinding bind(String xsdUrl) {
        DefaultSchemaResolver resolver = new DefaultSchemaResolver();
        resolver.setBaseURI(xsdUrl);
        return XsdBinder.bind(xsdUrl, (SchemaBindingResolver)resolver);
    }

    public static SchemaBinding bind(String xsdUrl, SchemaBindingResolver resolver) {
        XSModel model = Util.loadSchema(xsdUrl, resolver);
        return XsdBinder.bind(model, resolver);
    }

    public static SchemaBinding bind(InputStream xsdStream, String encoding) {
        return XsdBinder.bind(xsdStream, encoding, (SchemaBindingResolver)new DefaultSchemaResolver());
    }

    public static SchemaBinding bind(InputStream xsdStream, String encoding, String baseURI) {
        return XsdBinder.bind(xsdStream, encoding, baseURI, true);
    }

    public static SchemaBinding bind(InputStream xsdStream, String encoding, String baseURI, boolean processAnnotations) {
        DefaultSchemaResolver resolver = new DefaultSchemaResolver();
        resolver.setBaseURI(baseURI);
        return XsdBinder.bind(xsdStream, encoding, resolver, processAnnotations);
    }

    public static SchemaBinding bind(InputStream xsdStream, String encoding, SchemaBindingResolver resolver) {
        return XsdBinder.bind(xsdStream, encoding, resolver, true);
    }

    public static SchemaBinding bind(InputStream xsdStream, String encoding, SchemaBindingResolver resolver, boolean processAnnotations) {
        XSModel model = Util.loadSchema(xsdStream, encoding, resolver);
        return XsdBinder.bind(model, resolver, processAnnotations);
    }

    public static SchemaBinding bind(Reader xsdReader, String encoding) {
        return XsdBinder.bind(xsdReader, encoding, (SchemaBindingResolver)new DefaultSchemaResolver());
    }

    public static SchemaBinding bind(Reader xsdReader, String encoding, String baseURI) {
        DefaultSchemaResolver resolver = new DefaultSchemaResolver();
        resolver.setBaseURI(baseURI);
        return XsdBinder.bind(xsdReader, encoding, (SchemaBindingResolver)resolver);
    }

    public static SchemaBinding bind(Reader xsdReader, String encoding, SchemaBindingResolver resolver) {
        XSModel model = Util.loadSchema(xsdReader, encoding, resolver);
        return XsdBinder.bind(model, resolver);
    }

    public static SchemaBinding bind(String xsd, String encoding) {
        return XsdBinder.bind(xsd, encoding, (SchemaBindingResolver)new DefaultSchemaResolver());
    }

    public static SchemaBinding bind(String xsd, String encoding, SchemaBindingResolver resolver) {
        XSModel model = Util.loadSchema(xsd, encoding);
        return XsdBinder.bind(model, resolver);
    }

    public static SchemaBinding bind(XSModel model, SchemaBindingResolver resolver) {
        return XsdBinder.bind(model, resolver, true);
    }

    public static SchemaBinding bind(XSModel model, SchemaBindingResolver resolver, boolean processAnnotations) {
        boolean trace = log.isTraceEnabled();
        SchemaBinding schema = XsdBinder.getXsdBinding().schemaBinding;
        schema.setSchemaResolver(resolver);
        if (processAnnotations) {
            XSObjectList annotations = model.getAnnotations();
            if (trace) {
                log.trace((Object)("started binding schema " + schema));
                log.trace((Object)("Schema annotations: " + annotations.getLength()));
            }
            for (int i = 0; i < annotations.getLength(); ++i) {
                SchemaMetaData schemaBindings;
                XSAnnotation annotation = (XSAnnotation)annotations.item(i);
                XsdAnnotation an = XsdAnnotation.unmarshal(annotation.getAnnotationString());
                XsdAppInfo appinfo = an.getAppInfo();
                if (appinfo == null || (schemaBindings = appinfo.getSchemaMetaData()) == null) continue;
                schema.setIgnoreUnresolvedFieldOrClass(schemaBindings.isIgnoreUnresolvedFieldOrClass());
                schema.setReplacePropertyRefs(schemaBindings.isReplacePropertyRefs());
                PackageMetaData packageMetaData = schemaBindings.getPackage();
                if (packageMetaData == null) continue;
                if (trace) {
                    log.trace((Object)("schema default package: " + packageMetaData.getName()));
                }
                schema.setPackageMetaData(packageMetaData);
            }
        }
        SharedElements sharedElements = new SharedElements();
        XSNamedMap groups = model.getComponents((short)6);
        if (trace) {
            log.trace((Object)("Model groups: " + groups.getLength()));
        }
        for (int i = 0; i < groups.getLength(); ++i) {
            XSModelGroupDefinition groupDef = (XSModelGroupDefinition)groups.item(i);
            XsdBinder.bindGlobalGroup(groupDef.getModelGroup(), sharedElements);
        }
        XSNamedMap types = model.getComponents((short)3);
        if (trace) {
            log.trace((Object)("Model types: " + types.getLength()));
        }
        for (int i = 0; i < types.getLength(); ++i) {
            XSTypeDefinition type = (XSTypeDefinition)types.item(i);
            if ("http://www.w3.org/2001/XMLSchema".equals(type.getNamespace())) continue;
            XsdBinder.bindType(schema, type, sharedElements, processAnnotations);
        }
        XSNamedMap elements = model.getComponents((short)2);
        if (trace) {
            log.trace((Object)("Model elements: " + types.getLength()));
        }
        for (int i = 0; i < elements.getLength(); ++i) {
            XSElementDeclaration element = (XSElementDeclaration)elements.item(i);
            XsdBinder.bindElement(schema, element, sharedElements, 1, 0, false, processAnnotations);
        }
        if (trace) {
            log.trace((Object)("finished binding schema " + schema));
        }
        xsdBinding.set(null);
        return schema;
    }

    public static void bindType(SchemaBinding schema, XSTypeDefinition type) {
        TypeBinding typeBinding = XsdBinder.bindType(schema, type, new SharedElements(), true);
        schema.addType(typeBinding);
    }

    public static void bindElement(SchemaBinding schema, XSElementDeclaration element, int minOccurs, int maxOccurs, boolean maxOccursUnbounded) {
        ParticleBinding particle = XsdBinder.bindElement(schema, element, new SharedElements(), minOccurs, maxOccurs, maxOccursUnbounded, true);
        schema.addElementParticle(particle);
    }

    /*
     * WARNING - void declaration
     */
    private static TypeBinding bindType(SchemaBinding doc, XSTypeDefinition type, SharedElements sharedElements, boolean processAnnotations) {
        void var4_4;
        switch (type.getTypeCategory()) {
            case 16: {
                TypeBinding binding = XsdBinder.bindSimpleType(doc, (XSSimpleTypeDefinition)type, processAnnotations);
                break;
            }
            case 15: {
                TypeBinding binding = XsdBinder.bindComplexType(doc, (XSComplexTypeDefinition)type, sharedElements, processAnnotations);
                break;
            }
            default: {
                throw new JBossXBRuntimeException("Unexpected type category: " + type.getTypeCategory());
            }
        }
        return var4_4;
    }

    private static TypeBinding bindSimpleType(SchemaBinding schema, XSSimpleTypeDefinition type, boolean processAnnotations) {
        TypeBinding binding;
        boolean trace = log.isTraceEnabled();
        QName typeName = type.getName() == null ? null : new QName(type.getNamespace(), type.getName());
        TypeBinding typeBinding = binding = typeName == null ? null : schema.getType(typeName);
        if (binding == null) {
            XSObjectList annotations;
            int i;
            XSTypeDefinition baseTypeDef;
            if (trace) {
                log.trace((Object)("binding simple type " + typeName));
            }
            TypeBinding baseType = (baseTypeDef = type.getBaseType()) == null ? null : XsdBinder.bindType(schema, baseTypeDef, null, processAnnotations);
            binding = baseType == null ? new TypeBinding(typeName) : new TypeBinding(typeName, baseType);
            StringList strList = type.getLexicalPattern();
            if (strList != null && strList.getLength() > 0) {
                for (i = 0; i < strList.getLength(); ++i) {
                    binding.addLexicalPattern(strList.item(i));
                }
            }
            if ((strList = type.getLexicalEnumeration()) != null && strList.getLength() > 0) {
                for (i = 0; i < strList.getLength(); ++i) {
                    binding.addEnumValue(strList.item(i));
                }
            }
            if (type.getItemType() != null) {
                TypeBinding itemType = XsdBinder.bindSimpleType(schema, type.getItemType(), processAnnotations);
                binding.setItemType(itemType);
            }
            if (typeName != null) {
                schema.addType(binding);
            }
            if (trace) {
                String msg;
                String string = msg = typeName == null ? "bound simple anonymous type" : "bound simple type " + typeName;
                if (baseType != null) {
                    msg = msg + " inherited binding metadata from " + baseType.getQName();
                }
                log.trace((Object)msg);
            }
            if (processAnnotations && (annotations = type.getAnnotations()) != null) {
                if (trace) {
                    log.trace((Object)(typeName + " annotations " + annotations.getLength()));
                }
                for (int i2 = 0; i2 < annotations.getLength(); ++i2) {
                    ValueMetaData valueMetaData;
                    XSAnnotation an = (XSAnnotation)annotations.item(i2);
                    XsdAnnotation xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString());
                    XsdAppInfo appInfo = xsdAn.getAppInfo();
                    if (appInfo == null) continue;
                    ClassMetaData classMetaData = appInfo.getClassMetaData();
                    if (classMetaData != null) {
                        if (trace) {
                            log.trace((Object)("simple type " + type.getName() + ": impl=" + classMetaData.getImpl()));
                        }
                        binding.setClassMetaData(classMetaData);
                    }
                    if ((valueMetaData = appInfo.getValueMetaData()) == null) continue;
                    if (trace) {
                        log.trace((Object)("simple type " + type.getName() + ": unmarshalMethod=" + valueMetaData.getUnmarshalMethod() + ", marshalMethod=" + valueMetaData.getMarshalMethod()));
                    }
                    binding.setValueMetaData(valueMetaData);
                }
            }
            binding.setSchemaBinding(schema);
        }
        return binding;
    }

    private static TypeBinding bindComplexType(SchemaBinding schema, XSComplexTypeDefinition type, SharedElements sharedElements, boolean processAnnotations) {
        XSParticle particle;
        XSObjectList annotations;
        TypeBinding binding;
        boolean trace = log.isTraceEnabled();
        QName typeName = type.getName() == null ? null : new QName(type.getNamespace(), type.getName());
        TypeBinding typeBinding = binding = typeName == null ? null : schema.getType(typeName);
        if (binding != null) {
            return binding;
        }
        if (trace) {
            log.trace((Object)("binding complex type " + typeName));
        }
        binding = new TypeBinding(typeName);
        binding.setStartElementCreatesObject(true);
        binding.setSimple(false);
        if (type.getSimpleType() != null) {
            TypeBinding simpleType = XsdBinder.bindSimpleType(schema, type.getSimpleType(), processAnnotations);
            binding.setSimpleType(simpleType);
        } else if (type.getContentType() == 3) {
            TypeBinding stringType = schema.getType(Constants.QNAME_STRING);
            if (stringType == null) {
                throw new JBossXBRuntimeException("xsd:string has not been bound yet!");
            }
            binding.setSimpleType(stringType);
        }
        if (typeName != null) {
            schema.addType(binding);
        }
        if (trace) {
            String msg = typeName == null ? "bound complex anonymous type" : "bound complex type " + typeName;
            log.trace((Object)msg);
        }
        binding.setSchemaBinding(schema);
        XSObjectList attrs = type.getAttributeUses();
        if (trace) {
            log.trace((Object)(typeName + " attributes " + attrs.getLength()));
        }
        for (int i = 0; i < attrs.getLength(); ++i) {
            XSAttributeUse attr = (XSAttributeUse)attrs.item(i);
            XsdBinder.bindAttributes(schema, binding, attr, processAnnotations);
        }
        if (processAnnotations && (annotations = type.getAnnotations()) != null) {
            if (trace) {
                log.trace((Object)(typeName + " annotations " + annotations.getLength()));
            }
            for (int i = 0; i < annotations.getLength(); ++i) {
                AddMethodMetaData addMethodMetaData;
                PropertyMetaData propertyMetaData;
                boolean skip;
                MapEntryMetaData mapEntryMetaData;
                CharactersMetaData charactersMetaData;
                XSAnnotation an = (XSAnnotation)annotations.item(i);
                XsdAnnotation xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString());
                XsdAppInfo appInfo = xsdAn.getAppInfo();
                if (appInfo == null) continue;
                ClassMetaData classMetaData = appInfo.getClassMetaData();
                if (classMetaData != null) {
                    if (trace) {
                        log.trace((Object)("complex type " + type.getName() + ": impl=" + classMetaData.getImpl()));
                    }
                    binding.setClassMetaData(classMetaData);
                }
                if ((charactersMetaData = appInfo.getCharactersMetaData()) != null) {
                    if (trace) {
                        boolean mapEntryValue;
                        boolean mapEntryKey;
                        ValueMetaData valueMetaData;
                        PropertyMetaData propertyMetaData2 = charactersMetaData.getProperty();
                        if (propertyMetaData2 != null) {
                            log.trace((Object)("complex type " + type.getName() + ": characters bound to " + propertyMetaData2.getName()));
                        }
                        if ((valueMetaData = charactersMetaData.getValue()) != null) {
                            log.trace((Object)("complex type " + type.getName() + ": characters unmarshalMethod=" + valueMetaData.getUnmarshalMethod() + ", marshalMethod=" + valueMetaData.getMarshalMethod()));
                        }
                        if (mapEntryKey = appInfo.isMapEntryKey()) {
                            log.trace((Object)("complex type " + type.getName() + ": characters are bound as a key in a map entry"));
                        }
                        if (mapEntryValue = appInfo.isMapEntryValue()) {
                            log.trace((Object)("complex type " + type.getName() + ": characters are bound as a value in a map entry"));
                        }
                    }
                    binding.setCharactersMetaData(charactersMetaData);
                }
                if ((mapEntryMetaData = appInfo.getMapEntryMetaData()) != null) {
                    if (trace) {
                        log.trace((Object)("complex type " + type.getName() + " is bound to a map entry: impl=" + mapEntryMetaData.getImpl() + ", getKeyMethod=" + mapEntryMetaData.getGetKeyMethod() + ", setKeyMethod=" + mapEntryMetaData.getSetKeyMethod() + ", getValueMethod=" + mapEntryMetaData.getGetValueMethod() + ", setValueMethod=" + mapEntryMetaData.getSetValueMethod() + ", valueType=" + mapEntryMetaData.getValueType() + ", nonNullValue=" + mapEntryMetaData.isNonNullValue()));
                    }
                    if (classMetaData != null) {
                        throw new JBossXBRuntimeException("Illegal binding: both jbxb:class and jbxb:mapEntry are specified for complex type " + type.getName());
                    }
                    binding.setMapEntryMetaData(mapEntryMetaData);
                }
                if (skip = appInfo.isSkip()) {
                    if (trace) {
                        log.trace((Object)("complex type " + type.getName() + ": elements of this type will be skipped; their attrs, character content " + "and elements will be set the parent."));
                    }
                    binding.setSkip(skip);
                }
                if ((propertyMetaData = appInfo.getPropertyMetaData()) != null) {
                    if (trace) {
                        log.trace((Object)("complex type " + type.getName() + ": the content of elements of this type is bound to property " + propertyMetaData.getName()));
                    }
                    binding.setPropertyMetaData(propertyMetaData);
                }
                if ((addMethodMetaData = appInfo.getAddMethodMetaData()) == null) continue;
                if (trace) {
                    log.trace((Object)("complex type " + type.getName() + ": elements of this type will be added to parent objects with addMethod=" + addMethodMetaData.getMethodName() + ", valueType=" + addMethodMetaData.getValueType()));
                }
                binding.setAddMethodMetaData(addMethodMetaData);
            }
        }
        if ((particle = type.getParticle()) != null) {
            XsdBinder.pushType(binding);
            XsdBinder.bindParticle(schema, particle, sharedElements, processAnnotations);
            XsdBinder.popType();
        }
        return binding;
    }

    private static void bindAttributes(SchemaBinding doc, TypeBinding type, XSAttributeUse attrUse, boolean processAnnotations) {
        XSAnnotation an;
        boolean trace = log.isTraceEnabled();
        XSAttributeDeclaration attr = attrUse.getAttrDeclaration();
        QName attrName = new QName(attr.getNamespace(), attr.getName());
        if (trace) {
            log.trace((Object)("binding attribute " + attrName + " for " + type.getQName() + ", required=" + attrUse.getRequired()));
        }
        XSSimpleTypeDefinition attrType = attr.getTypeDefinition();
        TypeBinding typeBinding = XsdBinder.bindSimpleType(doc, attrType, processAnnotations);
        AttributeBinding binding = type.addAttribute(attrName, typeBinding, DefaultHandlers.ATTRIBUTE_HANDLER);
        binding.setRequired(attrUse.getRequired());
        if (attrUse.getConstraintType() == 1) {
            binding.setDefaultConstraint(attrUse.getConstraintValue());
        }
        if (processAnnotations && (an = attr.getAnnotation()) != null) {
            XsdAnnotation xsdAn;
            XsdAppInfo appInfo;
            if (trace) {
                log.trace((Object)(attrName + " attribute annotation"));
            }
            if ((appInfo = (xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString())).getAppInfo()) != null) {
                boolean mapEntryValue;
                boolean mapEntryKey;
                PropertyMetaData propertyMetaData = appInfo.getPropertyMetaData();
                if (propertyMetaData != null) {
                    binding.setPropertyMetaData(propertyMetaData);
                }
                if (mapEntryKey = appInfo.isMapEntryKey()) {
                    binding.setMapEntryKey(mapEntryKey);
                }
                if (mapEntryValue = appInfo.isMapEntryValue()) {
                    binding.setMapEntryValue(mapEntryValue);
                }
            }
        }
        if (trace) {
            String msg = "bound attribute " + attrName;
            msg = binding.getPropertyMetaData() != null ? msg + " property=" + binding.getPropertyMetaData().getName() + ", collectionType=" + binding.getPropertyMetaData().getCollectionType() : (binding.isMapEntryKey() ? msg + "bound as a key in a map entry" : (binding.isMapEntryValue() ? msg + "bound as a value in a map entry" : msg + " type=" + attrType.getName() + ", owner type=" + type.getQName()));
            if (binding.getDefaultConstraint() != null) {
                msg = msg + ", default=" + binding.getDefaultConstraint();
            }
            log.trace((Object)msg);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void bindParticle(SchemaBinding schema, XSParticle particle, SharedElements sharedElements, boolean processAnnotations) {
        boolean trace = log.isTraceEnabled();
        XSTerm term = particle.getTerm();
        switch (term.getType()) {
            case 7: {
                Object o;
                XSAnnotation annotation;
                void var7_7;
                XSModelGroup modelGroup = (XSModelGroup)term;
                if (modelGroup.getParticles().getLength() <= 0) break;
                switch (modelGroup.getCompositor()) {
                    case 3: {
                        ModelGroupBinding groupBinding = new AllBinding(schema);
                        break;
                    }
                    case 2: {
                        ModelGroupBinding groupBinding = new ChoiceBinding(schema);
                        break;
                    }
                    case 1: {
                        ModelGroupBinding groupBinding = new SequenceBinding(schema);
                        break;
                    }
                    default: {
                        throw new JBossXBRuntimeException("Unexpected model group: " + modelGroup.getCompositor());
                    }
                }
                ParticleBinding particleBinding = new ParticleBinding((TermBinding)var7_7);
                particleBinding.setMaxOccursUnbounded(particle.getMaxOccursUnbounded());
                particleBinding.setMinOccurs(particle.getMinOccurs());
                particleBinding.setMaxOccurs(particle.getMaxOccurs());
                if (trace) {
                    log.trace((Object)("created model group " + var7_7));
                }
                if (processAnnotations && (annotation = modelGroup.getAnnotation()) != null) {
                    XsdBinder.customizeTerm(annotation, (TermBinding)var7_7);
                }
                if ((o = XsdBinder.peekTypeOrGroup()) instanceof ModelGroupBinding) {
                    ModelGroupBinding parentGroup = (ModelGroupBinding)o;
                    parentGroup.addParticle(particleBinding);
                    if (trace) {
                        log.trace((Object)("added " + var7_7 + " to " + parentGroup));
                    }
                } else if (o instanceof TypeBinding) {
                    TypeBinding typeBinding = (TypeBinding)o;
                    typeBinding.setParticle(particleBinding);
                    if (trace) {
                        log.trace((Object)("added " + var7_7 + " to type " + typeBinding.getQName()));
                    }
                }
                XsdBinder.pushModelGroup((ModelGroupBinding)var7_7);
                XsdBinder.bindModelGroup(schema, modelGroup, sharedElements, processAnnotations);
                XsdBinder.popModelGroup();
                break;
            }
            case 9: {
                XsdBinder.bindWildcard(schema, particle, processAnnotations);
                break;
            }
            case 2: {
                XsdBinder.bindElement(schema, (XSElementDeclaration)term, sharedElements, particle.getMinOccurs(), particle.getMaxOccurs(), particle.getMaxOccursUnbounded(), processAnnotations);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected term type: " + term.getType());
            }
        }
    }

    private static void bindWildcard(SchemaBinding schema, XSParticle particle, boolean processAnnotations) {
        XSAnnotation annotation;
        XSWildcard wildcard;
        boolean trace = log.isTraceEnabled();
        WildcardBinding binding = new WildcardBinding(schema);
        ModelGroupBinding group = (ModelGroupBinding)XsdBinder.peekTypeOrGroup();
        ParticleBinding particleBinding = new ParticleBinding(binding);
        particleBinding.setMaxOccurs(particle.getMaxOccurs());
        particleBinding.setMaxOccursUnbounded(particle.getMaxOccursUnbounded());
        particleBinding.setMinOccurs(particle.getMinOccurs());
        group.addParticle(particleBinding);
        TypeBinding type = XsdBinder.peekType();
        type.setWildcard(binding);
        if (trace) {
            log.trace((Object)("added wildcard to " + group));
            log.trace((Object)("added wildcard to type " + type.getQName()));
        }
        if ((wildcard = (XSWildcard)particle.getTerm()).getName() != null) {
            binding.setQName(new QName(wildcard.getNamespace(), wildcard.getName()));
        }
        binding.setProcessContents(wildcard.getProcessContents());
        if (processAnnotations && (annotation = wildcard.getAnnotation()) != null) {
            XsdBinder.customizeTerm(annotation, binding);
        }
    }

    private static ParticleBinding bindElement(SchemaBinding schema, XSElementDeclaration elementDec, SharedElements sharedElements, int minOccurs, int maxOccurs, boolean maxOccursUnbounded, boolean processAnnotations) {
        XSAnnotation an;
        boolean trace = log.isTraceEnabled();
        QName qName = new QName(elementDec.getNamespace(), elementDec.getName());
        ModelGroupBinding parentGroup = (ModelGroupBinding)XsdBinder.peekTypeOrGroup();
        boolean global = elementDec.getScope() == 1;
        ElementBinding element = schema.getElement(qName);
        if (global && element != null) {
            ParticleBinding particle = new ParticleBinding(element);
            if (parentGroup != null) {
                parentGroup.addParticle(particle);
            }
            particle.setMinOccurs(minOccurs);
            if (maxOccursUnbounded) {
                particle.setMaxOccursUnbounded(maxOccursUnbounded);
            } else {
                particle.setMaxOccurs(maxOccurs);
            }
            return particle;
        }
        TypeBinding type = null;
        boolean shared = sharedElements.isShared(elementDec);
        if (shared) {
            type = sharedElements.getTypeBinding(elementDec);
        }
        if (type == null) {
            type = XsdBinder.bindType(schema, elementDec.getTypeDefinition(), sharedElements, processAnnotations);
            if (shared) {
                sharedElements.setTypeBinding(elementDec, type);
            }
        }
        element = new ElementBinding(schema, qName, type);
        element.setNillable(elementDec.getNillable());
        ParticleBinding particle = new ParticleBinding(element);
        particle.setMinOccurs(minOccurs);
        particle.setMaxOccurs(maxOccurs);
        particle.setMaxOccursUnbounded(maxOccursUnbounded);
        if (global) {
            schema.addElementParticle(particle);
        }
        if (parentGroup != null) {
            parentGroup.addParticle(particle);
            if (trace) {
                log.trace((Object)("Element " + element.getQName() + " added to " + parentGroup));
            }
        }
        if (trace) {
            TypeBinding parentType = XsdBinder.peekType();
            log.trace((Object)("element: name=" + qName + ", type=" + type.getQName() + ", repeatable=" + particle.isRepeatable() + ", nillable=" + element.isNillable() + ", minOccurs=" + minOccurs + ", maxOccurs=" + (maxOccursUnbounded ? "unbounded" : "" + maxOccurs) + ", " + (global ? "global scope" : " owner type=" + parentType.getQName())));
        }
        if (processAnnotations && (an = elementDec.getAnnotation()) != null) {
            XsdBinder.customizeTerm(an, element);
        }
        return particle;
    }

    private static void bindModelGroup(SchemaBinding doc, XSModelGroup modelGroup, SharedElements sharedElements, boolean processAnnotations) {
        XSObjectList particles = modelGroup.getParticles();
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            XsdBinder.bindParticle(doc, particle, sharedElements, processAnnotations);
        }
    }

    private static void customizeTerm(XSAnnotation an, TermBinding term) {
        XsdAnnotation xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString());
        XsdAppInfo appInfo = xsdAn.getAppInfo();
        if (appInfo != null) {
            boolean mapEntryValue;
            boolean mapEntryKey;
            ValueMetaData valueMetaData;
            AddMethodMetaData addMethodMetaData;
            PutMethodMetaData putMethodMetaData;
            MapEntryMetaData mapEntryMetaData;
            PropertyMetaData propertyMetaData;
            boolean trace = log.isTraceEnabled();
            Boolean skip = null;
            ClassMetaData classMetaData = appInfo.getClassMetaData();
            if (classMetaData != null) {
                if (trace) {
                    String msg = term.isModelGroup() ? term + " bound to " : (term.isWildcard() ? " wildcard bound to " : "element: name=" + ((ElementBinding)term).getQName() + ", class=");
                    msg = msg + classMetaData.getImpl();
                    log.trace((Object)msg);
                }
                term.setClassMetaData(classMetaData);
                skip = Boolean.FALSE;
            }
            if ((propertyMetaData = appInfo.getPropertyMetaData()) != null) {
                if (trace) {
                    String msg = term.isWildcard() || term.isModelGroup() ? term + " " : "element: name=" + ((ElementBinding)term).getQName() + ", ";
                    msg = msg + " property=" + propertyMetaData.getName() + ", collectionType=" + propertyMetaData.getCollectionType();
                    log.trace((Object)msg);
                }
                term.setPropertyMetaData(propertyMetaData);
            }
            if ((mapEntryMetaData = appInfo.getMapEntryMetaData()) != null) {
                String msg;
                if (propertyMetaData != null) {
                    String msg2 = "A term can be bound either as a property or as a map entry but not both: " + (term.isModelGroup() ? term.toString() : ((ElementBinding)term).getQName().toString());
                    throw new JBossXBRuntimeException(msg2);
                }
                if (trace) {
                    msg = term.isWildcard() || term.isModelGroup() ? term.toString() : "element name=" + ((ElementBinding)term).getQName();
                    msg = msg + " is bound to a map entry: impl=" + mapEntryMetaData.getImpl() + ", getKeyMethod=" + mapEntryMetaData.getGetKeyMethod() + ", setKeyMethod=" + mapEntryMetaData.getSetKeyMethod() + ", getValueMethod=" + mapEntryMetaData.getGetValueMethod() + ", setValueMethod=" + mapEntryMetaData.getSetValueMethod() + ", valueType=" + mapEntryMetaData.getValueType() + ", nonNullValue=" + mapEntryMetaData.isNonNullValue();
                    log.trace((Object)msg);
                }
                if (classMetaData != null) {
                    msg = "Invalid customization: both jbxb:class and jbxb:mapEntry are specified for term " + (term.isWildcard() || term.isModelGroup() ? term.toString() : ((ElementBinding)term).getQName().toString());
                    throw new JBossXBRuntimeException(msg);
                }
                term.setMapEntryMetaData(mapEntryMetaData);
                skip = Boolean.FALSE;
            }
            if ((putMethodMetaData = appInfo.getPutMethodMetaData()) != null) {
                if (trace) {
                    String msg = term.isWildcard() || term.isModelGroup() ? term.toString() : "element: name=" + ((ElementBinding)term).getQName() + ",";
                    msg = msg + " putMethod=" + putMethodMetaData.getName() + ", keyType=" + putMethodMetaData.getKeyType() + ", valueType=" + putMethodMetaData.getValueType();
                    log.trace((Object)msg);
                }
                term.setPutMethodMetaData(putMethodMetaData);
            }
            if ((addMethodMetaData = appInfo.getAddMethodMetaData()) != null) {
                if (trace) {
                    String msg = term.isWildcard() || term.isModelGroup() ? term.toString() : "element: name=" + ((ElementBinding)term).getQName() + ",";
                    msg = msg + " addMethod=" + addMethodMetaData.getMethodName() + ", valueType=" + addMethodMetaData.getValueType() + ", isChildType=" + addMethodMetaData.isChildType();
                    log.trace((Object)msg);
                }
                term.setAddMethodMetaData(addMethodMetaData);
            }
            if ((valueMetaData = appInfo.getValueMetaData()) != null) {
                if (trace) {
                    String msg = term.isWildcard() || term.isModelGroup() ? term.toString() : "element " + ((ElementBinding)term).getQName();
                    msg = msg + ": unmarshalMethod=" + valueMetaData.getUnmarshalMethod();
                    log.trace((Object)msg);
                }
                term.setValueMetaData(valueMetaData);
            }
            if (mapEntryKey = appInfo.isMapEntryKey()) {
                if (trace) {
                    String msg = term.isWildcard() || term.isModelGroup() ? term.toString() : "element name=" + ((ElementBinding)term).getQName();
                    msg = msg + ": is bound to a key in a map entry";
                    log.trace((Object)msg);
                }
                term.setMapEntryKey(mapEntryKey);
                skip = Boolean.FALSE;
            }
            if (mapEntryValue = appInfo.isMapEntryValue()) {
                if (trace) {
                    String msg = term.isWildcard() || term.isModelGroup() ? term.toString() : "element name=" + ((ElementBinding)term).getQName();
                    msg = msg + ": is bound to a value in a map entry";
                    log.trace((Object)msg);
                }
                term.setMapEntryValue(mapEntryValue);
                skip = Boolean.FALSE;
            }
            boolean skipAnnotation = appInfo.isSkip();
            if (skip != null) {
                term.setSkip(skip);
            } else if (skipAnnotation) {
                if (trace) {
                    String msg = term.isWildcard() || term.isModelGroup() ? term.toString() : "element name=" + ((ElementBinding)term).getQName();
                    msg = msg + ": will be skipped, it's attributes, character content and children will be set on the parent";
                    log.trace((Object)msg);
                }
                term.setSkip(skipAnnotation ? Boolean.TRUE : Boolean.FALSE);
            }
        }
    }

    private static void bindGlobalGroup(XSModelGroup group, SharedElements sharedElements) {
        XSObjectList particles = group.getParticles();
        block5: for (int j = 0; j < particles.getLength(); ++j) {
            XSParticle particle = (XSParticle)particles.item(j);
            XSTerm term = particle.getTerm();
            switch (term.getType()) {
                case 2: {
                    XSElementDeclaration element = (XSElementDeclaration)term;
                    sharedElements.add(element);
                    continue block5;
                }
                case 9: {
                    continue block5;
                }
                case 7: {
                    XsdBinder.bindGlobalGroup((XSModelGroup)term, sharedElements);
                }
            }
        }
    }

    private static void popType() {
        Object o = XsdBinder.getXsdBinding().typeGroupStack.removeLast();
        if (!(o instanceof TypeBinding)) {
            throw new JBossXBRuntimeException("Should have poped type binding but got " + o);
        }
    }

    private static void pushType(TypeBinding binding) {
        XsdBinder.getXsdBinding().typeGroupStack.addLast(binding);
    }

    private static void popModelGroup() {
        Object o = XsdBinder.getXsdBinding().typeGroupStack.removeLast();
        if (!(o instanceof ModelGroupBinding)) {
            throw new JBossXBRuntimeException("Should have poped model group binding but got " + o);
        }
    }

    private static void pushModelGroup(ModelGroupBinding binding) {
        XsdBinder.getXsdBinding().typeGroupStack.addLast(binding);
    }

    private static Object peekTypeOrGroup() {
        LinkedList stack = XsdBinder.getXsdBinding().typeGroupStack;
        return stack.isEmpty() ? null : stack.getLast();
    }

    private static TypeBinding peekType() {
        LinkedList stack = XsdBinder.getXsdBinding().typeGroupStack;
        TypeBinding binding = null;
        for (int i = stack.size() - 1; i >= 0; --i) {
            Object o = stack.get(i);
            if (!(o instanceof TypeBinding)) continue;
            binding = (TypeBinding)o;
            break;
        }
        return binding;
    }

    private static final class XsdBinding {
        public final LinkedList typeGroupStack = new LinkedList();
        public final SchemaBinding schemaBinding = new SchemaBinding();

        private XsdBinding() {
        }
    }

    private static final class SharedElements {
        private Map elements = Collections.EMPTY_MAP;

        private SharedElements() {
        }

        public void add(XSElementDeclaration element) {
            switch (this.elements.size()) {
                case 0: {
                    this.elements = Collections.singletonMap(element, null);
                    break;
                }
                case 1: {
                    this.elements = new HashMap(this.elements);
                }
                default: {
                    this.elements.put(element, null);
                }
            }
        }

        public boolean isShared(XSElementDeclaration element) {
            return this.elements.containsKey(element);
        }

        public TypeBinding getTypeBinding(XSElementDeclaration element) {
            return (TypeBinding)this.elements.get(element);
        }

        public void setTypeBinding(XSElementDeclaration element, TypeBinding type) {
            switch (this.elements.size()) {
                case 0: {
                    this.elements = Collections.singletonMap(element, type);
                    break;
                }
                case 1: {
                    this.elements = new HashMap(this.elements);
                }
                default: {
                    this.elements.put(element, type);
                }
            }
        }
    }
}

