/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SequenceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.xml.sax.Attributes;

public class WildcardBinding
extends TermBinding {
    private static final Logger log = Logger.getLogger((Class)WildcardBinding.class);
    private static final short PC_LAX = 3;
    private static final short PC_SKIP = 2;
    private static final short PC_STRICT = 1;
    private QName qName;
    private SchemaBindingResolver schemaResolver;
    private short pc;
    private ParticleHandler unresolvedElementHandler;
    private CharactersHandler unresolvedCharactersHandler;
    private ParticleHandler wildcardHandler;

    public WildcardBinding(SchemaBinding schema) {
        super(schema);
    }

    public QName getQName() {
        return this.qName;
    }

    public void setQName(QName qName) {
        this.qName = qName;
    }

    public SchemaBindingResolver getSchemaResolver() {
        return this.schemaResolver;
    }

    public void setSchemaResolver(SchemaBindingResolver schemaResolver) {
        this.schemaResolver = schemaResolver;
    }

    public short getProcessContents() {
        return this.pc;
    }

    public void setProcessContents(short pc) {
        this.pc = pc;
        if (pc != 3 && pc != 2 && pc != 1) {
            throw new JBossXBRuntimeException("Unexpected value for process contents: " + pc);
        }
    }

    public boolean isProcessContentsLax() {
        return this.pc == 3;
    }

    public boolean isProcessContentsSkip() {
        return this.pc == 2;
    }

    public boolean isProcessContentsStrict() {
        return this.pc == 1;
    }

    public void setWildcardHandler(ParticleHandler wildcardHandler) {
        this.wildcardHandler = wildcardHandler;
    }

    public ParticleHandler getWildcardHandler() {
        return this.wildcardHandler;
    }

    public ParticleHandler getUnresolvedElementHandler() {
        return this.unresolvedElementHandler;
    }

    public void setUnresolvedElementHandler(ParticleHandler unresolvedElementHandler) {
        this.unresolvedElementHandler = unresolvedElementHandler;
    }

    public CharactersHandler getUnresolvedCharactersHandler() {
        return this.unresolvedCharactersHandler;
    }

    public void setUnresolvedCharactersHandler(CharactersHandler unresolvedCharactersHandler) {
        this.unresolvedCharactersHandler = unresolvedCharactersHandler;
    }

    public ElementBinding getElement(QName qName, Attributes attrs) {
        if (this.pc == 2) {
            return this.getUnresolvedElement(qName, false);
        }
        ElementBinding element = null;
        if (this.schema != null) {
            element = this.schema.getElement(qName);
        }
        if (element == null) {
            SchemaBindingResolver resolver = this.schemaResolver;
            if (resolver == null && this.schema != null) {
                resolver = this.schema.getSchemaResolver();
            }
            if (resolver != null) {
                String schemaLocation = attrs == null ? null : Util.getSchemaLocation(attrs, qName.getNamespaceURI());
                SchemaBinding schema = resolver.resolve(qName.getNamespaceURI(), null, schemaLocation);
                if (schema != null) {
                    element = schema.getElement(qName);
                }
            }
        }
        if (element == null && this.pc == 3) {
            element = this.getUnresolvedElement(qName, false);
        }
        return element;
    }

    private ElementBinding getUnresolvedElement(QName qName, boolean required) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("getUnresolvedElement for " + qName + ", required=" + required + ", unresolvedElementHandler=" + this.unresolvedElementHandler));
        }
        if (this.unresolvedElementHandler == null) {
            if (required) {
                throw new JBossXBRuntimeException("Schema could not be resolved for wildcard content element " + qName + " and particle handler for unresolved wildcard content elements is not initialized.");
            }
            ParticleBinding particle = new ParticleBinding(this);
            SequenceBinding sequence = new SequenceBinding(this.schema);
            sequence.addParticle(particle);
            TypeBinding type = new TypeBinding();
            type.setParticle(new ParticleBinding(sequence));
            ElementBinding element = new ElementBinding(this.schema, qName, type);
            element.setSkip(Boolean.TRUE);
            return element;
        }
        ParticleBinding particle = new ParticleBinding(this);
        SequenceBinding sequence = new SequenceBinding(this.schema);
        sequence.addParticle(particle);
        TypeBinding type = new TypeBinding();
        type.setHandler(this.unresolvedElementHandler);
        type.setSimpleType(this.unresolvedCharactersHandler);
        type.setParticle(new ParticleBinding(sequence));
        return new ElementBinding(this.schema, qName, type);
    }

    public boolean isSkip() {
        return this.skip == null ? false : this.skip;
    }

    public boolean isModelGroup() {
        return false;
    }

    public boolean isWildcard() {
        return true;
    }
}

