/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.logging.Logger;
import org.jboss.util.Classes;
import org.jboss.xb.binding.Content;
import org.jboss.xb.binding.DelegatingObjectModelProvider;
import org.jboss.xb.binding.GenericObjectModelProvider;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.Marshaller;
import org.jboss.xb.binding.ObjectLocalMarshaller;
import org.jboss.xb.binding.ObjectModelProvider;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class AbstractMarshaller
implements Marshaller {
    protected static final Logger log = Logger.getLogger((Class)AbstractMarshaller.class);
    protected String version = "1.0";
    protected String encoding = "UTF-8";
    protected List rootQNames = new ArrayList();
    protected Map prefixByUri = Collections.EMPTY_MAP;
    private Map classMappings = Collections.EMPTY_MAP;
    protected Map field2WildcardMap = Collections.EMPTY_MAP;
    protected Map cls2TypeMap = Collections.EMPTY_MAP;
    protected Content content = new Content();
    private Properties props;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(String schemaUri, ObjectModelProvider provider, Object root, Writer writer) throws IOException, ParserConfigurationException, SAXException {
        InputStream is;
        URL url;
        try {
            url = new URL(schemaUri);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed schema URI " + schemaUri + ": " + e.getMessage());
        }
        try {
            is = url.openStream();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to open input stream for schema " + schemaUri + ": " + e.getMessage());
        }
        try {
            InputStreamReader reader = new InputStreamReader(is);
            this.marshal(reader, provider, root, writer);
        }
        finally {
            is.close();
        }
    }

    public void mapClassToGlobalElement(Class cls, String localName, String namespaceUri, String schemaUrl, ObjectModelProvider provider) {
        GenericObjectModelProvider delProv = null;
        if (provider != null) {
            delProv = provider instanceof GenericObjectModelProvider ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider);
        }
        ClassMapping mapping = new ClassMapping(cls, localName, null, namespaceUri, schemaUrl, delProv);
        this.addClassMapping(mapping);
    }

    public void mapClassToGlobalType(Class cls, String localName, String nsUri, String schemaUrl, ObjectModelProvider provider) {
        ClassMapping mapping = new ClassMapping(cls, null, localName, nsUri, schemaUrl, provider instanceof GenericObjectModelProvider ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider));
        this.addClassMapping(mapping);
    }

    public void mapFieldToWildcard(Class cls, String field, ObjectLocalMarshaller marshaller) {
        FieldToWildcardMapping mapping = new FieldToWildcardMapping(cls, field, marshaller);
        switch (this.field2WildcardMap.size()) {
            case 0: {
                this.field2WildcardMap = Collections.singletonMap(cls, mapping);
                break;
            }
            case 1: {
                this.field2WildcardMap = new HashMap(this.field2WildcardMap);
            }
            default: {
                this.field2WildcardMap.put(cls, mapping);
            }
        }
    }

    public void mapClassToXsiType(Class cls, String typeNs, String typeLocalPart) {
        QName typeQName = new QName(typeNs, typeLocalPart);
        switch (this.cls2TypeMap.size()) {
            case 0: {
                this.cls2TypeMap = Collections.singletonMap(cls, typeQName);
                break;
            }
            case 1: {
                this.cls2TypeMap = new HashMap(this.cls2TypeMap);
            }
            default: {
                this.cls2TypeMap.put(cls, typeQName);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("mapped " + cls + " to xsi:type " + typeQName));
        }
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void mapPublicIdToSystemId(String publicId, String systemId) {
        throw new UnsupportedOperationException();
    }

    public void addRootElement(String namespaceUri, String prefix, String name) {
        this.addRootElement(new QName(namespaceUri, name, prefix));
    }

    public void addRootElement(QName qName) {
        this.rootQNames.add(qName);
    }

    public void setProperty(String name, String value) {
        if (this.props == null) {
            this.props = new Properties();
        }
        this.props.setProperty(name, value);
    }

    public String getProperty(String name) {
        return this.props == null ? null : this.props.getProperty(name);
    }

    public void declareNamespace(String prefix, String uri) {
        if (prefix == null) {
            return;
        }
        switch (this.prefixByUri.size()) {
            case 0: {
                this.prefixByUri = Collections.singletonMap(uri, prefix);
                break;
            }
            case 1: {
                this.prefixByUri = new HashMap(this.prefixByUri);
            }
            default: {
                this.prefixByUri.put(uri, prefix);
            }
        }
    }

    public void removeNamespace(String uri) {
        if (this.prefixByUri.size() > 1) {
            this.prefixByUri.remove(uri);
        } else if (this.prefixByUri.containsKey(uri)) {
            this.prefixByUri = Collections.EMPTY_MAP;
        }
    }

    public String getPrefix(String ns) {
        String prefix = (String)this.prefixByUri.get(ns);
        if (prefix == null && "http://www.w3.org/XML/1998/namespace".equals(ns)) {
            prefix = "xml";
        }
        return prefix;
    }

    public abstract void addAttribute(String var1, String var2, String var3, String var4);

    protected boolean propertyIsTrueOrNotSet(String name) {
        String value = this.getProperty(name);
        return value == null || "true".equalsIgnoreCase(value);
    }

    protected void writeXmlVersion(Writer writer) throws IOException {
        String xmlVersion = this.getProperty("org.jboss.xml.binding.marshalling.version");
        if (xmlVersion == null || "true".equalsIgnoreCase(xmlVersion)) {
            writer.write("<?xml version=\"");
            writer.write(this.version);
            writer.write("\" encoding=\"");
            writer.write(this.encoding);
            writer.write("\"?>\n");
        }
    }

    protected ClassMapping getClassMapping(Class cls) {
        return (ClassMapping)this.classMappings.get(cls);
    }

    private void addClassMapping(ClassMapping mapping) {
        if (this.classMappings == Collections.EMPTY_MAP) {
            this.classMappings = new HashMap();
        }
        this.classMappings.put(mapping.cls, mapping);
    }

    static Object provideChildren(ObjectModelProvider provider, Object parent, String namespaceUri, String name) {
        Class<?> providerClass = provider.getClass();
        Class<?> parentClass = parent.getClass();
        String methodName = "getChildren";
        Object container = null;
        Method method = AbstractMarshaller.getProviderMethod(providerClass, methodName, new Class[]{parentClass, String.class, String.class});
        if (method != null) {
            try {
                container = method.invoke((Object)provider, parent, namespaceUri, name);
            }
            catch (Exception e) {
                log.error((Object)("Failed to invoke method " + methodName), (Throwable)e);
                throw new IllegalStateException("Failed to invoke method " + methodName);
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("No " + methodName + " for " + name));
        }
        return container;
    }

    static Object provideValue(ObjectModelProvider provider, Object parent, String namespaceUri, String name) {
        Class<?> providerClass = provider.getClass();
        Class<?> parentClass = parent.getClass();
        String methodName = "getElementValue";
        Object value = null;
        Method method = AbstractMarshaller.getProviderMethod(providerClass, methodName, new Class[]{parentClass, String.class, String.class});
        if (method != null) {
            try {
                value = method.invoke((Object)provider, parent, namespaceUri, name);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to invoke method " + methodName);
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("No " + methodName + " for " + name));
        }
        return value;
    }

    static Object provideAttributeValue(ObjectModelProvider provider, Object object, String namespaceUri, String name) {
        Class<?> providerClass = provider.getClass();
        Class<?> objectClass = object.getClass();
        String methodName = "getAttributeValue";
        Object value = null;
        Method method = AbstractMarshaller.getProviderMethod(providerClass, methodName, new Class[]{objectClass, String.class, String.class});
        if (method != null) {
            try {
                value = method.invoke((Object)provider, object, namespaceUri, name);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to invoke method " + methodName);
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("No " + methodName + " for " + name));
        }
        return value;
    }

    private static Method getProviderMethod(Class providerClass, String methodName, Class[] args) {
        Method method = null;
        try {
            method = providerClass.getMethod(methodName, args);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return method;
    }

    public class ContentHandlerAdaptor
    implements ContentHandler {
        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            AbstractMarshaller.this.content.startPrefixMapping(prefix, uri);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            AbstractMarshaller.this.content.endPrefixMapping(prefix);
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            AbstractMarshaller.this.content.startElement(uri, localName, qName, atts);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            AbstractMarshaller.this.content.endElement(uri, localName, qName);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            AbstractMarshaller.this.content.characters(ch, start, length);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }
    }

    public static class StackImpl
    implements Stack {
        private LinkedList list = new LinkedList();

        public void clear() {
            this.list.clear();
        }

        public void push(Object o) {
            this.list.addLast(o);
        }

        public Object pop() {
            return this.list.removeLast();
        }

        public Object peek() {
            return this.list.getLast();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }
    }

    protected static interface Stack {
        public void clear();

        public void push(Object var1);

        public Object pop();

        public Object peek();

        public boolean isEmpty();
    }

    protected class FieldToWildcardMapping {
        public final Class cls;
        public final String fieldName;
        public final ObjectLocalMarshaller marshaller;
        public final Method getter;
        public final Field field;

        public FieldToWildcardMapping(Class cls, String field, ObjectLocalMarshaller marshaller) {
            this.cls = cls;
            this.fieldName = field;
            this.marshaller = marshaller;
            if (log.isTraceEnabled()) {
                log.trace((Object)("new FieldToWildcardMapping: [cls=" + cls.getName() + ",field=" + field + "]"));
            }
            Method localGetter = null;
            Field localField = null;
            try {
                localGetter = Classes.getAttributeGetter((Class)cls, (String)field);
            }
            catch (NoSuchMethodException e) {
                try {
                    localField = cls.getField(field);
                }
                catch (NoSuchFieldException e1) {
                    throw new JBossXBRuntimeException("Neither getter nor field where found for " + field + " in " + cls);
                }
            }
            this.getter = localGetter;
            this.field = localField;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldToWildcardMapping)) {
                return false;
            }
            FieldToWildcardMapping fieldToWildcardMapping = (FieldToWildcardMapping)o;
            if (!this.cls.equals(fieldToWildcardMapping.cls)) {
                return false;
            }
            return this.fieldName.equals(fieldToWildcardMapping.fieldName);
        }

        public int hashCode() {
            int result = this.cls.hashCode();
            result = 29 * result + this.fieldName.hashCode();
            return result;
        }
    }

    protected class ClassMapping {
        public final Class cls;
        public final QName elementName;
        public final QName typeName;
        public final String schemaUrl;
        public final GenericObjectModelProvider provider;

        public ClassMapping(Class cls, String elementName, String typeName, String nsUri, String schemaUrl, GenericObjectModelProvider provider) {
            this.cls = cls;
            if (elementName != null) {
                this.elementName = nsUri == null ? new QName(elementName) : new QName(nsUri, elementName);
                this.typeName = null;
            } else if (typeName != null) {
                this.elementName = null;
                this.typeName = nsUri == null ? new QName(typeName) : new QName(nsUri, typeName);
            } else {
                throw new JBossXBRuntimeException("Element or type name must not null for " + cls);
            }
            this.schemaUrl = schemaUrl;
            this.provider = provider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassMapping that = (ClassMapping)o;
            if (this.cls != null ? !this.cls.equals(that.cls) : that.cls != null) {
                return false;
            }
            if (this.elementName != null ? !this.elementName.equals(that.elementName) : that.elementName != null) {
                return false;
            }
            if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null) {
                return false;
            }
            if (this.schemaUrl != null ? !this.schemaUrl.equals(that.schemaUrl) : that.schemaUrl != null) {
                return false;
            }
            return !(this.typeName != null ? !this.typeName.equals(that.typeName) : that.typeName != null);
        }

        public int hashCode() {
            int result = this.cls != null ? this.cls.hashCode() : 0;
            result = 29 * result + (this.elementName != null ? this.elementName.hashCode() : 0);
            result = 29 * result + (this.typeName != null ? this.typeName.hashCode() : 0);
            result = 29 * result + (this.schemaUrl != null ? this.schemaUrl.hashCode() : 0);
            result = 29 * result + (this.provider != null ? this.provider.hashCode() : 0);
            return result;
        }
    }
}

