/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Iterator;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.HibernateIterator;
import org.hibernate.intercept.FieldInterceptionHelper;
import org.hibernate.intercept.FieldInterceptor;
import org.hibernate.lob.BlobImpl;
import org.hibernate.lob.ClobImpl;
import org.hibernate.lob.SerializableBlob;
import org.hibernate.lob.SerializableClob;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.AnyType;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.BigIntegerType;
import org.hibernate.type.BinaryType;
import org.hibernate.type.BlobType;
import org.hibernate.type.BooleanType;
import org.hibernate.type.ByteType;
import org.hibernate.type.CalendarDateType;
import org.hibernate.type.CalendarType;
import org.hibernate.type.CharacterType;
import org.hibernate.type.ClassType;
import org.hibernate.type.ClobType;
import org.hibernate.type.CompositeCustomType;
import org.hibernate.type.CurrencyType;
import org.hibernate.type.CustomType;
import org.hibernate.type.DateType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.FloatType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LocaleType;
import org.hibernate.type.LongType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.NullableType;
import org.hibernate.type.SerializableType;
import org.hibernate.type.ShortType;
import org.hibernate.type.StringType;
import org.hibernate.type.TextType;
import org.hibernate.type.TimeType;
import org.hibernate.type.TimeZoneType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.TrueFalseType;
import org.hibernate.type.Type;
import org.hibernate.type.YesNoType;
import org.hibernate.usertype.CompositeUserType;

public final class Hibernate {
    public static final NullableType LONG = new LongType();
    public static final NullableType SHORT = new ShortType();
    public static final NullableType INTEGER = new IntegerType();
    public static final NullableType BYTE = new ByteType();
    public static final NullableType FLOAT = new FloatType();
    public static final NullableType DOUBLE = new DoubleType();
    public static final NullableType CHARACTER = new CharacterType();
    public static final NullableType STRING = new StringType();
    public static final NullableType TIME = new TimeType();
    public static final NullableType DATE = new DateType();
    public static final NullableType TIMESTAMP = new TimestampType();
    public static final NullableType BOOLEAN = new BooleanType();
    public static final NullableType TRUE_FALSE = new TrueFalseType();
    public static final NullableType YES_NO = new YesNoType();
    public static final NullableType BIG_DECIMAL = new BigDecimalType();
    public static final NullableType BIG_INTEGER = new BigIntegerType();
    public static final NullableType BINARY = new BinaryType();
    public static final NullableType TEXT = new TextType();
    public static final Type BLOB = new BlobType();
    public static final Type CLOB = new ClobType();
    public static final NullableType CALENDAR = new CalendarType();
    public static final NullableType CALENDAR_DATE = new CalendarDateType();
    public static final NullableType LOCALE = new LocaleType();
    public static final NullableType CURRENCY = new CurrencyType();
    public static final NullableType TIMEZONE = new TimeZoneType();
    public static final NullableType CLASS = new ClassType();
    public static final NullableType SERIALIZABLE = new SerializableType(Serializable.class);
    public static final Type OBJECT = new AnyType();

    private Hibernate() {
        throw new UnsupportedOperationException();
    }

    public static Type serializable(Class serializableClass) {
        return new SerializableType(serializableClass);
    }

    public static Type any(Type metaType, Type identifierType) {
        return new AnyType(metaType, identifierType);
    }

    public static Type entity(Class persistentClass) {
        return new ManyToOneType(persistentClass.getName());
    }

    public static Type entity(String entityName) {
        return new ManyToOneType(entityName);
    }

    public static Type custom(Class userTypeClass) throws HibernateException {
        return Hibernate.custom(userTypeClass, null);
    }

    public static Type custom(Class userTypeClass, String[] parameterNames, String[] parameterValues) throws HibernateException {
        Properties parameters = new Properties();
        for (int i = 0; i < parameterNames.length; ++i) {
            parameters.setProperty(parameterNames[i], parameterValues[i]);
        }
        return Hibernate.custom(userTypeClass, parameters);
    }

    public static Type custom(Class userTypeClass, Properties parameters) throws HibernateException {
        if (CompositeUserType.class.isAssignableFrom(userTypeClass)) {
            CompositeCustomType type = new CompositeCustomType(userTypeClass, parameters);
            return type;
        }
        CustomType type = new CustomType(userTypeClass, parameters);
        return type;
    }

    public static void initialize(Object proxy) throws HibernateException {
        if (proxy == null) {
            return;
        }
        if (proxy instanceof HibernateProxy) {
            ((HibernateProxy)proxy).getHibernateLazyInitializer().initialize();
        } else if (proxy instanceof PersistentCollection) {
            ((PersistentCollection)proxy).forceInitialization();
        }
    }

    public static boolean isInitialized(Object proxy) {
        if (proxy instanceof HibernateProxy) {
            return !((HibernateProxy)proxy).getHibernateLazyInitializer().isUninitialized();
        }
        if (proxy instanceof PersistentCollection) {
            return ((PersistentCollection)proxy).wasInitialized();
        }
        return true;
    }

    public static Class getClass(Object proxy) {
        if (proxy instanceof HibernateProxy) {
            return ((HibernateProxy)proxy).getHibernateLazyInitializer().getImplementation().getClass();
        }
        return proxy.getClass();
    }

    public static Blob createBlob(byte[] bytes) {
        return new SerializableBlob(new BlobImpl(bytes));
    }

    public static Blob createBlob(InputStream stream, int length) {
        return new SerializableBlob(new BlobImpl(stream, length));
    }

    public static Blob createBlob(InputStream stream) throws IOException {
        return new SerializableBlob(new BlobImpl(stream, stream.available()));
    }

    public static Clob createClob(String string) {
        return new SerializableClob(new ClobImpl(string));
    }

    public static Clob createClob(Reader reader, int length) {
        return new SerializableClob(new ClobImpl(reader, length));
    }

    public static void close(Iterator iterator) throws HibernateException {
        if (!(iterator instanceof HibernateIterator)) {
            throw new IllegalArgumentException("not a Hibernate iterator");
        }
        ((HibernateIterator)iterator).close();
    }

    public static boolean isPropertyInitialized(Object proxy, String propertyName) {
        Object entity;
        if (proxy instanceof HibernateProxy) {
            LazyInitializer li = ((HibernateProxy)proxy).getHibernateLazyInitializer();
            if (li.isUninitialized()) {
                return false;
            }
            entity = li.getImplementation();
        } else {
            entity = proxy;
        }
        if (FieldInterceptionHelper.isInstrumented(entity)) {
            FieldInterceptor interceptor = FieldInterceptionHelper.extractFieldInterceptor(entity);
            return interceptor == null || interceptor.isInitialized(propertyName);
        }
        return true;
    }
}

