/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.spi;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import org.jboss.reflect.spi.TypeInfo;

public class PrimitiveInfo
implements TypeInfo,
Serializable {
    private static final long serialVersionUID = 3256718498443835449L;
    public static final PrimitiveInfo BOOLEAN = new PrimitiveInfo("boolean", 0, Boolean.TYPE);
    public static final PrimitiveInfo BYTE = new PrimitiveInfo("byte", 1, Byte.TYPE);
    public static final PrimitiveInfo CHAR = new PrimitiveInfo("char", 2, Character.TYPE);
    public static final PrimitiveInfo DOUBLE = new PrimitiveInfo("double", 3, Double.TYPE);
    public static final PrimitiveInfo FLOAT = new PrimitiveInfo("float", 4, Float.TYPE);
    public static final PrimitiveInfo INT = new PrimitiveInfo("int", 5, Integer.TYPE);
    public static final PrimitiveInfo LONG = new PrimitiveInfo("long", 6, Long.TYPE);
    public static final PrimitiveInfo SHORT = new PrimitiveInfo("short", 7, Short.TYPE);
    public static final PrimitiveInfo VOID = new PrimitiveInfo("void", 8, Void.TYPE);
    private static final PrimitiveInfo[] values = new PrimitiveInfo[]{BOOLEAN, BYTE, CHAR, DOUBLE, FLOAT, INT, LONG, SHORT, VOID};
    protected final transient String name;
    protected final int ordinal;
    protected final transient Class type;
    private static HashMap map = new HashMap();

    public static PrimitiveInfo valueOf(String name) {
        return (PrimitiveInfo)map.get(name);
    }

    protected PrimitiveInfo(String name, int ordinal, Class type) {
        this.name = name;
        this.ordinal = ordinal;
        this.type = type;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrimitiveInfo)) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        PrimitiveInfo other = (PrimitiveInfo)obj;
        return other.ordinal == this.ordinal;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    Object readResolve() throws ObjectStreamException {
        return values[this.ordinal];
    }

    static {
        map.put("boolean", BOOLEAN);
        map.put("byte", BYTE);
        map.put("char", CHAR);
        map.put("double", DOUBLE);
        map.put("float", FLOAT);
        map.put("int", INT);
        map.put("long", LONG);
        map.put("short", SHORT);
        map.put("void", VOID);
    }
}

