/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.transporter.complex.client;

import org.jboss.remoting.samples.transporter.complex.Doctor;
import org.jboss.remoting.samples.transporter.complex.NoDoctorAvailableException;
import org.jboss.remoting.samples.transporter.complex.Patient;
import org.jboss.remoting.samples.transporter.complex.ProviderInterface;
import org.jboss.remoting.transporter.TransporterClient;

public class Client {
    private String locatorURI = "socket://localhost:5401/?serializationtype=jboss";
    static /* synthetic */ Class class$org$jboss$remoting$samples$transporter$complex$ProviderInterface;

    public void makeClientCall() throws Exception {
        Patient patient = new Patient("Bill", "Gates");
        patient.setAilmentType("financial");
        patient.setAilmentDescription("Money coming out the wazoo.");
        System.out.println("*** Have a new patient that needs a doctor.  The patient is:\n" + patient);
        ProviderInterface providerProcessor = (ProviderInterface)TransporterClient.createTransporterClient(this.locatorURI, class$org$jboss$remoting$samples$transporter$complex$ProviderInterface == null ? (class$org$jboss$remoting$samples$transporter$complex$ProviderInterface = Client.class$("org.jboss.remoting.samples.transporter.complex.ProviderInterface")) : class$org$jboss$remoting$samples$transporter$complex$ProviderInterface);
        try {
            System.out.println("*** Looking for doctor that can help our patient...\n");
            Doctor doctor = providerProcessor.findDoctor(patient);
            System.out.println("*** Found doctor for our patient.  Doctor found is:\n" + doctor);
            patient.setDoctor(doctor);
            System.out.println("*** Set doctor as patient's doctor.  Patient info is now:\n" + patient);
            providerProcessor.retireDoctor(doctor);
            Patient patient2 = new Patient("Larry", "Page");
            patient2.setAilmentType("financial");
            patient2.setAilmentDescription("Money coming out the wazoo.");
            System.out.println("*** Have a new patient that we need to find a doctor for (remember, the previous one retired and there are no others)");
            providerProcessor.findDoctor(patient2);
        }
        catch (NoDoctorAvailableException e) {
            System.out.println("*** Could not find doctor for patient.  This is an expected exception when there are not doctors available.");
            e.printStackTrace();
        }
        TransporterClient.destroyTransporterClient(providerProcessor);
    }

    public static void main(String[] args) {
        Client client = new Client();
        try {
            client.makeClientCall();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

